/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe;

import dev.failsafe.BulkheadBuilder;
import dev.failsafe.BulkheadConfig;
import dev.failsafe.BulkheadFullException;
import dev.failsafe.Policy;
import dev.failsafe.internal.BulkheadImpl;
import java.time.Duration;

public interface Bulkhead<R>
extends Policy<R> {
    public static <R> BulkheadBuilder<R> builder(int maxConcurrency) {
        return new BulkheadBuilder(maxConcurrency);
    }

    public static <R> BulkheadBuilder<R> builder(BulkheadConfig<R> config) {
        return new BulkheadBuilder<R>(config);
    }

    public static <R> Bulkhead<R> of(int maxConcurrency) {
        return new BulkheadImpl(new BulkheadConfig(maxConcurrency));
    }

    @Override
    public BulkheadConfig<R> getConfig();

    public void acquirePermit() throws InterruptedException;

    default public void acquirePermit(Duration maxWaitTime) throws InterruptedException {
        if (!this.tryAcquirePermit(maxWaitTime)) {
            throw new BulkheadFullException(this);
        }
    }

    public boolean tryAcquirePermit();

    public boolean tryAcquirePermit(Duration var1) throws InterruptedException;

    public void releasePermit();
}

