/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerMethodName;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableBackgroundEvent;
import org.apache.kafka.common.TopicPartition;

public class ConsumerRebalanceListenerCallbackNeededEvent
extends CompletableBackgroundEvent<Void> {
    private final ConsumerRebalanceListenerMethodName methodName;
    private final SortedSet<TopicPartition> partitions;

    public ConsumerRebalanceListenerCallbackNeededEvent(ConsumerRebalanceListenerMethodName methodName, SortedSet<TopicPartition> partitions) {
        super(BackgroundEvent.Type.CONSUMER_REBALANCE_LISTENER_CALLBACK_NEEDED, Long.MAX_VALUE);
        this.methodName = Objects.requireNonNull(methodName);
        this.partitions = Collections.unmodifiableSortedSet(partitions);
    }

    public ConsumerRebalanceListenerMethodName methodName() {
        return this.methodName;
    }

    public SortedSet<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", methodName=" + (Object)((Object)this.methodName) + ", partitions=" + this.partitions;
    }
}

