/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.config.internal.Tests$;
import org.apache.kyuubi.util.command.CommandLineUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private AtomicLong tempFileIdCounter;
    private final int MAX_DIR_CREATION_ATTEMPTS;
    private final Regex shortVersionRegex;
    private final boolean isWindows;
    private final boolean isMac;
    private final int DEFAULT_SHUTDOWN_PRIORITY;
    private final int SERVER_SHUTDOWN_PRIORITY;
    private final int SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    private final int FLINK_ENGINE_SHUTDOWN_PRIORITY;
    private final int TRINO_ENGINE_SHUTDOWN_PRIORITY;
    private final int JDBC_ENGINE_SHUTDOWN_PRIORITY;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private AtomicLong tempFileIdCounter$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.tempFileIdCounter = new AtomicLong(0L);
                this.bitmap$0 = true;
            }
        }
        return this.tempFileIdCounter;
    }

    private AtomicLong tempFileIdCounter() {
        if (!this.bitmap$0) {
            return this.tempFileIdCounter$lzycompute();
        }
        return this.tempFileIdCounter;
    }

    public Seq<String> strToSeq(String s, String sp) {
        Predef$.MODULE$.require(s != null);
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(sp))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$strToSeq$2(x$2))));
    }

    public String strToSeq$default$2() {
        return ",";
    }

    public Map<String, String> getSystemProperties() {
        return package$.MODULE$.props().toMap(Predef$.MODULE$.$conforms());
    }

    public Option<File> getDefaultPropertiesFile(Map<String, String> env) {
        return this.getPropertiesFile("kyuubi-defaults.conf", env);
    }

    public Map<String, String> getDefaultPropertiesFile$default$1() {
        return package$.MODULE$.env();
    }

    public Option<File> getPropertiesFile(String fileName, Map<String, String> env) {
        return env.get((Object)"KYUUBI_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"KYUUBI_HOME").map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(4).append((String)x$3).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)d -> new File(new StringBuilder(0).append((String)d).append(File.separator).append(fileName).toString())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)MODULE$.getContextOrKyuubiClassLoader().getResource(fileName)).map((Function1 & Serializable & scala.Serializable)url -> new File(url.getFile())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists())));
    }

    public Map<String, String> getPropertiesFile$default$2() {
        return package$.MODULE$.env();
    }

    public Map<String, String> getPropertiesFromFile(Option<File> file) {
        return (Map)file.map((Function1 & Serializable & scala.Serializable)f -> {
            Map map;
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Loading Kyuubi properties from ").append(f.getAbsolutePath()).toString());
            try (InputStreamReader reader = new InputStreamReader(f.toURI().toURL().openStream(), StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(reader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new KyuubiException(new StringBuilder(43).append("Failed when loading Kyuubi properties from ").append(f.getAbsolutePath()).toString(), e);
            }
            return map;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private int MAX_DIR_CREATION_ATTEMPTS() {
        return this.MAX_DIR_CREATION_ATTEMPTS;
    }

    public Path createDirectory(String root, String namePrefix) {
        Object object = new Object();
        try {
            ObjectRef error = ObjectRef.create(null);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_DIR_CREATION_ATTEMPTS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> {
                Path candidate = Paths.get(root, new StringBuilder(1).append(namePrefix).append("-").append(UUID.randomUUID()).toString());
                try {
                    Path path = Files.createDirectories(candidate, new FileAttribute[0]);
                    throw new NonLocalReturnControl(object, (Object)path);
                }
                catch (IOException e) {
                    error$1.elem = e;
                    return;
                }
            });
            throw new IOException(new StringBuilder(59).append("Failed to create a temp directory (under ").append(root).append(") after ").append(this.MAX_DIR_CREATION_ATTEMPTS()).append(" attempts!").toString(), (Exception)error.elem);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Path)ex.value();
        }
    }

    public String createDirectory$default$2() {
        return "kyuubi";
    }

    public Path getAbsolutePathFromWork(String pathStr, Map<String, String> env) {
        String string;
        Path path = Paths.get(pathStr, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        Option option = env.get((Object)"KYUUBI_WORK_DIR_ROOT");
        if (option instanceof Some) {
            String dir;
            Some some = (Some)option;
            string = dir = (String)some.value();
        } else {
            string = System.getProperty("user.dir");
        }
        String workDir = string;
        return Paths.get(workDir, pathStr);
    }

    public Map<String, String> getAbsolutePathFromWork$default$2() {
        return package$.MODULE$.env();
    }

    public boolean deleteDirectoryRecursively(File f2) {
        block1: {
            if (!f2.isDirectory()) break block1;
            File[] fileArray = f2.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileArray2)).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(f)));
            }
        }
        return f2.delete();
    }

    public Path createTempDir(String prefix, String root) {
        Path dir = this.createDirectory(root, prefix);
        dir.toFile().deleteOnExit();
        return dir;
    }

    public String createTempDir$default$1() {
        return "kyuubi";
    }

    public String createTempDir$default$2() {
        return System.getProperty("java.io.tmpdir");
    }

    public Seq<File> listFilesRecursively(File file2) {
        if (!file2.isDirectory()) {
            File file3 = file2;
            return Nil$.MODULE$.$colon$colon((Object)file3);
        }
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles())).flatMap((Function1 & Serializable & scala.Serializable)file -> MODULE$.listFilesRecursively((File)file), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public File writeToTempFile(InputStream source, Path dir, String fileName) {
        File file;
        try {
            Tuple2 tuple2;
            if (source == null) {
                throw new IOException("the source inputstream is null");
            }
            Object object = !dir.toFile().exists() ? BoxesRunTime.boxToBoolean((boolean)dir.toFile().mkdirs()) : BoxedUnit.UNIT;
            int n = fileName.lastIndexOf(".");
            switch (n) {
                default: 
            }
            Tuple2 tuple22 = tuple2 = n > 0 ? new Tuple2((Object)fileName.substring(0, n), (Object)fileName.substring(n)) : new Tuple2((Object)fileName, (Object)"");
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String prefix = (String)tuple2._1();
            String suffix = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)prefix, (Object)suffix);
            String prefix2 = (String)tuple23._1();
            String suffix2 = (String)tuple23._2();
            String currentTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String identifier = new StringBuilder(1).append(currentTime).append("-").append(this.tempFileIdCounter().incrementAndGet()).toString();
            Path filePath = Paths.get(((Object)dir).toString(), new StringBuilder(1).append(prefix2).append("-").append(identifier).append(suffix2).toString());
            try {
                Files.copy(source, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                source.close();
            }
            File file2 = filePath.toFile();
            file2.deleteOnExit();
            file = file2;
        }
        catch (Exception e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("failed to write to temp file in path ").append(dir).append(", original file name: ").append(fileName).toString(), e);
            throw e;
        }
        return file;
    }

    public String currentUser() {
        return UserGroupInformation.getCurrentUser().getShortUserName();
    }

    public <T> T doAs(String proxyUser, UserGroupInformation realUser, Function0<T> f) {
        return (T)UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)realUser).doAs(new PrivilegedAction<T>(f){
            private final Function0 f$2;

            public T run() {
                return (T)this.f$2.apply();
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    public <T> UserGroupInformation doAs$default$2() {
        return UserGroupInformation.getCurrentUser();
    }

    private Regex shortVersionRegex() {
        return this.shortVersionRegex;
    }

    public String shortVersion(String version) {
        Option option = this.shortVersionRegex().findFirstMatchIn((CharSequence)version);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return m.group(1);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(113).append("Tried to parse '").append(version).append("' as a project").append(" version string, but it could not find the major/minor/maintenance version numbers.").toString());
        }
        throw new MatchError((Object)option);
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isTesting() {
        return System.getProperty(Tests$.MODULE$.IS_TESTING().key()) != null;
    }

    public int DEFAULT_SHUTDOWN_PRIORITY() {
        return this.DEFAULT_SHUTDOWN_PRIORITY;
    }

    public int SERVER_SHUTDOWN_PRIORITY() {
        return this.SERVER_SHUTDOWN_PRIORITY;
    }

    public int SPARK_CONTEXT_SHUTDOWN_PRIORITY() {
        return this.SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    }

    public int FLINK_ENGINE_SHUTDOWN_PRIORITY() {
        return this.FLINK_ENGINE_SHUTDOWN_PRIORITY;
    }

    public int TRINO_ENGINE_SHUTDOWN_PRIORITY() {
        return this.TRINO_ENGINE_SHUTDOWN_PRIORITY;
    }

    public int JDBC_ENGINE_SHUTDOWN_PRIORITY() {
        return this.JDBC_ENGINE_SHUTDOWN_PRIORITY;
    }

    public void addShutdownHook(Runnable hook, int priority) {
        ShutdownHookManager.get().addShutdownHook(hook, priority);
    }

    public int addShutdownHook$default$2() {
        return this.DEFAULT_SHUTDOWN_PRIORITY();
    }

    /*
     * WARNING - void declaration
     */
    public InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            void var2_2;
            InetAddress address = InetAddress.getLocalHost();
            if (address.isLoopbackAddress()) {
                Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                reOrderedNetworkIFs.foreach((Function1 & Serializable & scala.Serializable)ni -> {
                    Utils$.$anonfun$findLocalInetAddress$1(address, object, ni);
                    return BoxedUnit.UNIT;
                });
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append(address.getHostName()).append(" was resolved to a loopback address: ").append(address.getHostAddress()).append(" but we couldn't find any external IP address!").toString());
            }
            inetAddress = var2_2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    public String getDateFromTimestamp(long time) {
        return DateFormatUtils.format((long)time, (String)"yyyyMMdd", (TimeZone)TimeZone.getDefault());
    }

    public String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), t);
            }
            throw throwable;
        }
    }

    public void fromCommandLineArgs(String[] args, KyuubiConf conf) {
        Predef$.MODULE$.require(args.length % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> "Illegal size of arguments.");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().by(2).foreach((Function1 & Serializable & scala.Serializable)i -> Utils$.$anonfun$fromCommandLineArgs$2(args, conf, BoxesRunTime.unboxToInt((Object)i)));
    }

    public Iterable<String> redactCommandLineArgs(KyuubiConf conf, Iterable<String> commands) {
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.SERVER_SECRET_REDACTION_PATTERN());
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex redactionPattern = (Regex)some.value();
            BooleanRef nextKV = BooleanRef.create((boolean)false);
            return (Iterable)commands.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                Option option = CommandLineUtils$.MODULE$.PATTERN_FOR_KEY_VALUE_ARG().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                    if (nextKV$1.elem) {
                        Tuple2 tuple2 = (Tuple2)MODULE$.redact(redactionPattern, (Seq)new .colon.colon((Object)new Tuple2((Object)key, (Object)value), (List)Nil$.MODULE$)).head();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String newValue = (String)tuple2._2();
                        String newValue2 = newValue;
                        nextKV$1.elem = false;
                        return CommandLineUtils$.MODULE$.genKeyValuePair(key, newValue2);
                    }
                }
                String string2 = string;
                String string3 = CommandLineUtils$.MODULE$.CONF();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    nextKV$1.elem = true;
                    return string;
                }
                return string;
            }, Iterable$.MODULE$.canBuildFrom());
        }
        return commands;
    }

    public <K, V> Seq<Tuple2<K, V>> redact(Option<Regex> regex, Seq<Tuple2<K, V>> kvs) {
        Option<Regex> option = regex;
        if (None$.MODULE$.equals(option)) {
            return kvs;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex r = (Regex)some.value();
            return this.redact(r, kvs);
        }
        throw new MatchError(option);
    }

    private <K, V> Seq<Tuple2<K, V>> redact(Regex redactionPattern, Seq<Tuple2<K, V>> kvs) {
        return (Seq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (key instanceof String) {
                    String string = (String)key;
                    if (value instanceof String) {
                        String string2 = (String)value;
                        return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).orElse((Function0 & Serializable & scala.Serializable)() -> redactionPattern.findFirstIn((CharSequence)string2)).map((Function1 & Serializable & scala.Serializable)x$11 -> new Tuple2((Object)string, (Object)CommandLineUtils$.MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)string, (Object)string2));
                    }
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).map((Function1 & Serializable & scala.Serializable)x$12 -> new Tuple2(key, (Object)CommandLineUtils$.MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2(key, (Object)string));
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                return new Tuple2(key, value);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean isCommandAvailable(String cmd) {
        return scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(6).append("which ").append(cmd).toString()).$bang() == 0;
    }

    public ClassLoader getKyuubiClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getContextOrKyuubiClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getKyuubiClassLoader());
    }

    public boolean isOnK8s() {
        return Files.exists(Paths.get("/var/run/secrets/kubernetes.io", new String[0]), new LinkOption[0]);
    }

    public String prettyPrint(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public <T> T withLockRequired(Lock lock, Function0<T> block) {
        Object object;
        try {
            lock.lock();
            object = block.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public Option<Object> terminateProcess(Process process, long gracefulPeriod) {
        process.destroy();
        if (process.waitFor(gracefulPeriod, TimeUnit.MILLISECONDS)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        }
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Process does not exit after ").append(gracefulPeriod).append(" ms, try to forcibly kill. ").append("Staging files generated by the process may be retained!").toString());
        process.destroyForcibly();
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$strToSeq$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$9) {
        return x$9 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey2$1, NetworkInterface ni) {
        Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$3(x$9))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append(address$1.getHostName()).append(" was resolved to a loopback address: ").append(address$1.getHostAddress()).append(", using ").append(strippedAddress.getHostAddress()).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)strippedAddress);
        }
    }

    public static final /* synthetic */ KyuubiConf $anonfun$fromCommandLineArgs$2(String[] args$1, KyuubiConf conf$1, int i) {
        String string = args$1[i];
        String string2 = CommandLineUtils$.MODULE$.CONF();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unrecognized main arguments prefix ").append(args$1[i]).append(",").append("the argument format is '--conf k=v'.").toString());
        String[] stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$1[i + 1].split("=", 2))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (stringArray.length == 2) {
            return conf$1.set((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).head(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).last());
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Illegal argument: ").append(args$1[i + 1]).append(".").toString());
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MAX_DIR_CREATION_ATTEMPTS = 10;
        this.shortVersionRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+\\.\\d+\\.\\d+)(.*)?$")).r();
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC;
        this.DEFAULT_SHUTDOWN_PRIORITY = 100;
        this.SERVER_SHUTDOWN_PRIORITY = 75;
        this.SPARK_CONTEXT_SHUTDOWN_PRIORITY = 50;
        this.FLINK_ENGINE_SHUTDOWN_PRIORITY = 50;
        this.TRINO_ENGINE_SHUTDOWN_PRIORITY = 50;
        this.JDBC_ENGINE_SHUTDOWN_PRIORITY = 50;
    }
}

