/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.KubernetesVersionFactory;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KubernetesVersionPriority {
    private KubernetesVersionPriority() {
    }

    public static String highestPriority(List<String> versions) {
        List<KubernetesVersionFactory.Version> byPriority = KubernetesVersionPriority.sortByPriority(versions);
        if (byPriority.isEmpty()) {
            return null;
        }
        return byPriority.get(0).getFull();
    }

    private static List<KubernetesVersionFactory.Version> sortByPriority(List<String> versions) {
        if (versions == null || versions.isEmpty()) {
            return Collections.emptyList();
        }
        return versions.stream().map(KubernetesVersionFactory::create).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }

    public static <T> List<T> sortByPriority(List<T> resources, Function<T, String> versionProvider) {
        Utils.checkNotNull(versionProvider, "versionProvider function can't be null");
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        return resources.stream().sorted(Comparator.comparing(o -> KubernetesVersionFactory.create((String)versionProvider.apply(o)), Comparator.reverseOrder())).collect(Collectors.toList());
    }
}

