/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene103;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;

final class PostingDecodingUtil {
    public final IndexInput in;

    PostingDecodingUtil(IndexInput in) {
        this.in = in;
    }

    public void splitInts(int count, int[] b, int bShift, int dec, int bMask, int[] c, int cIndex, int cMask) throws IOException {
        this.in.readInts(c, cIndex, count);
        int maxIter = (bShift - 1) / dec;
        for (int j = 0; j <= maxIter; ++j) {
            int shift = bShift - j * dec;
            int bOffset = count * j;
            for (int i = 0; i < count; ++i) {
                b[bOffset + i] = c[cIndex + i] >>> shift & bMask;
            }
        }
        for (int i = 0; i < count; ++i) {
            int n = cIndex + i;
            c[n] = c[n] & cMask;
        }
    }
}

