/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;

public class SimpleSortedSetFacetsExample {
    private final Directory indexDir = new ByteBuffersDirectory();
    private final FacetsConfig config = new FacetsConfig();

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Author", new String[]{"Bob"}));
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Publish Year", new String[]{"2010"}));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Author", new String[]{"Lisa"}));
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Publish Year", new String[]{"2010"}));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Author", new String[]{"Lisa"}));
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Publish Year", new String[]{"2012"}));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Author", new String[]{"Susan"}));
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Publish Year", new String[]{"2012"}));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Author", new String[]{"Frank"}));
        doc.add((IndexableField)new SortedSetDocValuesFacetField("Publish Year", new String[]{"1999"}));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        indexWriter.close();
    }

    private List<FacetResult> search() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DefaultSortedSetDocValuesReaderState state = new DefaultSortedSetDocValuesReaderState((IndexReader)indexReader, this.config);
        FacetsCollectorManager fcm = new FacetsCollectorManager();
        FacetsCollector fc = FacetsCollectorManager.search((IndexSearcher)searcher, (Query)MatchAllDocsQuery.INSTANCE, (int)10, (FacetsCollectorManager)fcm).facetsCollector();
        SortedSetDocValuesFacetCounts facets = new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)state, fc);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        results.add(facets.getTopChildren(10, "Author", new String[0]));
        results.add(facets.getTopChildren(10, "Publish Year", new String[0]));
        indexReader.close();
        return results;
    }

    private FacetResult drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DefaultSortedSetDocValuesReaderState state = new DefaultSortedSetDocValuesReaderState((IndexReader)indexReader, this.config);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("Publish Year", new String[]{"2010"});
        FacetsCollectorManager fcm = new FacetsCollectorManager();
        FacetsCollector fc = FacetsCollectorManager.search((IndexSearcher)searcher, (Query)q, (int)10, (FacetsCollectorManager)fcm).facetsCollector();
        SortedSetDocValuesFacetCounts facets = new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)state, fc);
        FacetResult result = facets.getTopChildren(10, "Author", new String[0]);
        indexReader.close();
        return result;
    }

    public List<FacetResult> runSearch() throws IOException {
        this.index();
        return this.search();
    }

    public FacetResult runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        SimpleSortedSetFacetsExample example = new SimpleSortedSetFacetsExample();
        List<FacetResult> results = example.runSearch();
        System.out.println("Author: " + String.valueOf(results.get(0)));
        System.out.println("Publish Year: " + String.valueOf(results.get(1)));
        System.out.println("\n");
        System.out.println("Facet drill-down example (Publish Year/2010):");
        System.out.println("---------------------------------------------");
        System.out.println("Author: " + String.valueOf(example.runDrillDown()));
    }
}

