/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.openpgp.api.exception.IncorrectOpenPGPSignatureException;
import org.bouncycastle.openpgp.api.exception.MalformedOpenPGPSignatureException;
import org.bouncycastle.openpgp.api.exception.MissingIssuerCertException;
import org.bouncycastle.openpgp.api.util.UTCUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;

public class OpenPGPCertificate {
    final OpenPGPImplementation implementation;
    final OpenPGPPolicy policy;
    protected PGPKeyRing keyRing;
    private final OpenPGPPrimaryKey primaryKey;
    private final Map<KeyIdentifier, OpenPGPSubkey> subkeys;
    private final Map<OpenPGPCertificateComponent, OpenPGPSignatureChains> componentSignatureChains;

    public OpenPGPCertificate(PGPKeyRing pGPKeyRing) {
        this(pGPKeyRing, OpenPGPImplementation.getInstance());
    }

    public OpenPGPCertificate(PGPKeyRing pGPKeyRing, OpenPGPImplementation openPGPImplementation) {
        this(pGPKeyRing, openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPCertificate(PGPKeyRing pGPKeyRing, OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        this.implementation = openPGPImplementation;
        this.policy = openPGPPolicy;
        this.keyRing = pGPKeyRing;
        this.subkeys = new LinkedHashMap<KeyIdentifier, OpenPGPSubkey>();
        this.componentSignatureChains = new LinkedHashMap<OpenPGPCertificateComponent, OpenPGPSignatureChains>();
        Iterator<PGPPublicKey> iterator = pGPKeyRing.getPublicKeys();
        PGPPublicKey pGPPublicKey = iterator.next();
        this.primaryKey = new OpenPGPPrimaryKey(pGPPublicKey, this);
        this.processPrimaryKey(this.primaryKey);
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey2 = iterator.next();
            OpenPGPSubkey openPGPSubkey = new OpenPGPSubkey(pGPPublicKey2, this);
            this.subkeys.put(pGPPublicKey2.getKeyIdentifier(), openPGPSubkey);
            this.processSubkey(openPGPSubkey);
        }
    }

    public boolean isSecretKey() {
        return false;
    }

    public List<OpenPGPUserId> getAllUserIds() {
        return this.getPrimaryKey().getUserIDs();
    }

    public List<OpenPGPUserId> getValidUserIds() {
        return this.getValidUserIds(new Date());
    }

    public List<OpenPGPUserId> getValidUserIds(Date date) {
        return this.getPrimaryKey().getValidUserIDs(date);
    }

    public Map<KeyIdentifier, OpenPGPComponentKey> getPublicKeys() {
        LinkedHashMap<KeyIdentifier, OpenPGPComponentKey> linkedHashMap = new LinkedHashMap<KeyIdentifier, OpenPGPComponentKey>();
        linkedHashMap.put(this.primaryKey.getKeyIdentifier(), this.primaryKey);
        linkedHashMap.putAll(this.subkeys);
        return linkedHashMap;
    }

    public OpenPGPPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<KeyIdentifier, OpenPGPSubkey> getSubkeys() {
        return new LinkedHashMap<KeyIdentifier, OpenPGPSubkey>(this.subkeys);
    }

    public List<OpenPGPComponentKey> getComponentKeysWithFlag(Date date, final int ... nArray) {
        return this.filterKeys(date, new KeyFilter(){
            final /* synthetic */ OpenPGPCertificate this$0;
            {
                this.this$0 = openPGPCertificate;
            }

            @Override
            public boolean test(OpenPGPComponentKey openPGPComponentKey, Date date) {
                return openPGPComponentKey.hasKeyFlags(date, nArray);
            }
        });
    }

    public List<OpenPGPCertificateComponent> getComponents() {
        return new ArrayList<OpenPGPCertificateComponent>(this.componentSignatureChains.keySet());
    }

    public List<OpenPGPComponentKey> getKeys() {
        ArrayList<OpenPGPComponentKey> arrayList = new ArrayList<OpenPGPComponentKey>();
        arrayList.add(this.primaryKey);
        arrayList.addAll(this.subkeys.values());
        return arrayList;
    }

    public List<OpenPGPComponentKey> getValidKeys() {
        return this.getValidKeys(new Date());
    }

    public List<OpenPGPComponentKey> getValidKeys(Date date) {
        return this.filterKeys(date, new KeyFilter(){

            @Override
            public boolean test(OpenPGPComponentKey openPGPComponentKey, Date date) {
                return true;
            }
        });
    }

    public OpenPGPComponentKey getKey(KeyIdentifier keyIdentifier) {
        if (keyIdentifier.matchesExplicit(this.getPrimaryKey().getPGPPublicKey().getKeyIdentifier())) {
            return this.primaryKey;
        }
        return this.subkeys.get(keyIdentifier);
    }

    public OpenPGPComponentKey getSigningKeyFor(PGPSignature pGPSignature) {
        List<KeyIdentifier> list = pGPSignature.getKeyIdentifiers();
        int n = pGPSignature.getSignatureType();
        if (n == 24 || n == 40) {
            return this.primaryKey;
        }
        if (KeyIdentifier.matches(list, this.getPrimaryKey().getKeyIdentifier(), true)) {
            return this.primaryKey;
        }
        for (KeyIdentifier keyIdentifier : this.subkeys.keySet()) {
            if (!KeyIdentifier.matches(list, keyIdentifier, true)) continue;
            return this.subkeys.get(keyIdentifier);
        }
        return null;
    }

    public PGPKeyRing getPGPKeyRing() {
        return this.keyRing;
    }

    public PGPPublicKeyRing getPGPPublicKeyRing() {
        if (this.keyRing instanceof PGPPublicKeyRing) {
            return (PGPPublicKeyRing)this.keyRing;
        }
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> iterator = this.keyRing.getPublicKeys();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.primaryKey.getKeyIdentifier();
    }

    public List<KeyIdentifier> getAllKeyIdentifiers() {
        ArrayList<KeyIdentifier> arrayList = new ArrayList<KeyIdentifier>();
        Iterator<PGPPublicKey> iterator = this.keyRing.getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = iterator.next();
            arrayList.add(pGPPublicKey.getKeyIdentifier());
        }
        return arrayList;
    }

    public OpenPGPComponentSignature getCertification() {
        return this.getCertification(new Date());
    }

    public OpenPGPComponentSignature getCertification(Date date) {
        return this.primaryKey.getCertification(date);
    }

    public OpenPGPComponentSignature getRevocation() {
        return this.getRevocation(new Date());
    }

    public OpenPGPComponentSignature getRevocation(Date date) {
        return this.primaryKey.getRevocation(date);
    }

    public Date getLastModificationDate() {
        return this.getLastModificationDateAt(new Date());
    }

    public Date getLastModificationDateAt(Date date) {
        Date date2 = null;
        Iterator<OpenPGPCertificateComponent> iterator = this.getComponents().iterator();
        while (iterator.hasNext()) {
            OpenPGPSignatureChains object = this.getAllSignatureChainsFor(iterator.next());
            object = object.getChainsAt(date);
            Iterator<OpenPGPSignatureChain> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                for (OpenPGPSignatureChain.Link link : iterator2.next()) {
                    if (date2 != null && !link.since().after(date2)) continue;
                    date2 = link.since();
                }
            }
        }
        if (date2 != null) {
            return date2;
        }
        for (OpenPGPComponentKey openPGPComponentKey : this.getKeys()) {
            if (openPGPComponentKey.getCreationTime().after(date) || date2 != null && !openPGPComponentKey.getCreationTime().after(date2)) continue;
            date2 = openPGPComponentKey.getCreationTime();
        }
        return date2;
    }

    public static OpenPGPCertificate join(OpenPGPCertificate openPGPCertificate, String string) throws IOException, PGPException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputStream inputStream = PGPUtil.getDecoderStream(byteArrayInputStream);
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
        PGPObjectFactory pGPObjectFactory = openPGPCertificate.implementation.pgpObjectFactory(bCPGInputStream);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            Object object2;
            Object object3;
            if (object instanceof PGPPublicKeyRing) {
                object3 = (PGPPublicKeyRing)object;
                object2 = new OpenPGPCertificate((PGPKeyRing)object3, openPGPCertificate.implementation);
                try {
                    return OpenPGPCertificate.join(openPGPCertificate, (OpenPGPCertificate)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
            }
            if (object instanceof PGPSecretKeyRing) {
                throw new IllegalArgumentException("Joining with a secret key is not supported.");
            }
            if (!(object instanceof PGPSignatureList)) continue;
            object3 = (PGPSignatureList)object;
            object2 = openPGPCertificate.getPGPPublicKeyRing();
            PGPPublicKey pGPPublicKey = ((PGPPublicKeyRing)object2).getPublicKey();
            Iterator<PGPSignature> iterator = ((PGPSignatureList)object3).iterator();
            while (iterator.hasNext()) {
                pGPPublicKey = PGPPublicKey.addCertification(pGPPublicKey, iterator.next());
            }
            object2 = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)object2, pGPPublicKey);
            return new OpenPGPCertificate((PGPKeyRing)object2, openPGPCertificate.implementation);
        }
        return null;
    }

    public static OpenPGPCertificate join(OpenPGPCertificate openPGPCertificate, OpenPGPCertificate openPGPCertificate2) throws PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = PGPPublicKeyRing.join(openPGPCertificate.getPGPPublicKeyRing(), openPGPCertificate2.getPGPPublicKeyRing());
        return new OpenPGPCertificate(pGPPublicKeyRing, openPGPCertificate.implementation);
    }

    public byte[] getFingerprint() {
        return this.primaryKey.getPGPPublicKey().getFingerprint();
    }

    public String getPrettyFingerprint() {
        return FingerprintUtil.prettifyFingerprint(this.getFingerprint());
    }

    public String toAsciiArmoredString() throws IOException {
        return this.toAsciiArmoredString(PacketFormat.ROUNDTRIP);
    }

    public String toAsciiArmoredString(PacketFormat packetFormat) throws IOException {
        ArmoredOutputStream.Builder builder = ArmoredOutputStream.builder().clearHeaders();
        builder.addSplitMultilineComment(this.getPrettyFingerprint());
        Iterator<OpenPGPUserId> iterator = this.getPrimaryKey().getUserIDs().iterator();
        while (iterator.hasNext()) {
            builder.addEllipsizedComment(iterator.next().getUserId());
        }
        return this.toAsciiArmoredString(packetFormat, builder);
    }

    public String toAsciiArmoredString(PacketFormat packetFormat, ArmoredOutputStream.Builder builder) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOutputStream = builder.build(byteArrayOutputStream);
        armoredOutputStream.write(this.getEncoded(packetFormat));
        armoredOutputStream.close();
        return byteArrayOutputStream.toString();
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)byteArrayOutputStream, packetFormat);
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Object object = this.getPGPKeyRing().getPublicKeys();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = new PGPPublicKeyRing(arrayList);
        ((PGPPublicKeyRing)object).encode(bCPGOutputStream, true);
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private OpenPGPSignatureChain getSignatureChainFor(OpenPGPCertificateComponent openPGPCertificateComponent, OpenPGPComponentKey openPGPComponentKey, Date date) {
        Object object;
        boolean bl;
        OpenPGPSignatureChains openPGPSignatureChains = this.getAllSignatureChainsFor(openPGPCertificateComponent);
        boolean bl2 = bl = openPGPCertificateComponent == this.getPrimaryKey();
        if (bl && openPGPSignatureChains.getCertificationAt(date) == null && (object = this.getPrimaryUserId(date)) != null) {
            openPGPSignatureChains.addAll(this.getAllSignatureChainsFor((OpenPGPCertificateComponent)object));
        }
        if ((object = openPGPSignatureChains.fromOrigin(openPGPComponentKey)) == null) {
            return null;
        }
        return ((OpenPGPSignatureChains)object).getChainAt(date);
    }

    private OpenPGPSignatureChains getAllSignatureChainsFor(OpenPGPCertificateComponent openPGPCertificateComponent) {
        OpenPGPSignatureChains openPGPSignatureChains = new OpenPGPSignatureChains(openPGPCertificateComponent.getPublicComponent());
        openPGPSignatureChains.addAll(this.componentSignatureChains.get(openPGPCertificateComponent.getPublicComponent()));
        return openPGPSignatureChains;
    }

    private void processPrimaryKey(OpenPGPPrimaryKey openPGPPrimaryKey) {
        OpenPGPSignatureChains openPGPSignatureChains = new OpenPGPSignatureChains(openPGPPrimaryKey);
        List<OpenPGPComponentSignature> list = openPGPPrimaryKey.getKeySignatures();
        this.addSignaturesToChains(list, openPGPSignatureChains);
        this.componentSignatureChains.put(openPGPPrimaryKey, openPGPSignatureChains);
        for (OpenPGPIdentityComponent openPGPIdentityComponent : openPGPPrimaryKey.identityComponents) {
            OpenPGPSignatureChains openPGPSignatureChains2 = new OpenPGPSignatureChains(openPGPIdentityComponent);
            List<OpenPGPComponentSignature> list2 = openPGPIdentityComponent instanceof OpenPGPUserId ? openPGPPrimaryKey.getUserIdSignatures((OpenPGPUserId)openPGPIdentityComponent) : openPGPPrimaryKey.getUserAttributeSignatures((OpenPGPUserAttribute)openPGPIdentityComponent);
            this.addSignaturesToChains(list2, openPGPSignatureChains2);
            this.componentSignatureChains.put(openPGPIdentityComponent, openPGPSignatureChains2);
        }
    }

    private void processSubkey(OpenPGPSubkey openPGPSubkey) {
        List<OpenPGPComponentSignature> list = openPGPSubkey.getKeySignatures();
        OpenPGPSignatureChains openPGPSignatureChains = new OpenPGPSignatureChains(openPGPSubkey);
        for (OpenPGPComponentSignature openPGPComponentSignature : list) {
            OpenPGPComponentKey openPGPComponentKey = openPGPSubkey.getCertificate().getSigningKeyFor(openPGPComponentSignature.getSignature());
            if (openPGPComponentKey == null) continue;
            OpenPGPSignatureChains openPGPSignatureChains2 = this.getAllSignatureChainsFor(openPGPComponentKey);
            if (!openPGPSignatureChains2.chains.isEmpty()) {
                Iterator iterator = openPGPSignatureChains2.chains.iterator();
                while (iterator.hasNext()) {
                    openPGPSignatureChains.add(((OpenPGPSignatureChain)iterator.next()).plus(openPGPComponentSignature));
                }
                continue;
            }
            openPGPSignatureChains.add(new OpenPGPSignatureChain(OpenPGPSignatureChain.Link.create(openPGPComponentSignature)));
        }
        this.componentSignatureChains.put(openPGPSubkey, openPGPSignatureChains);
    }

    private boolean isBound(OpenPGPCertificateComponent openPGPCertificateComponent, Date date) {
        return this.isBoundBy(openPGPCertificateComponent, this.getPrimaryKey(), date);
    }

    private boolean isBoundBy(OpenPGPCertificateComponent openPGPCertificateComponent, OpenPGPComponentKey openPGPComponentKey, Date date) {
        Object object;
        OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = openPGPCertificateComponent.getApplyingSubpacket(date, 9);
        if (openPGPSignatureSubpacket != null && ((KeyExpirationTime)(object = (KeyExpirationTime)openPGPSignatureSubpacket.getSubpacket())).getTime() != 0L) {
            OpenPGPComponentKey openPGPComponentKey2 = openPGPCertificateComponent.getKeyComponent();
            Date date2 = new Date(1000L * ((KeyExpirationTime)object).getTime() + openPGPComponentKey2.getCreationTime().getTime());
            if (date2.before(date)) {
                return false;
            }
        }
        try {
            object = this.getSignatureChainFor(openPGPCertificateComponent, openPGPComponentKey, date);
            if (object == null) {
                return false;
            }
            if (((OpenPGPSignatureChain)object).isValid(this.implementation.pgpContentVerifierBuilderProvider(), this.policy)) {
                return !((OpenPGPSignatureChain)object).isRevocation();
            }
            return false;
        }
        catch (PGPException pGPException) {
            return false;
        }
    }

    public List<OpenPGPComponentKey> getEncryptionKeys() {
        return this.getEncryptionKeys(new Date());
    }

    public List<OpenPGPComponentKey> getEncryptionKeys(Date date) {
        return this.filterKeys(date, new KeyFilter(){

            @Override
            public boolean test(OpenPGPComponentKey openPGPComponentKey, Date date) {
                return openPGPComponentKey.isEncryptionKey(date);
            }
        });
    }

    public List<OpenPGPComponentKey> getSigningKeys() {
        return this.getSigningKeys(new Date());
    }

    public List<OpenPGPComponentKey> getSigningKeys(Date date) {
        return this.filterKeys(date, new KeyFilter(){

            @Override
            public boolean test(OpenPGPComponentKey openPGPComponentKey, Date date) {
                return openPGPComponentKey.isSigningKey(date);
            }
        });
    }

    public List<OpenPGPComponentKey> getCertificationKeys() {
        return this.getCertificationKeys(new Date());
    }

    public List<OpenPGPComponentKey> getCertificationKeys(Date date) {
        return this.filterKeys(date, new KeyFilter(){

            @Override
            public boolean test(OpenPGPComponentKey openPGPComponentKey, Date date) {
                return openPGPComponentKey.isCertificationKey(date);
            }
        });
    }

    private OpenPGPSignatureChain getPreferenceSignature(Date date) {
        OpenPGPSignatureChain openPGPSignatureChain = this.getPrimaryKey().getSignatureChains().fromOrigin(this.getPrimaryKey()).getCertificationAt(date);
        if (openPGPSignatureChain != null) {
            return openPGPSignatureChain;
        }
        ArrayList<OpenPGPSignatureChain> arrayList = new ArrayList<OpenPGPSignatureChain>();
        Iterator<OpenPGPUserId> iterator = this.getPrimaryKey().getUserIDs().iterator();
        while (iterator.hasNext()) {
            OpenPGPSignatureChain openPGPSignatureChain2 = this.getAllSignatureChainsFor(iterator.next()).fromOrigin(this.getPrimaryKey()).getCertificationAt(date);
            if (openPGPSignatureChain2 == null) continue;
            arrayList.add(openPGPSignatureChain2);
        }
        arrayList.sort(new Comparator<OpenPGPSignatureChain>(){

            @Override
            public int compare(OpenPGPSignatureChain openPGPSignatureChain, OpenPGPSignatureChain openPGPSignatureChain2) {
                return openPGPSignatureChain2.getSince().compareTo(openPGPSignatureChain.getSince());
            }
        });
        for (OpenPGPSignatureChain openPGPSignatureChain2 : arrayList) {
            PGPSignature pGPSignature = openPGPSignatureChain2.getSignature().getSignature();
            if (!pGPSignature.getHashedSubPackets().isPrimaryUserID()) continue;
            return openPGPSignatureChain2;
        }
        return arrayList.isEmpty() ? null : (OpenPGPSignatureChain)arrayList.get(0);
    }

    public List<OpenPGPIdentityComponent> getIdentities() {
        return new ArrayList<OpenPGPIdentityComponent>(this.primaryKey.identityComponents);
    }

    public OpenPGPUserId getPrimaryUserId() {
        return this.getPrimaryUserId(new Date());
    }

    public OpenPGPUserId getPrimaryUserId(Date date) {
        return this.primaryKey.getExplicitOrImplicitPrimaryUserId(date);
    }

    public OpenPGPUserId getUserId(String string) {
        for (OpenPGPUserId openPGPUserId : this.primaryKey.getUserIDs()) {
            if (!openPGPUserId.getUserId().equals(string)) continue;
            return openPGPUserId;
        }
        return null;
    }

    public Date getExpirationTime() {
        return this.getExpirationTime(new Date());
    }

    public Date getExpirationTime(Date date) {
        return this.getPrimaryKey().getKeyExpirationDateAt(date);
    }

    public OpenPGPSignatureChain getDelegationBy(OpenPGPCertificate openPGPCertificate) {
        return this.getDelegationBy(openPGPCertificate, new Date());
    }

    public OpenPGPSignatureChain getDelegationBy(OpenPGPCertificate openPGPCertificate, Date date) {
        OpenPGPSignatureChains openPGPSignatureChains = this.getPrimaryKey().getMergedDanglingExternalSignatureChainEndsFrom(openPGPCertificate, date);
        return openPGPSignatureChains.getCertificationAt(date);
    }

    public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate openPGPCertificate) {
        return this.getRevocationBy(openPGPCertificate, new Date());
    }

    public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate openPGPCertificate, Date date) {
        OpenPGPSignatureChains openPGPSignatureChains = this.getPrimaryKey().getMergedDanglingExternalSignatureChainEndsFrom(openPGPCertificate, date);
        return openPGPSignatureChains.getRevocationAt(date);
    }

    private List<OpenPGPComponentKey> filterKeys(Date date, KeyFilter keyFilter) {
        ArrayList<OpenPGPComponentKey> arrayList = new ArrayList<OpenPGPComponentKey>();
        for (OpenPGPComponentKey openPGPComponentKey : this.getKeys()) {
            if (!this.isBound(openPGPComponentKey, date) || !keyFilter.test(openPGPComponentKey, date)) continue;
            arrayList.add(openPGPComponentKey);
        }
        return arrayList;
    }

    private void addSignaturesToChains(List<OpenPGPComponentSignature> list, OpenPGPSignatureChains openPGPSignatureChains) {
        Iterator<OpenPGPComponentSignature> iterator = list.iterator();
        while (iterator.hasNext()) {
            openPGPSignatureChains.add(OpenPGPSignatureChain.direct(iterator.next()));
        }
    }

    private static interface KeyFilter {
        public boolean test(OpenPGPComponentKey var1, Date var2);
    }

    public static abstract class OpenPGPCertificateComponent {
        private final OpenPGPCertificate certificate;

        public OpenPGPCertificateComponent(OpenPGPCertificate openPGPCertificate) {
            this.certificate = openPGPCertificate;
        }

        public OpenPGPCertificate getCertificate() {
            return this.certificate;
        }

        public abstract String toDetailString();

        public boolean isBound() {
            return this.isBoundAt(new Date());
        }

        public boolean isBoundAt(Date date) {
            return this.getCertificate().isBound(this, date);
        }

        public OpenPGPSignatureChains getSignatureChains() {
            OpenPGPPrimaryKey openPGPPrimaryKey;
            OpenPGPSignatureChains openPGPSignatureChains = this.getCertificate().getAllSignatureChainsFor(this);
            if (this.getPublicComponent() instanceof OpenPGPPrimaryKey && !(openPGPPrimaryKey = (OpenPGPPrimaryKey)this.getPublicComponent()).getUserIDs().isEmpty()) {
                openPGPSignatureChains.addAll(this.getCertificate().getAllSignatureChainsFor(openPGPPrimaryKey.getUserIDs().get(0)));
            }
            return openPGPSignatureChains;
        }

        public OpenPGPComponentSignature getCertification(Date date) {
            OpenPGPSignatureChain openPGPSignatureChain = this.getSignatureChains().getCertificationAt(date);
            if (openPGPSignatureChain != null) {
                return openPGPSignatureChain.getSignature();
            }
            return null;
        }

        public OpenPGPComponentSignature getRevocation(Date date) {
            OpenPGPSignatureChain openPGPSignatureChain = this.getSignatureChains().getRevocationAt(date);
            if (openPGPSignatureChain != null) {
                return openPGPSignatureChain.getSignature();
            }
            return null;
        }

        public OpenPGPComponentSignature getLatestSelfSignature() {
            return this.getLatestSelfSignature(new Date());
        }

        public abstract OpenPGPComponentSignature getLatestSelfSignature(Date var1);

        protected OpenPGPCertificateComponent getPublicComponent() {
            return this;
        }

        protected abstract OpenPGPComponentKey getKeyComponent();

        public KeyFlags getKeyFlags() {
            return this.getKeyFlags(new Date());
        }

        public KeyFlags getKeyFlags(Date date) {
            OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = this.getApplyingSubpacket(date, 27);
            if (openPGPSignatureSubpacket != null) {
                return (KeyFlags)openPGPSignatureSubpacket.getSubpacket();
            }
            return null;
        }

        public boolean hasKeyFlags(Date date, int ... nArray) {
            KeyFlags keyFlags = this.getKeyFlags(date);
            if (keyFlags == null) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if ((keyFlags.getFlags() & nArray[i]) != nArray[i]) continue;
                return true;
            }
            return false;
        }

        public Features getFeatures() {
            return this.getFeatures(new Date());
        }

        public Features getFeatures(Date date) {
            OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = this.getApplyingSubpacket(date, 30);
            if (openPGPSignatureSubpacket != null) {
                return (Features)openPGPSignatureSubpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAEADCiphersuites getAEADCipherSuitePreferences() {
            return this.getAEADCipherSuitePreferences(new Date());
        }

        public PreferredAEADCiphersuites getAEADCipherSuitePreferences(Date date) {
            OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = this.getApplyingSubpacket(date, 39);
            if (openPGPSignatureSubpacket != null) {
                return (PreferredAEADCiphersuites)openPGPSignatureSubpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAlgorithms getSymmetricCipherPreferences() {
            return this.getSymmetricCipherPreferences(new Date());
        }

        public PreferredAlgorithms getSymmetricCipherPreferences(Date date) {
            OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = this.getApplyingSubpacket(date, 11);
            if (openPGPSignatureSubpacket != null) {
                return (PreferredAlgorithms)openPGPSignatureSubpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAlgorithms getHashAlgorithmPreferences() {
            return this.getHashAlgorithmPreferences(new Date());
        }

        public PreferredAlgorithms getHashAlgorithmPreferences(Date date) {
            OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = this.getApplyingSubpacket(date, 21);
            if (openPGPSignatureSubpacket != null) {
                return (PreferredAlgorithms)openPGPSignatureSubpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAlgorithms getCompressionAlgorithmPreferences() {
            return this.getCompressionAlgorithmPreferences(new Date());
        }

        public PreferredAlgorithms getCompressionAlgorithmPreferences(Date date) {
            OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = this.getApplyingSubpacket(date, 22);
            if (openPGPSignatureSubpacket != null) {
                return (PreferredAlgorithms)openPGPSignatureSubpacket.getSubpacket();
            }
            return null;
        }

        public Date getKeyExpirationDate() {
            return this.getKeyExpirationDateAt(new Date());
        }

        public Date getKeyExpirationDateAt(Date date) {
            return this.getLatestSelfSignature(date).getKeyExpirationTime();
        }

        protected OpenPGPSignature.OpenPGPSignatureSubpacket getApplyingSubpacket(Date date, int n) {
            Object object;
            OpenPGPSignatureChain openPGPSignatureChain = this.getSignatureChains().getCertificationAt(date);
            if (openPGPSignatureChain == null) {
                return null;
            }
            try {
                if (!openPGPSignatureChain.isValid()) {
                    return null;
                }
            }
            catch (PGPSignatureException pGPSignatureException) {
                return null;
            }
            OpenPGPComponentSignature openPGPComponentSignature = openPGPSignatureChain.getSignature();
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector = openPGPComponentSignature.getSignature().getHashedSubPackets();
            if (pGPSignatureSubpacketVector == null || !pGPSignatureSubpacketVector.hasSubpacket(n)) {
                object = this.getCertificate().getPreferenceSignature(date);
                if (object == null) {
                    return null;
                }
                openPGPComponentSignature = ((OpenPGPSignatureChain)object).getSignature();
                pGPSignatureSubpacketVector = openPGPComponentSignature.getSignature().getHashedSubPackets();
            }
            if ((object = pGPSignatureSubpacketVector.getSubpacket(n)) == null) {
                return null;
            }
            return OpenPGPSignature.OpenPGPSignatureSubpacket.hashed((SignatureSubpacket)object, openPGPComponentSignature);
        }

        protected OpenPGPSignatureChains getMergedDanglingExternalSignatureChainEndsFrom(OpenPGPCertificate openPGPCertificate, Date date) {
            OpenPGPSignatureChains openPGPSignatureChains = new OpenPGPSignatureChains(this);
            OpenPGPSignatureChains openPGPSignatureChains2 = this.getCertificate().getAllSignatureChainsFor(this).getChainsAt(date);
            Iterator<OpenPGPSignatureChain> iterator = openPGPSignatureChains2.iterator();
            while (iterator.hasNext()) {
                OpenPGPSignatureChain.Link link = iterator.next().getRootLink();
                for (OpenPGPComponentKey openPGPComponentKey : openPGPCertificate.getKeys()) {
                    if (!KeyIdentifier.matches(link.getSignature().getKeyIdentifiers(), openPGPComponentKey.getKeyIdentifier(), true)) continue;
                    OpenPGPSignatureChain openPGPSignatureChain = openPGPComponentKey.getSignatureChains().getChainAt(date);
                    openPGPSignatureChain = openPGPSignatureChain.plus(new OpenPGPComponentSignature(link.signature.getSignature(), openPGPComponentKey, this));
                    openPGPSignatureChains.add(openPGPSignatureChain);
                }
            }
            return openPGPSignatureChains;
        }
    }

    public static abstract class OpenPGPComponentKey
    extends OpenPGPCertificateComponent {
        protected final PGPPublicKey rawPubkey;

        public OpenPGPComponentKey(PGPPublicKey pGPPublicKey, OpenPGPCertificate openPGPCertificate) {
            super(openPGPCertificate);
            this.rawPubkey = pGPPublicKey;
        }

        public PGPPublicKey getPGPPublicKey() {
            return this.rawPubkey;
        }

        public KeyIdentifier getKeyIdentifier() {
            return this.rawPubkey.getKeyIdentifier();
        }

        public int getAlgorithm() {
            return this.getPGPPublicKey().getAlgorithm();
        }

        public int getVersion() {
            return this.getPGPPublicKey().getVersion();
        }

        public Date getCreationTime() {
            return this.rawPubkey.getCreationTime();
        }

        public abstract boolean isPrimaryKey();

        @Override
        public OpenPGPComponentSignature getLatestSelfSignature(Date date) {
            OpenPGPSignatureChain openPGPSignatureChain = this.getSignatureChains().getChainAt(date);
            if (openPGPSignatureChain != null && !openPGPSignatureChain.chainLinks.isEmpty()) {
                return openPGPSignatureChain.getSignature();
            }
            return null;
        }

        public boolean isEncryptionKey() {
            return this.isEncryptionKey(new Date());
        }

        public boolean isEncryptionKey(Date date) {
            if (!this.rawPubkey.isEncryptionKey()) {
                return false;
            }
            return this.hasKeyFlags(date, 8) || this.hasKeyFlags(date, 4);
        }

        public boolean isSigningKey() {
            return this.isSigningKey(new Date());
        }

        public boolean isSigningKey(Date date) {
            if (!PublicKeyUtils.isSigningAlgorithm(this.rawPubkey.getAlgorithm())) {
                return false;
            }
            return this.hasKeyFlags(date, 2);
        }

        public boolean isCertificationKey() {
            return this.isCertificationKey(new Date());
        }

        public boolean isCertificationKey(Date date) {
            if (!PublicKeyUtils.isSigningAlgorithm(this.rawPubkey.getAlgorithm())) {
                return false;
            }
            return this.hasKeyFlags(date, 1);
        }

        @Override
        protected OpenPGPComponentKey getKeyComponent() {
            return this;
        }

        public int hashCode() {
            return this.getPGPPublicKey().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof OpenPGPComponentKey)) {
                return false;
            }
            OpenPGPComponentKey openPGPComponentKey = (OpenPGPComponentKey)object;
            return this.getPGPPublicKey().equals(openPGPComponentKey.getPGPPublicKey());
        }
    }

    public static class OpenPGPComponentSignature
    extends OpenPGPSignature {
        private final OpenPGPCertificateComponent target;

        public OpenPGPComponentSignature(PGPSignature pGPSignature, OpenPGPComponentKey openPGPComponentKey, OpenPGPCertificateComponent openPGPCertificateComponent) {
            super(pGPSignature, openPGPComponentKey);
            this.target = openPGPCertificateComponent;
        }

        public OpenPGPComponentKey getIssuerComponent() {
            return this.getIssuer();
        }

        public OpenPGPCertificateComponent getTargetComponent() {
            return this.target;
        }

        public OpenPGPComponentKey getTargetKeyComponent() {
            if (this.getTargetComponent() instanceof OpenPGPIdentityComponent) {
                return ((OpenPGPIdentityComponent)this.getTargetComponent()).getPrimaryKey();
            }
            if (this.getTargetComponent() instanceof OpenPGPComponentKey) {
                return (OpenPGPComponentKey)this.getTargetComponent();
            }
            throw new IllegalArgumentException("Unknown target type.");
        }

        public Date getKeyExpirationTime() {
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector = this.signature.getHashedSubPackets();
            if (pGPSignatureSubpacketVector == null) {
                return null;
            }
            long l = pGPSignatureSubpacketVector.getKeyExpirationTime();
            if (l < 0L) {
                throw new RuntimeException("Negative key expiration time");
            }
            if (l == 0L) {
                return null;
            }
            return new Date(this.getTargetKeyComponent().getCreationTime().getTime() + 1000L * l);
        }

        public void verify(OpenPGPImplementation openPGPImplementation) throws PGPSignatureException {
            this.verify(openPGPImplementation.pgpContentVerifierBuilderProvider(), openPGPImplementation.policy());
        }

        public void verify(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, OpenPGPPolicy openPGPPolicy) throws PGPSignatureException {
            if (this.issuer == null) {
                throw new MissingIssuerCertException(this, "Issuer certificate unavailable.");
            }
            this.sanitize(this.issuer, openPGPPolicy);
            if (this.signature.getSignatureType() == 31 || this.signature.getSignatureType() == 32) {
                this.verifyKeySignature(this.issuer, this.target.getKeyComponent(), pGPContentVerifierBuilderProvider);
            } else if (this.signature.getSignatureType() == 24) {
                this.verifyEmbeddedPrimaryKeyBinding(pGPContentVerifierBuilderProvider, openPGPPolicy, this.getCreationTime());
                if (((OpenPGPSubkey)this.target).getCreationTime().after(this.signature.getCreationTime())) {
                    this.isCorrect = false;
                    throw new MalformedOpenPGPSignatureException(this, "Subkey binding signature predates subkey creation time.");
                }
                this.verifyKeySignature(this.issuer, (OpenPGPSubkey)this.target, pGPContentVerifierBuilderProvider);
            } else if (this.signature.getSignatureType() == 40) {
                if (((OpenPGPSubkey)this.target).getCreationTime().after(this.signature.getCreationTime())) {
                    this.isCorrect = false;
                    throw new MalformedOpenPGPSignatureException(this, "Subkey revocation signature predates subkey creation time.");
                }
                this.verifyKeySignature(this.issuer, (OpenPGPSubkey)this.target, pGPContentVerifierBuilderProvider);
            } else if (this.target instanceof OpenPGPUserId) {
                this.verifyUserIdSignature(this.issuer, (OpenPGPUserId)this.target, pGPContentVerifierBuilderProvider);
            } else if (this.target instanceof OpenPGPUserAttribute) {
                this.verifyUserAttributeSignature(this.issuer, (OpenPGPUserAttribute)this.target, pGPContentVerifierBuilderProvider);
            } else {
                throw new PGPSignatureException("Unexpected signature type: " + this.getType());
            }
        }

        private void verifyEmbeddedPrimaryKeyBinding(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, OpenPGPPolicy openPGPPolicy, Date date) throws PGPSignatureException {
            Object object;
            int n = this.signature.getHashedSubPackets().getKeyFlags();
            if ((n & 2) != 2) {
                return;
            }
            OpenPGPComponentKey openPGPComponentKey = this.getTargetKeyComponent();
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            try {
                object = this.signature.getHashedSubPackets().getEmbeddedSignatures();
                OpenPGPComponentSignature.addSignatures(arrayList, (PGPSignatureList)object);
                object = this.signature.getUnhashedSubPackets().getEmbeddedSignatures();
                OpenPGPComponentSignature.addSignatures(arrayList, (PGPSignatureList)object);
            }
            catch (PGPException pGPException) {
                throw new PGPSignatureException("Cannot extract embedded signature.", pGPException);
            }
            if (arrayList.isEmpty()) {
                throw new MalformedOpenPGPSignatureException(this, "Signing key SubkeyBindingSignature MUST contain embedded PrimaryKeyBindingSignature.");
            }
            object = null;
            for (PGPSignature pGPSignature : arrayList) {
                OpenPGPComponentSignature openPGPComponentSignature = new OpenPGPComponentSignature(pGPSignature, openPGPComponentKey, this.issuer);
                if (pGPSignature.getSignatureType() != 25) {
                    object = new PGPSignatureException("Unexpected embedded signature type: " + pGPSignature.getSignatureType());
                    continue;
                }
                if (!openPGPComponentSignature.isEffectiveAt(date)) {
                    object = new PGPSignatureException("Embedded PrimaryKeyBinding signature is expired or not yet effective.");
                    continue;
                }
                try {
                    openPGPComponentSignature.sanitize(openPGPComponentKey, openPGPPolicy);
                    openPGPComponentSignature.verifyKeySignature(openPGPComponentKey, this.issuer, pGPContentVerifierBuilderProvider);
                    return;
                }
                catch (PGPSignatureException pGPSignatureException) {
                    object = pGPSignatureException;
                }
            }
            throw object;
        }

        private static void addSignatures(List<PGPSignature> list, PGPSignatureList pGPSignatureList) {
            Iterator<PGPSignature> iterator = pGPSignatureList.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }

        protected void verifyKeySignature(OpenPGPComponentKey openPGPComponentKey, OpenPGPComponentKey openPGPComponentKey2, PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider) throws PGPSignatureException {
            this.isTested = true;
            try {
                this.signature.init(pGPContentVerifierBuilderProvider, openPGPComponentKey.getPGPPublicKey());
                this.isCorrect = this.signature.getSignatureType() == 31 || this.signature.getSignatureType() == 32 ? this.signature.verifyCertification(openPGPComponentKey2.getPGPPublicKey()) : (this.signature.getSignatureType() == 25 ? this.signature.verifyCertification(openPGPComponentKey2.getPGPPublicKey(), openPGPComponentKey.getPGPPublicKey()) : this.signature.verifyCertification(openPGPComponentKey.getPGPPublicKey(), openPGPComponentKey2.getPGPPublicKey()));
                if (!this.isCorrect) {
                    throw new IncorrectOpenPGPSignatureException(this, "Key Signature is not correct.");
                }
            }
            catch (PGPException pGPException) {
                this.isCorrect = false;
                throw new PGPSignatureException("Key Signature could not be verified.", pGPException);
            }
            catch (ClassCastException classCastException) {
                this.isCorrect = false;
                throw new PGPSignatureException("Key Signature could not be verified.", classCastException);
            }
        }

        protected void verifyUserIdSignature(OpenPGPComponentKey openPGPComponentKey, OpenPGPUserId openPGPUserId, PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider) throws PGPSignatureException {
            this.isTested = true;
            try {
                this.signature.init(pGPContentVerifierBuilderProvider, openPGPComponentKey.getPGPPublicKey());
                this.isCorrect = this.signature.verifyCertification(openPGPUserId.getUserId(), openPGPUserId.getPrimaryKey().getPGPPublicKey());
                if (!this.isCorrect) {
                    throw new IncorrectOpenPGPSignatureException(this, "UserID Signature is not correct.");
                }
            }
            catch (PGPException pGPException) {
                this.isCorrect = false;
                throw new PGPSignatureException("UserID Signature could not be verified.", pGPException);
            }
            catch (ClassCastException classCastException) {
                this.isCorrect = false;
                throw new PGPSignatureException("UserID Signature could not be verified.", classCastException);
            }
        }

        protected void verifyUserAttributeSignature(OpenPGPComponentKey openPGPComponentKey, OpenPGPUserAttribute openPGPUserAttribute, PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider) throws PGPSignatureException {
            this.isTested = true;
            try {
                this.signature.init(pGPContentVerifierBuilderProvider, openPGPComponentKey.getPGPPublicKey());
                this.isCorrect = this.signature.verifyCertification(openPGPUserAttribute.getUserAttribute(), openPGPUserAttribute.getPrimaryKey().getPGPPublicKey());
                if (!this.isCorrect) {
                    throw new IncorrectOpenPGPSignatureException(this, "UserAttribute Signature is not correct.");
                }
            }
            catch (PGPException pGPException) {
                this.isCorrect = false;
                throw new PGPSignatureException("Could not verify UserAttribute Signature.", pGPException);
            }
            catch (ClassCastException classCastException) {
                this.isCorrect = false;
                throw new PGPSignatureException("Could not verify UserAttribute Signature.", classCastException);
            }
        }

        @Override
        protected String getTargetDisplay() {
            return this.target.toString();
        }
    }

    public static abstract class OpenPGPIdentityComponent
    extends OpenPGPCertificateComponent {
        private final OpenPGPPrimaryKey primaryKey;

        public OpenPGPIdentityComponent(OpenPGPPrimaryKey openPGPPrimaryKey) {
            super(openPGPPrimaryKey.getCertificate());
            this.primaryKey = openPGPPrimaryKey;
        }

        public OpenPGPPrimaryKey getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public OpenPGPComponentSignature getLatestSelfSignature(Date date) {
            OpenPGPSignatureChain openPGPSignatureChain = this.getSignatureChains().getChainAt(date);
            if (openPGPSignatureChain != null && !openPGPSignatureChain.chainLinks.isEmpty()) {
                return openPGPSignatureChain.getSignature();
            }
            return null;
        }

        @Override
        protected OpenPGPComponentKey getKeyComponent() {
            return this.primaryKey;
        }

        public OpenPGPSignatureChain getCertificationBy(OpenPGPCertificate openPGPCertificate) {
            return this.getCertificationBy(openPGPCertificate, new Date());
        }

        public OpenPGPSignatureChain getCertificationBy(OpenPGPCertificate openPGPCertificate, Date date) {
            OpenPGPSignatureChains openPGPSignatureChains = this.getMergedDanglingExternalSignatureChainEndsFrom(openPGPCertificate, date);
            return openPGPSignatureChains.getCertificationAt(date);
        }

        public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate openPGPCertificate) {
            return this.getRevocationBy(openPGPCertificate, new Date());
        }

        public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate openPGPCertificate, Date date) {
            OpenPGPSignatureChains openPGPSignatureChains = this.getMergedDanglingExternalSignatureChainEndsFrom(openPGPCertificate, date);
            return openPGPSignatureChains.getRevocationAt(date);
        }

        @Override
        public String toDetailString() {
            return this.toString();
        }
    }

    public static class OpenPGPPrimaryKey
    extends OpenPGPComponentKey {
        protected final List<OpenPGPIdentityComponent> identityComponents = new ArrayList<OpenPGPIdentityComponent>();

        public String toString() {
            return "PrimaryKey[" + Long.toHexString(this.getKeyIdentifier().getKeyId()).toUpperCase(Locale.getDefault()) + "]";
        }

        @Override
        public String toDetailString() {
            return "PrimaryKey[" + this.getKeyIdentifier() + "] (" + UTCUtil.format(this.getCreationTime()) + ")";
        }

        public OpenPGPPrimaryKey(PGPPublicKey pGPPublicKey, OpenPGPCertificate openPGPCertificate) {
            super(pGPPublicKey, openPGPCertificate);
            Iterator<String> iterator = pGPPublicKey.getUserIDs();
            while (iterator.hasNext()) {
                this.identityComponents.add(new OpenPGPUserId(iterator.next(), this));
            }
            Iterator<PGPUserAttributeSubpacketVector> iterator2 = pGPPublicKey.getUserAttributes();
            while (iterator2.hasNext()) {
                this.identityComponents.add(new OpenPGPUserAttribute(iterator2.next(), this));
            }
        }

        @Override
        public boolean isPrimaryKey() {
            return true;
        }

        public OpenPGPComponentSignature getLatestDirectKeySelfSignature() {
            return this.getLatestDirectKeySelfSignature(new Date());
        }

        public OpenPGPComponentSignature getLatestDirectKeySelfSignature(Date date) {
            OpenPGPSignatureChain openPGPSignatureChain = this.getCertificate().getAllSignatureChainsFor(this).getCertificationAt(date);
            if (openPGPSignatureChain != null && !openPGPSignatureChain.chainLinks.isEmpty()) {
                return openPGPSignatureChain.getSignature();
            }
            return null;
        }

        public OpenPGPComponentSignature getLatestKeyRevocationSelfSignature() {
            return this.getLatestKeyRevocationSelfSignature(new Date());
        }

        public OpenPGPComponentSignature getLatestKeyRevocationSelfSignature(Date date) {
            OpenPGPSignatureChain openPGPSignatureChain = this.getCertificate().getAllSignatureChainsFor(this).getRevocationAt(date);
            if (openPGPSignatureChain != null && !openPGPSignatureChain.chainLinks.isEmpty()) {
                return openPGPSignatureChain.getSignature();
            }
            return null;
        }

        @Override
        public OpenPGPComponentSignature getLatestSelfSignature(Date date) {
            OpenPGPComponentSignature openPGPComponentSignature;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            OpenPGPComponentSignature openPGPComponentSignature2 = this.getLatestDirectKeySelfSignature(date);
            if (openPGPComponentSignature2 != null) {
                arrayList.add(openPGPComponentSignature2);
            }
            if ((openPGPComponentSignature = this.getLatestKeyRevocationSelfSignature(date)) != null) {
                arrayList.add(openPGPComponentSignature);
            }
            Object object = this.getCertificate().getIdentities().iterator();
            while (object.hasNext()) {
                OpenPGPComponentSignature openPGPComponentSignature3 = object.next().getLatestSelfSignature(date);
                if (openPGPComponentSignature3 == null) continue;
                arrayList.add(openPGPComponentSignature3);
            }
            object = null;
            for (OpenPGPComponentSignature openPGPComponentSignature4 : arrayList) {
                if (object != null && !openPGPComponentSignature4.getCreationTime().after(((OpenPGPSignature)object).getCreationTime())) continue;
                object = openPGPComponentSignature4;
            }
            return object;
        }

        public List<OpenPGPUserId> getUserIDs() {
            ArrayList<OpenPGPUserId> arrayList = new ArrayList<OpenPGPUserId>();
            for (OpenPGPIdentityComponent openPGPIdentityComponent : this.identityComponents) {
                if (!(openPGPIdentityComponent instanceof OpenPGPUserId)) continue;
                arrayList.add((OpenPGPUserId)openPGPIdentityComponent);
            }
            return arrayList;
        }

        public List<OpenPGPUserId> getValidUserIds() {
            return this.getValidUserIDs(new Date());
        }

        public List<OpenPGPUserId> getValidUserIDs(Date date) {
            ArrayList<OpenPGPUserId> arrayList = new ArrayList<OpenPGPUserId>();
            for (OpenPGPIdentityComponent openPGPIdentityComponent : this.identityComponents) {
                if (!(openPGPIdentityComponent instanceof OpenPGPUserId) || !openPGPIdentityComponent.isBoundAt(date)) continue;
                arrayList.add((OpenPGPUserId)openPGPIdentityComponent);
            }
            return arrayList;
        }

        public OpenPGPUserId getExplicitPrimaryUserId(Date date) {
            OpenPGPSignature openPGPSignature = null;
            OpenPGPUserId openPGPUserId = null;
            for (OpenPGPUserId openPGPUserId2 : this.getUserIDs()) {
                PrimaryUserID primaryUserID;
                OpenPGPSignature.OpenPGPSignatureSubpacket openPGPSignatureSubpacket = openPGPUserId2.getApplyingSubpacket(date, 25);
                if (openPGPSignatureSubpacket == null || !(primaryUserID = (PrimaryUserID)openPGPSignatureSubpacket.getSubpacket()).isPrimaryUserID() || openPGPSignature != null && !openPGPSignatureSubpacket.getSignature().getCreationTime().after(openPGPSignature.getCreationTime())) continue;
                openPGPSignature = openPGPSignatureSubpacket.getSignature();
                openPGPUserId = openPGPUserId2;
            }
            return openPGPUserId;
        }

        public OpenPGPUserId getExplicitOrImplicitPrimaryUserId(Date date) {
            OpenPGPUserId openPGPUserId = this.getExplicitPrimaryUserId(date);
            if (openPGPUserId != null) {
                return openPGPUserId;
            }
            OpenPGPComponentSignature openPGPComponentSignature = null;
            OpenPGPUserId openPGPUserId2 = null;
            for (OpenPGPUserId openPGPUserId3 : this.getUserIDs()) {
                OpenPGPSignatureChain openPGPSignatureChain = openPGPUserId3.getSignatureChains().getCertificationAt(date);
                if (openPGPSignatureChain == null) continue;
                OpenPGPComponentSignature openPGPComponentSignature2 = openPGPSignatureChain.getSignature();
                if (openPGPComponentSignature != null && !openPGPComponentSignature2.getCreationTime().before(openPGPComponentSignature.getCreationTime())) continue;
                openPGPComponentSignature = openPGPComponentSignature2;
                openPGPUserId2 = openPGPUserId3;
            }
            return openPGPUserId2;
        }

        public List<OpenPGPUserAttribute> getUserAttributes() {
            ArrayList<OpenPGPUserAttribute> arrayList = new ArrayList<OpenPGPUserAttribute>();
            for (OpenPGPIdentityComponent openPGPIdentityComponent : this.identityComponents) {
                if (!(openPGPIdentityComponent instanceof OpenPGPUserAttribute)) continue;
                arrayList.add((OpenPGPUserAttribute)openPGPIdentityComponent);
            }
            return arrayList;
        }

        protected List<OpenPGPComponentSignature> getKeySignatures() {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignatures();
            ArrayList<OpenPGPComponentSignature> arrayList = new ArrayList<OpenPGPComponentSignature>();
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = iterator.next();
                int n = pGPSignature.getSignatureType();
                if (n != 31 && n != 32) continue;
                OpenPGPComponentKey openPGPComponentKey = this.getCertificate().getSigningKeyFor(pGPSignature);
                arrayList.add(new OpenPGPComponentSignature(pGPSignature, openPGPComponentKey, this));
            }
            return arrayList;
        }

        protected List<OpenPGPComponentSignature> getUserIdSignatures(OpenPGPUserId openPGPUserId) {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignaturesForID(openPGPUserId.getUserId());
            return this.signIterToList(openPGPUserId, iterator);
        }

        protected List<OpenPGPComponentSignature> getUserAttributeSignatures(OpenPGPUserAttribute openPGPUserAttribute) {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignaturesForUserAttribute(openPGPUserAttribute.getUserAttribute());
            return this.signIterToList(openPGPUserAttribute, iterator);
        }

        private List<OpenPGPComponentSignature> signIterToList(OpenPGPIdentityComponent openPGPIdentityComponent, Iterator<PGPSignature> iterator) {
            ArrayList<OpenPGPComponentSignature> arrayList = new ArrayList<OpenPGPComponentSignature>();
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = iterator.next();
                OpenPGPComponentKey openPGPComponentKey = this.getCertificate().getSigningKeyFor(pGPSignature);
                arrayList.add(new OpenPGPComponentSignature(pGPSignature, openPGPComponentKey, openPGPIdentityComponent));
            }
            return arrayList;
        }
    }

    public static class OpenPGPSignatureChain
    implements Comparable<OpenPGPSignatureChain>,
    Iterable<Link> {
        private final List<Link> chainLinks = new ArrayList<Link>();

        private OpenPGPSignatureChain(Link link) {
            this.chainLinks.add(link);
        }

        private OpenPGPSignatureChain(List<Link> list) {
            this.chainLinks.addAll(list);
        }

        private OpenPGPSignatureChain(OpenPGPSignatureChain openPGPSignatureChain) {
            this(openPGPSignatureChain.chainLinks);
        }

        public OpenPGPComponentSignature getSignature() {
            return this.getLeafLink().getSignature();
        }

        public OpenPGPComponentSignature getRevocation() {
            for (OpenPGPComponentSignature openPGPComponentSignature : this.getSignatures()) {
                if (!openPGPComponentSignature.isRevocation()) continue;
                return openPGPComponentSignature;
            }
            return null;
        }

        public List<OpenPGPComponentSignature> getSignatures() {
            ArrayList<OpenPGPComponentSignature> arrayList = new ArrayList<OpenPGPComponentSignature>();
            for (Link link : this.chainLinks) {
                arrayList.add(link.getSignature());
            }
            return arrayList;
        }

        public OpenPGPSignatureChain plus(OpenPGPComponentSignature openPGPComponentSignature) {
            if (this.getLeafLinkTargetKey() != openPGPComponentSignature.getIssuerComponent()) {
                throw new IllegalArgumentException("Chain head is not equal to link issuer.");
            }
            OpenPGPSignatureChain openPGPSignatureChain = new OpenPGPSignatureChain(this);
            openPGPSignatureChain.chainLinks.add(Link.create(openPGPComponentSignature));
            return openPGPSignatureChain;
        }

        public static OpenPGPSignatureChain direct(OpenPGPComponentSignature openPGPComponentSignature) {
            return new OpenPGPSignatureChain(Link.create(openPGPComponentSignature));
        }

        public Link getRootLink() {
            return this.chainLinks.get(0);
        }

        public OpenPGPComponentKey getRootLinkIssuer() {
            return this.getRootLink().getSignature().getIssuer();
        }

        public Link getLeafLink() {
            return this.chainLinks.get(this.chainLinks.size() - 1);
        }

        public OpenPGPComponentKey getLeafLinkTargetKey() {
            return this.getSignature().getTargetKeyComponent();
        }

        public boolean isCertification() {
            Iterator<Link> iterator = this.chainLinks.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof Revocation)) continue;
                return false;
            }
            return true;
        }

        public boolean isRevocation() {
            Iterator<Link> iterator = this.chainLinks.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof Revocation)) continue;
                return true;
            }
            return false;
        }

        public boolean isHardRevocation() {
            Iterator<Link> iterator = this.chainLinks.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().signature.signature.isHardRevocation()) continue;
                return true;
            }
            return false;
        }

        public Date getSince() {
            Date date = null;
            for (Link link : this.chainLinks) {
                OpenPGPComponentSignature openPGPComponentSignature = link.getSignature();
                Date date2 = openPGPComponentSignature.getCreationTime();
                if (date != null && !date2.after(date)) continue;
                date = date2;
            }
            return date;
        }

        public Date getUntil() {
            Date date = null;
            for (Link link : this.chainLinks) {
                Date date2 = link.until();
                if (date2 == null) continue;
                date = date == null ? date2 : (date2.before(date) ? date2 : date);
            }
            return date;
        }

        public boolean isEffectiveAt(Date date) {
            if (this.isHardRevocation()) {
                return true;
            }
            Date date2 = this.getSince();
            Date date3 = this.getUntil();
            return !date.before(date2) && (date3 == null || !date.after(date3));
        }

        public boolean isValid() throws PGPSignatureException {
            OpenPGPComponentKey openPGPComponentKey = this.getRootLinkIssuer();
            if (openPGPComponentKey == null) {
                throw new MissingIssuerCertException(this.getRootLink().signature, "Missing issuer certificate.");
            }
            OpenPGPCertificate openPGPCertificate = openPGPComponentKey.getCertificate();
            return this.isValid(openPGPCertificate.implementation.pgpContentVerifierBuilderProvider(), openPGPCertificate.policy);
        }

        public boolean isValid(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, OpenPGPPolicy openPGPPolicy) throws PGPSignatureException {
            boolean bl = true;
            for (Link link : this.chainLinks) {
                if (!link.signature.isTested) {
                    link.verify(pGPContentVerifierBuilderProvider, openPGPPolicy);
                }
                if (link.signature.isCorrect) continue;
                bl = false;
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getUntil() == null ? "EndOfTime" : UTCUtil.format(this.getUntil());
            stringBuilder.append("From ").append(UTCUtil.format(this.getSince())).append(" until ").append(string).append("\n");
            for (Link link : this.chainLinks) {
                stringBuilder.append("  ").append(link.toString()).append("\n");
            }
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(OpenPGPSignatureChain openPGPSignatureChain) {
            if (this == openPGPSignatureChain) {
                return 0;
            }
            if (this.isHardRevocation()) {
                return -1;
            }
            if (openPGPSignatureChain.isHardRevocation()) {
                return 1;
            }
            int n = -this.getRootLink().since().compareTo(openPGPSignatureChain.getRootLink().since());
            if (n != 0) {
                return n;
            }
            n = -this.getLeafLink().since().compareTo(openPGPSignatureChain.getLeafLink().since());
            if (n != 0) {
                return n;
            }
            if (this.isRevocation()) {
                return 1;
            }
            return -1;
        }

        @Override
        public Iterator<Link> iterator() {
            return this.chainLinks.iterator();
        }

        public static class Certification
        extends Link {
            public Certification(OpenPGPComponentSignature openPGPComponentSignature) {
                super(openPGPComponentSignature);
            }
        }

        public static abstract class Link {
            protected final OpenPGPComponentSignature signature;

            public Link(OpenPGPComponentSignature openPGPComponentSignature) {
                this.signature = openPGPComponentSignature;
            }

            public Date since() {
                return this.signature.getCreationTime();
            }

            public Date until() {
                Date date = this.getBackSigExpirationTime();
                Date date2 = this.signature.getExpirationTime();
                if (date2 == null) {
                    return date;
                }
                if (date == null || date2.before(date)) {
                    return date2;
                }
                return date;
            }

            private Date getBackSigExpirationTime() {
                if (this.signature.getSignature().getSignatureType() != 24) {
                    return null;
                }
                PGPSignatureSubpacketVector pGPSignatureSubpacketVector = this.signature.getSignature().getHashedSubPackets();
                if (pGPSignatureSubpacketVector == null) {
                    return null;
                }
                int n = this.signature.getSignature().getHashedSubPackets().getKeyFlags();
                if ((n & 2) != 2) {
                    return null;
                }
                try {
                    PGPSignatureList pGPSignatureList = pGPSignatureSubpacketVector.getEmbeddedSignatures();
                    if (!pGPSignatureList.isEmpty()) {
                        OpenPGPComponentSignature openPGPComponentSignature = new OpenPGPComponentSignature(pGPSignatureList.get(0), this.getSignature().getTargetKeyComponent(), this.getSignature().getIssuer());
                        return openPGPComponentSignature.getExpirationTime();
                    }
                    return null;
                }
                catch (PGPException pGPException) {
                    return null;
                }
            }

            public boolean verify(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, OpenPGPPolicy openPGPPolicy) throws PGPSignatureException {
                this.signature.verify(pGPContentVerifierBuilderProvider, openPGPPolicy);
                return true;
            }

            public String toString() {
                return this.signature.toString();
            }

            public static Link create(OpenPGPComponentSignature openPGPComponentSignature) {
                if (openPGPComponentSignature.isRevocation()) {
                    return new Revocation(openPGPComponentSignature);
                }
                return new Certification(openPGPComponentSignature);
            }

            public OpenPGPComponentSignature getSignature() {
                return this.signature;
            }
        }

        public static class Revocation
        extends Link {
            public Revocation(OpenPGPComponentSignature openPGPComponentSignature) {
                super(openPGPComponentSignature);
            }

            @Override
            public Date since() {
                if (this.signature.signature.isHardRevocation()) {
                    return new Date(0L);
                }
                return super.since();
            }

            @Override
            public Date until() {
                if (this.signature.signature.isHardRevocation()) {
                    return new Date(Long.MAX_VALUE);
                }
                return super.until();
            }
        }
    }

    public static class OpenPGPSignatureChains
    implements Iterable<OpenPGPSignatureChain> {
        private final OpenPGPCertificateComponent targetComponent;
        private final Set<OpenPGPSignatureChain> chains = new TreeSet<OpenPGPSignatureChain>();

        public OpenPGPSignatureChains(OpenPGPCertificateComponent openPGPCertificateComponent) {
            this.targetComponent = openPGPCertificateComponent;
        }

        public void add(OpenPGPSignatureChain openPGPSignatureChain) {
            this.chains.add(openPGPSignatureChain);
        }

        public void addAll(OpenPGPSignatureChains openPGPSignatureChains) {
            this.chains.addAll(openPGPSignatureChains.chains);
        }

        public boolean isEmpty() {
            return this.chains.isEmpty();
        }

        public OpenPGPSignatureChain getCertificationAt(Date date) {
            for (OpenPGPSignatureChain openPGPSignatureChain : this.chains) {
                boolean bl = openPGPSignatureChain.isEffectiveAt(date);
                boolean bl2 = openPGPSignatureChain.isCertification();
                if (!bl || !bl2) continue;
                return openPGPSignatureChain;
            }
            return null;
        }

        public OpenPGPSignatureChains getChainsAt(Date date) {
            OpenPGPSignatureChains openPGPSignatureChains = new OpenPGPSignatureChains(this.targetComponent);
            for (OpenPGPSignatureChain openPGPSignatureChain : this.chains) {
                if (!openPGPSignatureChain.isEffectiveAt(date)) continue;
                openPGPSignatureChains.add(openPGPSignatureChain);
            }
            return openPGPSignatureChains;
        }

        public OpenPGPSignatureChain getRevocationAt(Date date) {
            for (OpenPGPSignatureChain openPGPSignatureChain : this.chains) {
                if (!openPGPSignatureChain.isRevocation() || !openPGPSignatureChain.isEffectiveAt(date)) continue;
                return openPGPSignatureChain;
            }
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.targetComponent.toDetailString()).append(" is bound with ").append(this.chains.size()).append(" chains:").append("\n");
            for (OpenPGPSignatureChain openPGPSignatureChain : this.chains) {
                stringBuilder.append(openPGPSignatureChain.toString());
            }
            return stringBuilder.toString();
        }

        public OpenPGPSignatureChains fromOrigin(OpenPGPComponentKey openPGPComponentKey) {
            OpenPGPSignatureChains openPGPSignatureChains = new OpenPGPSignatureChains(openPGPComponentKey);
            for (OpenPGPSignatureChain openPGPSignatureChain : this.chains) {
                if (openPGPSignatureChain.getRootLinkIssuer() != openPGPComponentKey) continue;
                openPGPSignatureChains.add(openPGPSignatureChain);
            }
            return openPGPSignatureChains;
        }

        public OpenPGPSignatureChain getChainAt(Date date) {
            OpenPGPSignatureChains openPGPSignatureChains = this.getChainsAt(date);
            Iterator<OpenPGPSignatureChain> iterator = openPGPSignatureChains.chains.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }

        @Override
        public Iterator<OpenPGPSignatureChain> iterator() {
            return this.chains.iterator();
        }
    }

    public static class OpenPGPSubkey
    extends OpenPGPComponentKey {
        public OpenPGPSubkey(PGPPublicKey pGPPublicKey, OpenPGPCertificate openPGPCertificate) {
            super(pGPPublicKey, openPGPCertificate);
        }

        @Override
        public boolean isPrimaryKey() {
            return false;
        }

        public String toString() {
            return "Subkey[" + Long.toHexString(this.getKeyIdentifier().getKeyId()).toUpperCase(Locale.getDefault()) + "]";
        }

        @Override
        public String toDetailString() {
            return "Subkey[" + this.getKeyIdentifier() + "] (" + UTCUtil.format(this.getCreationTime()) + ")";
        }

        protected List<OpenPGPComponentSignature> getKeySignatures() {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignatures();
            ArrayList<OpenPGPComponentSignature> arrayList = new ArrayList<OpenPGPComponentSignature>();
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = iterator.next();
                int n = pGPSignature.getSignatureType();
                if (n != 24 && n != 40) continue;
                OpenPGPComponentKey openPGPComponentKey = this.getCertificate().getSigningKeyFor(pGPSignature);
                arrayList.add(new OpenPGPComponentSignature(pGPSignature, openPGPComponentKey, this));
            }
            return arrayList;
        }
    }

    public static class OpenPGPUserAttribute
    extends OpenPGPIdentityComponent {
        private final PGPUserAttributeSubpacketVector userAttribute;

        public OpenPGPUserAttribute(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, OpenPGPPrimaryKey openPGPPrimaryKey) {
            super(openPGPPrimaryKey);
            this.userAttribute = pGPUserAttributeSubpacketVector;
        }

        public PGPUserAttributeSubpacketVector getUserAttribute() {
            return this.userAttribute;
        }

        public String toString() {
            return "UserAttribute" + this.userAttribute.toString();
        }
    }

    public static class OpenPGPUserId
    extends OpenPGPIdentityComponent {
        private final String userId;

        public OpenPGPUserId(String string, OpenPGPPrimaryKey openPGPPrimaryKey) {
            super(openPGPPrimaryKey);
            this.userId = string;
        }

        public String getUserId() {
            return this.userId;
        }

        public String toString() {
            return "UserID[" + this.userId + "]";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof OpenPGPUserId)) {
                return false;
            }
            return this.getUserId().equals(((OpenPGPUserId)object).getUserId());
        }

        public int hashCode() {
            return this.userId.hashCode();
        }
    }
}

