/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.behavior;

import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.behavior.ClientBehaviorBase;
import jakarta.faces.component.behavior.ClientBehaviorHint;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorListener;
import jakarta.faces.event.BehaviorListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.tobago.internal.behavior.DeltaStateHelper;

@FacesBehavior(value="org.apache.myfaces.tobago.behavior.Event")
public class EventBehavior
extends ClientBehaviorBase {
    public static final String BEHAVIOR_ID = "org.apache.myfaces.tobago.behavior.Event";
    private static final String ATTR_EXECUTE = "execute";
    private static final String ATTR_ON_ERROR = "onerror";
    private static final String ATTR_ON_EVENT = "onevent";
    private static final String ATTR_RENDER = "render";
    private static final String ATTR_DISABLED = "disabled";
    private static final String ATTR_IMMEDIATE = "immediate";
    private static final String ATTR_FOR = "for";
    private static final String VAL_FORM = "@form";
    private static final String VAL_ALL = "@all";
    private static final String VAL_THIS = "@this";
    private static final String VAL_NONE = "@none";
    private static final Collection<String> VAL_FORM_LIST = Collections.singletonList("@form");
    private static final Collection<String> VAL_ALL_LIST = Collections.singletonList("@all");
    private static final Collection<String> VAL_THIS_LIST = Collections.singletonList("@this");
    private static final Collection<String> VAL_NONE_LIST = Collections.singletonList("@none");
    private DeltaStateHelper<EventBehavior> stateHelper = null;

    public void addAjaxBehaviorListener(AjaxBehaviorListener listener) {
        super.addBehaviorListener((BehaviorListener)listener);
    }

    public void removeAjaxBehaviorListener(AjaxBehaviorListener listener) {
        this.removeBehaviorListener((BehaviorListener)listener);
    }

    public Collection<String> getExecute() {
        return this.evalForCollection(ATTR_EXECUTE);
    }

    public void setExecute(Collection<String> execute) {
        this.getStateHelper().put((Serializable)((Object)ATTR_EXECUTE), execute);
    }

    public String getOnerror() {
        return (String)this.getStateHelper().eval((Serializable)((Object)ATTR_ON_ERROR));
    }

    public void setOnerror(String onError) {
        this.getStateHelper().put((Serializable)((Object)ATTR_ON_ERROR), (Object)onError);
    }

    public String getOnevent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)ATTR_ON_EVENT));
    }

    public void setOnevent(String onEvent) {
        this.getStateHelper().put((Serializable)((Object)ATTR_ON_EVENT), (Object)onEvent);
    }

    public Collection<String> getRender() {
        return this.evalForCollection(ATTR_RENDER);
    }

    public void setRender(Collection<String> render) {
        this.getStateHelper().put((Serializable)((Object)ATTR_RENDER), render);
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        Map bindings = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.bindings));
        if (bindings != null) {
            return (ValueExpression)bindings.get(name);
        }
        return null;
    }

    public void setValueExpression(String name, ValueExpression expression) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (expression == null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.bindings), (Object)name);
        } else {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.bindings), name, (Object)expression);
        }
    }

    public boolean isDisabled() {
        Boolean retVal = (Boolean)this.getStateHelper().eval((Serializable)((Object)ATTR_DISABLED));
        retVal = retVal == null ? false : retVal;
        return retVal;
    }

    public void setDisabled(boolean disabled) {
        this.getStateHelper().put((Serializable)((Object)ATTR_DISABLED), (Object)disabled);
    }

    public boolean isImmediate() {
        Boolean retVal = (Boolean)this.getStateHelper().eval((Serializable)((Object)ATTR_IMMEDIATE));
        retVal = retVal == null ? false : retVal;
        return retVal;
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)ATTR_IMMEDIATE), (Object)immediate);
    }

    public boolean isImmediateSet() {
        return this.getStateHelper().get((Serializable)((Object)ATTR_IMMEDIATE)) != null || this.getValueExpression(ATTR_IMMEDIATE) != null;
    }

    public String getFor() {
        return (String)this.getStateHelper().eval((Serializable)((Object)ATTR_FOR));
    }

    public void setFor(String id) {
        this.getStateHelper().put((Serializable)((Object)ATTR_FOR), (Object)id);
    }

    public Set<ClientBehaviorHint> getHints() {
        return EnumSet.of(ClientBehaviorHint.SUBMITTING);
    }

    public String getRendererType() {
        return BEHAVIOR_ID;
    }

    public void restoreState(FacesContext facesContext, Object o) {
        if (o == null) {
            return;
        }
        Object[] values = (Object[])o;
        if (values[0] != null) {
            super.restoreState(facesContext, values[0]);
        }
        this.getStateHelper().restoreState(facesContext, values[1]);
    }

    private StateHelper getStateHelper() {
        return this.getStateHelper(true);
    }

    private StateHelper getStateHelper(boolean create) {
        if (this.stateHelper != null) {
            return this.stateHelper;
        }
        if (create) {
            this.stateHelper = new DeltaStateHelper<EventBehavior>(this);
        }
        return this.stateHelper;
    }

    public Object saveState(FacesContext facesContext) {
        if (this.initialStateMarked()) {
            Object parentSaved = super.saveState(facesContext);
            Object stateHelperSaved = null;
            StateHelper myStateHelper = this.getStateHelper(false);
            if (myStateHelper != null) {
                stateHelperSaved = myStateHelper.saveState(facesContext);
            }
            if (parentSaved == null && stateHelperSaved == null) {
                return null;
            }
            return new Object[]{parentSaved, stateHelperSaved};
        }
        Object[] values = new Object[2];
        values[0] = super.saveState(facesContext);
        StateHelper myStateHelper = this.getStateHelper(false);
        if (myStateHelper != null) {
            values[1] = myStateHelper.saveState(facesContext);
        }
        return values;
    }

    private Collection<String> evalForCollection(String attributeName) {
        Object value = this.getStateHelper().eval((Serializable)((Object)attributeName));
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof String) {
            return this.getCollectionFromSpaceSplitString((String)value);
        }
        throw new IllegalArgumentException("Type " + String.valueOf(value.getClass()) + " not supported for attribute " + attributeName);
    }

    private Collection<String> getCollectionFromSpaceSplitString(String stringValue) {
        if (stringValue.equals(VAL_FORM)) {
            return VAL_FORM_LIST;
        }
        if (stringValue.equals(VAL_ALL)) {
            return VAL_ALL_LIST;
        }
        if (stringValue.equals(VAL_NONE)) {
            return VAL_NONE_LIST;
        }
        if (stringValue.equals(VAL_THIS)) {
            return VAL_THIS_LIST;
        }
        String[] arrValue = stringValue.split(" ");
        return Arrays.asList(arrValue);
    }

    private static enum PropertyKeys {
        bindings;

    }
}

