/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.repository.aot.generate.AotRepositoryBeanDefinitionPropertiesDecorator;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.javapoet.CodeBlock;

public class RepositoryRegistrationAotContribution
implements BeanRegistrationAotContribution {
    private final AotRepositoryContext context;
    private final BeanRegistrationAotContribution aotContribution;
    private final @Nullable RepositoryContributor repositoryContribution;

    RepositoryRegistrationAotContribution(AotRepositoryContext context, BeanRegistrationAotContribution aotContribution, @Nullable RepositoryContributor repositoryContribution) {
        this.context = context;
        this.aotContribution = aotContribution;
        this.repositoryContribution = repositoryContribution;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.context.getRepositoryInformation();
    }

    public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        this.aotContribution.applyTo(generationContext, beanRegistrationCode);
        if (this.repositoryContribution != null) {
            this.repositoryContribution.contribute(generationContext);
        }
    }

    public BeanRegistrationCodeFragments customizeBeanRegistrationCodeFragments(GenerationContext generationContext, BeanRegistrationCodeFragments codeFragments) {
        return new BeanRegistrationCodeFragmentsDecorator(codeFragments){

            public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
                Supplier<CodeBlock> inheritedProperties = () -> super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, beanDefinition, attributeFilter);
                if (RepositoryRegistrationAotContribution.this.repositoryContribution == null) {
                    return inheritedProperties.get();
                }
                AotRepositoryBeanDefinitionPropertiesDecorator decorator = new AotRepositoryBeanDefinitionPropertiesDecorator(inheritedProperties, RepositoryRegistrationAotContribution.this.repositoryContribution);
                return decorator.decorate();
            }
        };
    }
}

