/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.models;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import opennlp.tools.models.ClassPathModelEntry;
import opennlp.tools.models.ClassPathModelFinder;

public abstract class AbstractClassPathModelFinder
implements ClassPathModelFinder {
    protected static final String JAR = "jar";
    private final String jarModelPrefix;
    private Set<ClassPathModelEntry> models;

    public AbstractClassPathModelFinder() {
        this("opennlp-models-*.jar");
    }

    public AbstractClassPathModelFinder(String jarModelPrefix) {
        Objects.requireNonNull(jarModelPrefix, "jarModelPrefix must not be null");
        this.jarModelPrefix = jarModelPrefix;
    }

    @Override
    public Set<ClassPathModelEntry> findModels(boolean reloadCache) {
        if (this.models == null || reloadCache) {
            List<URI> classpathModels = this.getMatchingURIs("*.bin", this.getContext());
            List<URI> classPathProperties = this.getMatchingURIs("model.properties", this.getContext());
            this.models = new HashSet<ClassPathModelEntry>();
            for (URI model : classpathModels) {
                URI m = null;
                for (URI prop : classPathProperties) {
                    if (!this.jarPathsMatch(model, prop)) continue;
                    m = prop;
                    break;
                }
                this.models.add(new ClassPathModelEntry(model, Optional.ofNullable(m)));
            }
        }
        return this.models;
    }

    protected abstract Object getContext();

    protected abstract List<URI> getMatchingURIs(String var1, Object var2);

    protected boolean jarPathsMatch(URI uri1, URI uri2) {
        String[] parts1 = this.parseJarURI(uri1);
        String[] parts2 = this.parseJarURI(uri2);
        if (parts1 == null || parts2 == null) {
            return false;
        }
        return parts1[0].equals(parts2[0]);
    }

    protected String[] parseJarURI(URI uri) {
        String ssp;
        int separatorIndex;
        if (JAR.equals(uri.getScheme()) && (separatorIndex = (ssp = uri.getSchemeSpecificPart()).indexOf("!/")) > 0) {
            String jarFileUri = ssp.substring(0, separatorIndex);
            String entryPath = ssp.substring(separatorIndex + 2);
            return new String[]{jarFileUri, entryPath};
        }
        return null;
    }

    protected String getJarModelPrefix() {
        return this.jarModelPrefix;
    }
}

