/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

public enum AlgorithmType {
    MAXENT("MAXENT", "GIS", "opennlp.tools.ml.maxent.GISTrainer", "opennlp.tools.ml.maxent.io.GISModelReader", "opennlp.tools.ml.maxent.io.BinaryGISModelWriter"),
    MAXENT_QN("MAXENT_QN", "QN", "opennlp.tools.ml.maxent.quasinewton.QNTrainer", "opennlp.tools.ml.maxent.io.QNModelReader", "opennlp.tools.ml.maxent.io.BinaryQNModelWriter"),
    PERCEPTRON("PERCEPTRON", "Perceptron", "opennlp.tools.ml.perceptron.PerceptronTrainer", "opennlp.tools.ml.perceptron.PerceptronModelReader", "opennlp.tools.ml.perceptron.BinaryPerceptronModelWriter"),
    PERCEPTRON_SEQUENCE("PERCEPTRON_SEQUENCE", "Perceptron", "opennlp.tools.ml.perceptron.SimplePerceptronSequenceTrainer", "opennlp.tools.ml.perceptron.PerceptronModelReader", "opennlp.tools.ml.perceptron.BinaryPerceptronModelWriter"),
    NAIVE_BAYES("NAIVEBAYES", "NaiveBayes", "opennlp.tools.ml.naivebayes.NaiveBayesTrainer", "opennlp.tools.ml.naivebayes.NaiveBayesModelReader", "opennlp.tools.ml.naivebayes.BinaryNaiveBayesModelWriter");

    private final String algorithmType;
    private final String trainerClazz;
    private final String modelType;
    private final String readerClazz;
    private final String writerClazz;

    private AlgorithmType(String type, String ioType, String trainerClazz, String readerClazz, String writerClazz) {
        this.algorithmType = type;
        this.trainerClazz = trainerClazz;
        this.modelType = ioType;
        this.readerClazz = readerClazz;
        this.writerClazz = writerClazz;
    }

    public String getAlgorithmType() {
        return this.algorithmType;
    }

    public String getTrainerClazz() {
        return this.trainerClazz;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getReaderClazz() {
        return this.readerClazz;
    }

    public String getWriterClazz() {
        return this.writerClazz;
    }

    public static AlgorithmType fromAlgorithmType(String type) {
        for (AlgorithmType trainerType : AlgorithmType.values()) {
            if (!trainerType.algorithmType.equals(type)) continue;
            return trainerType;
        }
        throw new IllegalArgumentException("Unknown algorithm type: " + type);
    }

    public static AlgorithmType fromModelType(String type) {
        for (AlgorithmType trainerType : AlgorithmType.values()) {
            if (!trainerType.modelType.equals(type)) continue;
            return trainerType;
        }
        throw new IllegalArgumentException("Unknown reader type: " + type);
    }
}

