/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.ozone.freon.FreonReplicationOptions;
import org.apache.hadoop.ozone.freon.FreonSubcommand;
import org.apache.hadoop.ozone.protocol.StorageContainerDatanodeProtocol;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="scm-throughput-benchmark", aliases={"stb"}, description={"Benchmark for scm throughput."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public final class SCMThroughputBenchmark
implements Callable<Void>,
FreonSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(SCMThroughputBenchmark.class);
    @CommandLine.ParentCommand
    private Freon freon;
    @CommandLine.Option(names={"--benchmark"}, description={"Which type of benchmark to run (AllocateBlocks, AllocateContainers, ProcessReports)."}, required=true, defaultValue="")
    private String benchmarkType = "";
    @CommandLine.Option(names={"--num-blocks"}, description={"Number of blocks."}, defaultValue="1000")
    private int numBlocks = 1000;
    @CommandLine.Option(names={"--block-size"}, description={"Block size."}, defaultValue="4096")
    private long blockSize = 4096L;
    @CommandLine.Option(names={"--num-containers"}, description={"Number of containers."}, defaultValue="100")
    private int numContainers = 100;
    @CommandLine.Option(names={"--num-datanodes"}, description={"Number of fake datanodes."}, defaultValue="10")
    private int numDatanodes = 10;
    @CommandLine.Option(names={"--num-threads"}, description={"Number of scm client threads."}, defaultValue="4")
    private int numThreads = 4;
    @CommandLine.Option(names={"--num-heartbeats"}, description={"Number of heartbeats that carries reports."}, defaultValue="4")
    private int numHeartbeats = 4;
    @CommandLine.Option(names={"--scmHost", "--scm-host"}, required=true, description={"The leader scm host x.x.x.x."})
    private String scm;
    @CommandLine.Mixin
    private FreonReplicationOptions replication;
    static final int CHECK_INTERVAL_MILLIS = 5000;
    private static final Random RANDOM = new Random();
    private OzoneConfiguration conf;
    private List<FakeDatanode> datanodes;
    private StorageContainerDatanodeProtocol datanodeScmClient;
    private StorageContainerLocationProtocol scmContainerClient;
    private ScmBlockLocationProtocol scmBlockClient;

    @Override
    public Void call() throws Exception {
        this.conf = this.freon.getOzoneConf();
        ThroughputBenchmark benchmark = this.createBenchmark();
        this.initCluster(benchmark);
        benchmark.run();
        return null;
    }

    private ThroughputBenchmark createBenchmark() {
        ThroughputBenchmark benchmark = null;
        BenchmarkType type = BenchmarkType.valueOf(this.benchmarkType);
        switch (type.ordinal()) {
            case 0: {
                benchmark = new BlockBenchmark(this.numThreads, this.numBlocks, this.blockSize);
                break;
            }
            case 1: {
                benchmark = new ContainerBenchmark(this.numThreads, this.numContainers);
                break;
            }
            case 2: {
                benchmark = new ReportBenchmark(this.numDatanodes, this.numContainers, this.numHeartbeats);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.benchmarkType + " is not a valid benchmarkType.");
            }
        }
        LOG.info("Run benchmark: {}", (Object)type);
        return benchmark;
    }

    private void initCluster(ThroughputBenchmark benchmark) throws IOException, InterruptedException, IllegalArgumentException {
        this.initSCMClients();
        this.registerFakeDatanodes();
        if (benchmark.requiresPipelines()) {
            this.activatePipelines();
        }
        this.exitSafeMode();
    }

    private void initSCMClients() throws IOException {
        this.datanodeScmClient = this.createDatanodeScmClient();
        this.scmContainerClient = this.createScmContainerClient();
        this.scmBlockClient = this.createScmBlockClient();
        LOG.info("Initialized scm clients {datanodeClient, containerClient, blockClient}");
    }

    private void registerFakeDatanodes() throws IOException {
        this.datanodes = new ArrayList<FakeDatanode>();
        for (int i = 0; i < this.numDatanodes; ++i) {
            FakeDatanode dn = new FakeDatanode();
            dn.register();
            this.datanodes.add(dn);
        }
        LOG.info("Registered datanode(fake): {}", (Object)this.numDatanodes);
    }

    private void activatePipelines() throws IOException, InterruptedException {
        LOG.info("Waiting for pipelines to be allocated automatically");
        Thread.sleep(Duration.ofSeconds(60L).toMillis());
        List pipelines = this.scmContainerClient.listPipelines();
        for (Pipeline pipeline : pipelines) {
            this.scmContainerClient.activatePipeline(pipeline.getId().getProtobuf());
        }
        LOG.info("Force opened pipelines: {}", (Object)pipelines.size());
    }

    private void exitSafeMode() throws IOException {
        try {
            if (!this.scmContainerClient.forceExitSafeMode()) {
                throw new IOException("Safe mode exit failed");
            }
        }
        catch (IOException e) {
            LOG.warn("Safe mode exit with exception, but we can go on");
        }
        try {
            if (this.scmContainerClient.inSafeMode()) {
                throw new IOException("Safe mode exit failed indeed");
            }
        }
        catch (IOException e) {
            LOG.error("{}", (Throwable)e);
            throw e;
        }
        LOG.info("Force exited safe mode");
    }

    private StorageContainerDatanodeProtocol createDatanodeScmClient() throws IOException {
        int dnPort = this.conf.getInt("ozone.scm.datanode.port", 9861);
        InetSocketAddress scmAddress = NetUtils.createSocketAddr((String)this.scm, (int)dnPort);
        Configuration hadoopConfig = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConfig, StorageContainerDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        long version = RPC.getProtocolVersion(StorageContainerDatanodeProtocolPB.class);
        SCMClientConfig scmClientConfig = (SCMClientConfig)this.conf.getObject(SCMClientConfig.class);
        int rpcTimeout = (int)scmClientConfig.getRpcTimeOut();
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)HddsServerUtil.getScmRpcRetryCount((ConfigurationSource)this.conf), (long)HddsServerUtil.getScmRpcRetryInterval((ConfigurationSource)this.conf), (TimeUnit)TimeUnit.MILLISECONDS);
        StorageContainerDatanodeProtocolPB rpcProxy = (StorageContainerDatanodeProtocolPB)RPC.getProtocolProxy(StorageContainerDatanodeProtocolPB.class, (long)version, (InetSocketAddress)scmAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)hadoopConfig, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConfig), (int)rpcTimeout, (RetryPolicy)retryPolicy).getProxy();
        return new StorageContainerDatanodeProtocolClientSideTranslatorPB(rpcProxy);
    }

    private StorageContainerLocationProtocol createScmContainerClient() {
        return HAUtils.getScmContainerClient((ConfigurationSource)this.conf);
    }

    private ScmBlockLocationProtocol createScmBlockClient() {
        return HAUtils.getScmBlockClient((OzoneConfiguration)this.conf);
    }

    private static DatanodeDetails createRandomDatanodeDetails() {
        UUID uuid = UUID.randomUUID();
        String ipAddress = RANDOM.nextInt(256) + "." + RANDOM.nextInt(256) + "." + RANDOM.nextInt(256) + "." + RANDOM.nextInt(256);
        DatanodeDetails.Port containerPort = DatanodeDetails.newStandalonePort((Integer)0);
        DatanodeDetails.Port ratisPort = DatanodeDetails.newRatisPort((Integer)0);
        DatanodeDetails.Port restPort = DatanodeDetails.newRestPort((Integer)0);
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(uuid).setHostName("localhost").setIpAddress(ipAddress).addPort(containerPort).addPort(ratisPort).addPort(restPort);
        return builder.build();
    }

    private static StorageContainerDatanodeProtocolProtos.NodeReportProto createNodeReport(UUID nodeId) {
        ArrayList<StorageContainerDatanodeProtocolProtos.StorageReportProto> storageReports = new ArrayList<StorageContainerDatanodeProtocolProtos.StorageReportProto>();
        ArrayList<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> metadataStorageReports = new ArrayList<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto>();
        storageReports.add(SCMThroughputBenchmark.createStorageReport(nodeId));
        metadataStorageReports.add(SCMThroughputBenchmark.createMetadataStorageReport());
        StorageContainerDatanodeProtocolProtos.NodeReportProto.Builder nb = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder();
        nb.addAllStorageReport(storageReports).addAllMetadataStorageReport(metadataStorageReports);
        return nb.build();
    }

    private static StorageContainerDatanodeProtocolProtos.StorageReportProto createStorageReport(UUID nodeId) {
        StorageContainerDatanodeProtocolProtos.StorageReportProto.Builder srb = StorageContainerDatanodeProtocolProtos.StorageReportProto.newBuilder();
        srb.setStorageUuid(nodeId.toString()).setStorageLocation("/data").setCapacity(0x640000000000L).setScmUsed(0L).setFailed(false).setRemaining(0x640000000000L).setStorageType(HddsProtos.StorageTypeProto.DISK);
        return srb.build();
    }

    private static StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto createMetadataStorageReport() {
        StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.Builder mrb = StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.newBuilder();
        mrb.setStorageLocation("/meta").setCapacity(0x1900000000L).setScmUsed(0L).setFailed(false).setRemaining(0x1900000000L).setStorageType(HddsProtos.StorageTypeProto.DISK);
        return mrb.build();
    }

    private static StorageContainerDatanodeProtocolProtos.ContainerReportsProto createContainerReport() {
        return StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder().build();
    }

    private static StorageContainerDatanodeProtocolProtos.PipelineReportsProto createPipelineReport() {
        return StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder().build();
    }

    static /* synthetic */ DatanodeDetails access$1600() {
        return SCMThroughputBenchmark.createRandomDatanodeDetails();
    }

    private abstract class ThroughputBenchmark {
        private static final String DURATION_FORMAT = "HH:mm:ss,SSS";
        private long startTime;
        private long execTime;
        private String formattedTime;
        private int numThreads;
        private Queue<Runnable> taskQueue;
        private ExecutorService executor;

        ThroughputBenchmark(int threads) {
            this.numThreads = threads;
            this.taskQueue = new LinkedList<Runnable>();
            this.executor = Executors.newFixedThreadPool(this.numThreads);
        }

        public void run() throws InterruptedException {
            this.prepare();
            this.execTasks();
            this.showSummary();
        }

        public void prepare() {
            LOG.info("Preparing tasks to run");
        }

        public void execTasks() throws InterruptedException {
            this.setStartTime(System.nanoTime());
            LOG.info("Benchmark tasks started");
            for (int i = 0; i < this.numThreads; ++i) {
                this.executor.execute(this.taskQueue.poll());
            }
            this.waitForComplete();
            this.executor.shutdown();
            this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        public void showSummary() {
            this.execTime = System.nanoTime() - this.startTime;
            this.formattedTime = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(this.execTime), (String)DURATION_FORMAT);
        }

        public abstract void waitForComplete() throws InterruptedException;

        protected long getStartTime() {
            return this.startTime;
        }

        protected void setStartTime(long time) {
            this.startTime = time;
        }

        protected long getExecTime() {
            return this.execTime;
        }

        protected String getFormattedTime() {
            return this.formattedTime;
        }

        protected int getNumThreads() {
            return this.numThreads;
        }

        protected void enqueueTask(Runnable task) {
            this.taskQueue.add(task);
        }

        public boolean requiresPipelines() {
            return false;
        }
    }

    public static enum BenchmarkType {
        AllocateBlocks,
        AllocateContainers,
        ProcessReports;

    }

    private class BlockBenchmark
    extends ThroughputBenchmark {
        private final ReplicationConfig replicationConfig;
        private final ExcludeList excludeList;
        private AtomicLong totalBlockCounter;
        private AtomicLong succBlockCounter;
        private AtomicLong failBlockCounter;
        private int totalBlocks;
        private long blockSize;

        BlockBenchmark(int threads, int blocks, long blockSize) {
            super(threads);
            this.excludeList = new ExcludeList();
            this.totalBlocks = blocks;
            this.blockSize = blockSize;
            this.totalBlockCounter = new AtomicLong();
            this.succBlockCounter = new AtomicLong();
            this.failBlockCounter = new AtomicLong();
            ReplicationConfig rc = SCMThroughputBenchmark.this.replication.fromParamsOrConfig((ConfigurationSource)SCMThroughputBenchmark.this.conf);
            if (rc == null) {
                rc = RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE);
            }
            this.replicationConfig = rc;
        }

        @Override
        public boolean requiresPipelines() {
            return this.replicationConfig.getReplicationType() == HddsProtos.ReplicationType.RATIS;
        }

        @Override
        public void prepare() {
            super.prepare();
            for (int i = 0; i < this.getNumThreads(); ++i) {
                this.enqueueTask(new BlockTask(this.blockSize, this.replicationConfig));
            }
        }

        @Override
        public void showSummary() {
            super.showSummary();
            long execSecs = TimeUnit.SECONDS.convert(this.getExecTime(), TimeUnit.NANOSECONDS);
            long blocks = this.succBlockCounter.get();
            float blocksPerSec = execSecs != 0L ? (float)blocks / (float)execSecs : (float)blocks;
            System.out.println("***************************************");
            System.out.printf("Total allocated blocks: %d%n", this.succBlockCounter.get());
            System.out.printf("Total failed blocks: %d%n", this.failBlockCounter.get());
            System.out.printf("Execution Time: %s%n", this.getFormattedTime());
            System.out.printf("Throughput: %f (ops)%n", Float.valueOf(blocksPerSec));
            System.out.println("***************************************");
        }

        @Override
        public void waitForComplete() throws InterruptedException {
            while (this.totalBlockCounter.get() < (long)this.totalBlocks) {
                Thread.sleep(5000L);
                LOG.info("Blocks allocated: {}/{}", (Object)this.totalBlockCounter.get(), (Object)this.totalBlocks);
            }
        }

        private void doAllocateBlock(long size, ReplicationConfig config) {
            try {
                SCMThroughputBenchmark.this.scmBlockClient.allocateBlock(size, 1, config, "STB", this.excludeList);
                this.succBlockCounter.incrementAndGet();
            }
            catch (IOException e) {
                LOG.error("Failed to allocate block", (Throwable)e);
                this.failBlockCounter.incrementAndGet();
            }
        }

        private class BlockTask
        implements Runnable {
            private final long blockSize;
            private final ReplicationConfig replicationConfig;

            BlockTask(long blockSize, ReplicationConfig replicationConfig) {
                this.blockSize = blockSize;
                this.replicationConfig = replicationConfig;
            }

            @Override
            public void run() {
                while (BlockBenchmark.this.totalBlockCounter.getAndIncrement() < (long)BlockBenchmark.this.totalBlocks) {
                    BlockBenchmark.this.doAllocateBlock(this.blockSize, this.replicationConfig);
                }
            }
        }
    }

    private class ContainerBenchmark
    extends ThroughputBenchmark {
        private AtomicInteger totalContainerCounter;
        private AtomicInteger succContainerCounter;
        private AtomicInteger failContainerCounter;
        private int totalContainers;

        ContainerBenchmark(int threads, int containers) {
            super(threads);
            this.totalContainers = containers;
            this.totalContainerCounter = new AtomicInteger();
            this.succContainerCounter = new AtomicInteger();
            this.failContainerCounter = new AtomicInteger();
        }

        @Override
        public void prepare() {
            super.prepare();
            for (int i = 0; i < this.getNumThreads(); ++i) {
                this.enqueueTask(new ContainerTask());
            }
        }

        @Override
        public void showSummary() {
            super.showSummary();
            long execSecs = TimeUnit.SECONDS.convert(this.getExecTime(), TimeUnit.NANOSECONDS);
            long containers = this.succContainerCounter.get();
            float containersPerSec = execSecs != 0L ? (float)containers / (float)execSecs : (float)containers;
            System.out.println("***************************************");
            System.out.printf("Total allocated containers: %d%n", this.succContainerCounter.get());
            System.out.printf("Total failed containers: %d%n", this.failContainerCounter.get());
            System.out.printf("Execution Time: %s%n", this.getFormattedTime());
            System.out.printf("Throughput: %f (ops)%n", Float.valueOf(containersPerSec));
            System.out.println("***************************************");
        }

        @Override
        public void waitForComplete() throws InterruptedException {
            while (this.totalContainerCounter.get() < this.totalContainers) {
                Thread.sleep(5000L);
                LOG.info("Containers allocated: {}/{}", (Object)this.totalContainerCounter.get(), (Object)this.totalContainers);
            }
        }

        private void doAllocateContainer(HddsProtos.ReplicationFactor factor) {
            try {
                SCMThroughputBenchmark.this.scmContainerClient.allocateContainer(HddsProtos.ReplicationType.RATIS, factor, "STB");
                this.succContainerCounter.incrementAndGet();
            }
            catch (IOException e) {
                LOG.error("{}", (Throwable)e);
                this.failContainerCounter.incrementAndGet();
            }
        }

        private class ContainerTask
        implements Runnable {
            ContainerTask() {
            }

            @Override
            public void run() {
                while (ContainerBenchmark.this.totalContainerCounter.getAndIncrement() < ContainerBenchmark.this.totalContainers) {
                    ContainerBenchmark.this.doAllocateContainer(HddsProtos.ReplicationFactor.THREE);
                }
            }
        }
    }

    private class ReportBenchmark
    extends ThroughputBenchmark {
        private static final String REPORT_PREFIX = "scm_container_manager_metrics_num_container_reports_processed_";
        private static final String REPORT_SUCC_KEY = "scm_container_manager_metrics_num_container_reports_processed_successful";
        private static final String REPORT_FAIL_KEY = "scm_container_manager_metrics_num_container_reports_processed_failed";
        private AtomicInteger succReportSendCounter;
        private AtomicInteger failReportSendCounter;
        private int reportSuccProcessedOnRegister;
        private int reportFailProcessedOnRegister;
        private int succReportsProcessed;
        private int failReportsProcessed;
        private int numReports;
        private int numReportRounds;
        private int totalContainers;
        private int containersPerReport;
        private List<ContainerInfo> containers;

        ReportBenchmark(int threads, int containers, int rounds) {
            super(threads);
            this.succReportSendCounter = new AtomicInteger();
            this.failReportSendCounter = new AtomicInteger();
            this.numReportRounds = rounds;
            this.numReports = SCMThroughputBenchmark.this.numDatanodes * rounds;
            this.totalContainers = containers;
            this.containers = new ArrayList<ContainerInfo>();
            this.reportSuccProcessedOnRegister = 0;
            this.reportFailProcessedOnRegister = 0;
        }

        @Override
        public void prepare() {
            int i;
            LOG.info("Preparing containers for reports");
            for (int i2 = 0; i2 < this.totalContainers; ++i2) {
                try {
                    ContainerWithPipeline container = SCMThroughputBenchmark.this.scmContainerClient.allocateContainer(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE, "STB");
                    this.containers.add(container.getContainerInfo());
                    continue;
                }
                catch (IOException e) {
                    LOG.error("{}", (Throwable)e);
                }
            }
            LOG.info("Allocated containers: {}", (Object)this.containers.size());
            this.totalContainers = this.containers.size();
            this.containersPerReport = this.totalContainers / SCMThroughputBenchmark.this.numDatanodes;
            int from = 0;
            for (i = 0; i < this.getNumThreads(); ++i) {
                ((FakeDatanode)SCMThroughputBenchmark.this.datanodes.get(i)).buildContainerReports(this.containers.subList(from, Math.min(from + this.containersPerReport, this.totalContainers)));
                from += this.containersPerReport;
            }
            this.getScmReportProcessed();
            this.reportSuccProcessedOnRegister = this.succReportsProcessed;
            this.reportFailProcessedOnRegister = this.failReportsProcessed;
            this.succReportsProcessed = 0;
            this.failReportsProcessed = 0;
            super.prepare();
            for (i = 0; i < this.getNumThreads(); ++i) {
                this.enqueueTask(new ReportTask((FakeDatanode)SCMThroughputBenchmark.this.datanodes.get(i), this.numReportRounds));
            }
        }

        @Override
        public void showSummary() {
            super.showSummary();
            long execSecs = TimeUnit.SECONDS.convert(this.getExecTime(), TimeUnit.NANOSECONDS);
            float reportsPerSec = execSecs > 0L ? (float)this.succReportsProcessed / (float)execSecs : (float)this.succReportsProcessed;
            System.out.println("***************************************");
            System.out.printf("Total container reports processed: %d%n", this.succReportsProcessed);
            System.out.printf("Total container reports failed: %d%n", this.failReportsProcessed);
            System.out.printf("Containers per report: %d%n", this.containersPerReport);
            System.out.printf("Execution Time: %s%n", this.getFormattedTime());
            System.out.printf("Throughput: %f (ops)%n", Float.valueOf(reportsPerSec));
            System.out.println("***************************************");
        }

        @Override
        public void waitForComplete() throws InterruptedException {
            while (this.succReportsProcessed + this.failReportsProcessed < this.numReports) {
                Thread.sleep(5000L);
                LOG.info("Processing reports: ({}+{})/{}", new Object[]{this.succReportsProcessed, this.failReportsProcessed, this.numReports});
                this.getScmReportProcessed();
            }
        }

        private void getScmReportProcessed() {
            List<String> metricsLines = this.getScmReportProcessedMetricsLines();
            for (String line : metricsLines) {
                if (line.startsWith("#")) continue;
                if (line.startsWith(REPORT_SUCC_KEY)) {
                    this.succReportsProcessed = Integer.parseInt(this.getMetricsValue(line)) - this.reportSuccProcessedOnRegister;
                }
                if (!line.startsWith(REPORT_FAIL_KEY)) continue;
                this.failReportsProcessed = Integer.parseInt(this.getMetricsValue(line)) - this.reportFailProcessedOnRegister;
            }
        }

        private List<String> getScmReportProcessedMetricsLines() {
            List<String> list;
            CloseableHttpClient client = HttpClientBuilder.create().build();
            String uri = String.format("http://%s:%d/prom", SCMThroughputBenchmark.this.scm, 9876);
            HttpGet get = new HttpGet(uri);
            HttpResponse execute = client.execute((HttpUriRequest)get);
            if (execute.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Can't read prometheus metrics endpoint" + execute.getStatusLine().getStatusCode());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(execute.getEntity().getContent(), StandardCharsets.UTF_8));
            try {
                list = bufferedReader.lines().collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            bufferedReader.close();
            return list;
        }

        String getMetricsValue(String line) {
            String[] parts = line.split(" ");
            return parts[1];
        }

        private class ReportTask
        implements Runnable {
            private FakeDatanode datanode;
            private int rounds;

            ReportTask(FakeDatanode datanode, int rounds) {
                this.datanode = datanode;
                this.rounds = rounds;
            }

            @Override
            public void run() {
                for (int i = 0; i < this.rounds; ++i) {
                    try {
                        this.datanode.sendHeartbeat();
                        ReportBenchmark.this.succReportSendCounter.incrementAndGet();
                        continue;
                    }
                    catch (IOException | TimeoutException e) {
                        LOG.error("{}", (Throwable)e);
                        ReportBenchmark.this.failReportSendCounter.incrementAndGet();
                    }
                }
            }
        }
    }

    private class FakeDatanode {
        private DatanodeDetails datanodeDetails = SCMThroughputBenchmark.access$1600();
        private StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = null;

        FakeDatanode() {
        }

        public void register() throws IOException {
            StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto response = SCMThroughputBenchmark.this.datanodeScmClient.register(this.datanodeDetails.getExtendedProtoBufMessage(), SCMThroughputBenchmark.createNodeReport(this.datanodeDetails.getUuid()), SCMThroughputBenchmark.createContainerReport(), SCMThroughputBenchmark.createPipelineReport(), UpgradeUtils.defaultLayoutVersionProto());
            if (response.hasHostname() && response.hasIpAddress()) {
                this.datanodeDetails.setHostName(response.getHostname());
                this.datanodeDetails.setIpAddress(response.getIpAddress());
            }
            if (response.hasNetworkName() && response.hasNetworkLocation()) {
                this.datanodeDetails.setNetworkName(response.getNetworkName());
                this.datanodeDetails.setNetworkLocation(response.getNetworkLocation());
            }
        }

        public void sendHeartbeat() throws IOException, TimeoutException {
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeatRequest = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(this.datanodeDetails.getProtoBufMessage()).setContainerReport(this.containerReport).setDataNodeLayoutVersion(UpgradeUtils.defaultLayoutVersionProto()).build();
            SCMThroughputBenchmark.this.datanodeScmClient.sendHeartbeat(heartbeatRequest);
        }

        public void buildContainerReports(List<ContainerInfo> containers) {
            StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder reportBuilder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
            for (ContainerInfo cinfo : containers) {
                StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.Builder replicaBuilder = StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder();
                replicaBuilder.setContainerID(cinfo.getContainerID()).setReadCount(0L).setWriteCount(1L).setReadBytes(0L).setWriteBytes(4096L).setKeyCount(1L).setUsed(4096L).setState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).setDeleteTransactionId(cinfo.getDeleteTransactionId()).setBlockCommitSequenceId(cinfo.getSequenceId()).setOriginNodeId(this.datanodeDetails.getUuidString());
                reportBuilder.addReports(replicaBuilder.build());
            }
            this.containerReport = reportBuilder.build();
        }

        public DatanodeDetails getDatanodeDetails() {
            return this.datanodeDetails;
        }
    }
}

