/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.container.stream.DirectoryServerDestination;
import org.apache.hadoop.ozone.container.stream.DirectoryServerSource;
import org.apache.hadoop.ozone.container.stream.StreamingClient;
import org.apache.hadoop.ozone.container.stream.StreamingDestination;
import org.apache.hadoop.ozone.container.stream.StreamingServer;
import org.apache.hadoop.ozone.container.stream.StreamingSource;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="strmg", aliases={"streaming-generator"}, description={"Create directory structure and stream them multiple times."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class StreamingGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingGenerator.class);
    @CommandLine.Option(names={"--root-dir"}, description={"Directory where the working directories are created"}, defaultValue="/tmp/ozone-streaming")
    private Path testRoot;
    @CommandLine.Option(names={"--files"}, description={"Number of the files in the test directory to be generated."}, defaultValue="50")
    private int numberOfFiles;
    @CommandLine.Option(names={"--size"}, description={"Size of the generated files. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="100MB", converter={StorageSizeConverter.class})
    private StorageSize fileSize;
    private static final String SUB_DIR_NAME = "dir1";
    private ThreadLocal<Integer> counter = new ThreadLocal();
    private Timer timer;

    @Override
    public Void call() throws Exception {
        this.init();
        this.timer = this.getMetrics().timer("streaming");
        this.runTests(this::copyDir);
        return null;
    }

    private void generateBaseData() {
        try {
            Path sourceDirParent = this.threadRootDir();
            Path sourceDir = sourceDirParent.resolve("streaming-0");
            if (Files.exists(sourceDirParent, new LinkOption[0])) {
                this.deleteDirRecursive(sourceDirParent);
            }
            Path subDir = sourceDir.resolve(SUB_DIR_NAME);
            Files.createDirectories(subDir, new FileAttribute[0]);
            ContentGenerator contentGenerator = new ContentGenerator(this.fileSize.toBytes(), 1024);
            for (int i = 0; i < this.numberOfFiles; ++i) {
                try (OutputStream out = Files.newOutputStream(subDir.resolve("file-" + i), new OpenOption[0]);){
                    contentGenerator.write(out);
                    continue;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void copyDir(long l) {
        Integer index = this.counter.get();
        if (index == null) {
            this.generateBaseData();
            index = 0;
        }
        Path sourceDir = this.threadRootDir().resolve("streaming-" + index);
        Path destinationDir = this.threadRootDir().resolve("streaming-" + (index + 1));
        this.counter.set(index + 1);
        int port = (int)(1234L + l % 64000L);
        try (StreamingServer server = new StreamingServer((StreamingSource)new DirectoryServerSource(sourceDir), port);){
            server.start();
            LOG.info("Starting streaming server on port {} to publish dir {}", (Object)port, (Object)sourceDir);
            try (StreamingClient client = new StreamingClient("localhost", port, (StreamingDestination)new DirectoryServerDestination(destinationDir));){
                this.timer.time(() -> client.stream(SUB_DIR_NAME));
            }
            LOG.info("Replication has been finished to {}", (Object)sourceDir);
            this.deleteDirRecursive(sourceDir);
        }
    }

    private Path threadRootDir() {
        return this.testRoot.resolve(Thread.currentThread().getName());
    }

    private void deleteDirRecursive(Path destinationDir) {
        try {
            FileUtils.forceDelete((File)destinationDir.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

