/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;

public final class UuidCodec
implements Codec<UUID> {
    private static final int SERIALIZED_SIZE = 16;
    private static final UuidCodec CODEC = new UuidCodec();

    public static UuidCodec get() {
        return CODEC;
    }

    public static int getSerializedSize() {
        return 16;
    }

    private UuidCodec() {
    }

    @Override
    public Class<UUID> getTypeClass() {
        return UUID.class;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull UUID id, CodecBuffer.Allocator allocator) {
        return ((CodecBuffer)allocator.apply(16)).putLong(id.getMostSignificantBits()).putLong(id.getLeastSignificantBits());
    }

    @Override
    public UUID fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        return UuidCodec.getUuid(buffer.asReadOnlyByteBuffer());
    }

    private static UUID getUuid(ByteBuffer buffer) {
        return new UUID(buffer.getLong(), buffer.getLong());
    }

    @Override
    public byte[] toPersistedFormat(UUID id) {
        byte[] array = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putLong(id.getMostSignificantBits());
        buffer.putLong(id.getLeastSignificantBits());
        return array;
    }

    @Override
    public UUID fromPersistedFormat(byte[] array) {
        if (array.length != 16) {
            throw new IllegalArgumentException("Unexpected array length: " + array.length + " != " + 16);
        }
        return UuidCodec.getUuid(ByteBuffer.wrap(array));
    }

    @Override
    public UUID copyObject(UUID object) {
        return object;
    }
}

