/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.report.ContainerReportValidator;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReportHandler.class);
    private final UnknownContainerAction unknownContainerHandleAction;

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext, OzoneConfiguration conf) {
        super(nodeManager, containerManager, scmContext);
        if (conf != null) {
            ScmConfig scmConfig = (ScmConfig)conf.getObject(ScmConfig.class);
            this.unknownContainerHandleAction = UnknownContainerAction.parse(scmConfig.getUnknownContainerAction());
        } else {
            this.unknownContainerHandleAction = UnknownContainerAction.WARN;
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager) {
        this(nodeManager, containerManager, SCMContext.emptyContext(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        DatanodeDetails dnFromReport = reportFromDatanode.getDatanodeDetails();
        DatanodeDetails datanodeDetails = this.getNodeManager().getNode(dnFromReport.getID());
        if (datanodeDetails == null) {
            this.getLogger().warn("Datanode not found: {}", (Object)dnFromReport);
            return;
        }
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport();
        try {
            DatanodeDetails datanodeDetails2 = datanodeDetails;
            synchronized (datanodeDetails2) {
                List replicas = containerReport.getReportsList();
                Set<ContainerID> expectedContainersInDatanode = this.getNodeManager().getContainers(datanodeDetails);
                for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica : replicas) {
                    ContainerID cid = ContainerID.valueOf((long)replica.getContainerID());
                    ContainerInfo container = null;
                    try {
                        container = this.getContainerManager().getContainer(cid);
                        cid = container.containerID();
                    }
                    catch (ContainerNotFoundException containerNotFoundException) {
                        // empty catch block
                    }
                    boolean alreadyInDn = expectedContainersInDatanode.remove(cid);
                    if (!alreadyInDn) {
                        this.getNodeManager().addContainer(datanodeDetails, cid);
                    }
                    if (container != null && !ContainerReportValidator.validate(container, datanodeDetails, replica)) continue;
                    this.processSingleReplica(datanodeDetails, container, replica, publisher);
                }
                this.processMissingReplicas(datanodeDetails, expectedContainersInDatanode);
                this.getContainerManager().notifyContainerReportProcessing(true, true);
                if (reportFromDatanode.isRegister()) {
                    publisher.fireEvent(SCMEvents.CONTAINER_REGISTRATION_REPORT, (Object)new SCMDatanodeProtocolServer.NodeRegistrationContainerReport(datanodeDetails, (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport()));
                }
            }
        }
        catch (NodeNotFoundException ex) {
            this.getContainerManager().notifyContainerReportProcessing(true, false);
            this.getLogger().warn("Datanode not found: {}", (Object)datanodeDetails, (Object)ex);
        }
    }

    private void processSingleReplica(DatanodeDetails datanodeDetails, ContainerInfo container, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto, EventPublisher publisher) {
        Object detailsForLogging = ContainerReportHandler.getDetailsForLogging(container, replicaProto, datanodeDetails);
        if (container == null) {
            if (this.unknownContainerHandleAction == UnknownContainerAction.WARN) {
                this.getLogger().error("CONTAINER_NOT_FOUND for {}", detailsForLogging);
            } else if (this.unknownContainerHandleAction == UnknownContainerAction.DELETE) {
                ContainerID containerId = ContainerID.valueOf((long)replicaProto.getContainerID());
                this.deleteReplica(containerId, datanodeDetails, publisher, "CONTAINER_NOT_FOUND", true, detailsForLogging);
            }
            return;
        }
        try {
            this.processContainerReplica(datanodeDetails, container, replicaProto, publisher, detailsForLogging);
        }
        catch (IOException | InvalidStateTransitionException e) {
            this.getLogger().error("Failed to process {}", detailsForLogging, (Object)e);
        }
    }

    private void processMissingReplicas(DatanodeDetails datanodeDetails, Set<ContainerID> missingReplicas) {
        for (ContainerID id : missingReplicas) {
            try {
                this.getNodeManager().removeContainer(datanodeDetails, id);
            }
            catch (NodeNotFoundException e) {
                this.getLogger().warn("Failed to remove missing container {}: datanode {} not found", new Object[]{id, datanodeDetails, e});
            }
            try {
                this.getContainerManager().getContainerReplicas(id).stream().filter(replica -> replica.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                    try {
                        this.getContainerManager().removeContainerReplica(id, (ContainerReplica)replica);
                    }
                    catch (ContainerNotFoundException | ContainerReplicaNotFoundException throwable) {
                        // empty catch block
                    }
                });
            }
            catch (ContainerNotFoundException e) {
                this.getLogger().warn("Failed to remove container replica: container {} not found in datanode {}", new Object[]{id, datanodeDetails, e});
            }
        }
    }

    static enum UnknownContainerAction {
        WARN,
        DELETE;


        static UnknownContainerAction parse(String s) {
            return s.equals(DELETE.name()) ? DELETE : WARN;
        }
    }
}

