/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.reconciliation;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.reconciliation.ReconciliationEligibilityHandler;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.ReconcileContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileContainerEventHandler
implements EventHandler<ContainerID> {
    public static final Logger LOG = LoggerFactory.getLogger(ReconcileContainerEventHandler.class);
    private final ContainerManager containerManager;
    private final SCMContext scmContext;

    public ReconcileContainerEventHandler(ContainerManager containerManager, SCMContext scmContext) {
        this.containerManager = containerManager;
        this.scmContext = scmContext;
    }

    public void onMessage(ContainerID containerID, EventPublisher publisher) {
        if (!this.scmContext.isLeader()) {
            LOG.info("Skip reconciling container {} since current SCM is not leader.", (Object)containerID);
            return;
        }
        ReconciliationEligibilityHandler.EligibilityResult result = ReconciliationEligibilityHandler.isEligibleForReconciliation(containerID, this.containerManager);
        if (!result.isOk()) {
            LOG.error("{}", (Object)result);
            return;
        }
        try {
            Set allReplicaNodes = this.containerManager.getContainerReplicas(containerID).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toSet());
            LOG.info("Reconcile container event triggered for container {} with peers {}", (Object)containerID, allReplicaNodes);
            for (DatanodeDetails replica : allReplicaNodes) {
                Set otherReplicas = allReplicaNodes.stream().filter(other -> !other.equals((Object)replica)).collect(Collectors.toSet());
                ReconcileContainerCommand command = new ReconcileContainerCommand(containerID.getId(), otherReplicas);
                command.setTerm(this.scmContext.getTermOfLeader());
                publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(replica, (SCMCommand)command));
            }
        }
        catch (ContainerNotFoundException ex) {
            LOG.error("Failed to start reconciliation for container {}. Container not found.", (Object)containerID);
        }
        catch (NotLeaderException nle) {
            LOG.info("Skip reconciling container {} since current SCM is not leader.", (Object)containerID);
        }
    }
}

