/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationQueue;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationProcessor;

public class UnderReplicatedProcessor
extends UnhealthyReplicationProcessor<ContainerHealthResult.UnderReplicatedHealthResult> {
    UnderReplicatedProcessor(ReplicationManager replicationManager, Supplier<Duration> interval) {
        super(replicationManager, interval);
    }

    @Override
    protected ContainerHealthResult.UnderReplicatedHealthResult dequeueHealthResultFromQueue(ReplicationQueue queue) {
        return queue.dequeueUnderReplicatedContainer();
    }

    @Override
    protected void requeueHealthResult(ReplicationQueue queue, ContainerHealthResult.UnderReplicatedHealthResult healthResult) {
        queue.enqueue(healthResult);
    }

    @Override
    protected boolean inflightOperationLimitReached(ReplicationManager rm, long pendingOpLimit) {
        return rm.getInflightReplicationCount() >= pendingOpLimit;
    }

    @Override
    protected int sendDatanodeCommands(ReplicationManager replicationManager, ContainerHealthResult.UnderReplicatedHealthResult healthResult) throws IOException {
        return replicationManager.processUnderReplicatedContainer(healthResult);
    }
}

