/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@Metrics(about="SCM PipelineManager Metrics", context="ozone")
public final class SCMPipelineMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = SCMPipelineMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);
    private static SCMPipelineMetrics instance;
    @Metric
    private MutableCounterLong numPipelineAllocated;
    @Metric
    private MutableCounterLong numPipelineCreated;
    @Metric
    private MutableCounterLong numPipelineCreationFailed;
    @Metric
    private MutableCounterLong numPipelineDestroyed;
    @Metric
    private MutableCounterLong numPipelineDestroyFailed;
    @Metric
    private MutableCounterLong numPipelineReportProcessed;
    @Metric
    private MutableCounterLong numPipelineReportProcessingFailed;
    @Metric
    private MutableCounterLong numPipelineContainSameDatanodes;
    @Metric
    private MutableRate pipelineCreationLatencyNs;
    private final Map<PipelineID, MutableCounterLong> numBlocksAllocated = new ConcurrentHashMap<PipelineID, MutableCounterLong>();

    private SCMPipelineMetrics() {
    }

    public static synchronized SCMPipelineMetrics create() {
        if (instance != null) {
            return instance;
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        instance = (SCMPipelineMetrics)ms.register(SOURCE_NAME, "SCM PipelineManager Metrics", (Object)new SCMPipelineMetrics());
        return instance;
    }

    public static synchronized void unRegister() {
        instance = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        this.numPipelineAllocated.snapshot(recordBuilder, true);
        this.numPipelineCreated.snapshot(recordBuilder, true);
        this.numPipelineCreationFailed.snapshot(recordBuilder, true);
        this.numPipelineDestroyed.snapshot(recordBuilder, true);
        this.numPipelineDestroyFailed.snapshot(recordBuilder, true);
        this.numPipelineReportProcessed.snapshot(recordBuilder, true);
        this.numPipelineReportProcessingFailed.snapshot(recordBuilder, true);
        this.numPipelineContainSameDatanodes.snapshot(recordBuilder, true);
        this.pipelineCreationLatencyNs.snapshot(recordBuilder, true);
        this.numBlocksAllocated.forEach((pid, metric) -> metric.snapshot(recordBuilder, true));
    }

    void createPerPipelineMetrics(Pipeline pipeline) {
        this.numBlocksAllocated.put(pipeline.getId(), new MutableCounterLong(Interns.info((String)SCMPipelineMetrics.getBlockAllocationMetricName(pipeline), (String)("Number of blocks allocated in pipeline " + pipeline.getId())), 0L));
    }

    public static String getBlockAllocationMetricName(Pipeline pipeline) {
        return "NumBlocksAllocated-" + pipeline.getType() + "-" + pipeline.getReplicationConfig().toString() + "-" + pipeline.getId().getId();
    }

    void removePipelineMetrics(PipelineID pipelineID) {
        this.numBlocksAllocated.remove(pipelineID);
    }

    void incNumBlocksAllocated(PipelineID pipelineID) {
        Optional.ofNullable(this.numBlocksAllocated.get(pipelineID)).ifPresent(MutableCounterLong::incr);
    }

    void incNumPipelineAllocated() {
        this.numPipelineAllocated.incr();
    }

    void incNumPipelineCreated() {
        this.numPipelineCreated.incr();
    }

    void incNumPipelineCreationFailed() {
        this.numPipelineCreationFailed.incr();
    }

    void incNumPipelineDestroyed() {
        this.numPipelineDestroyed.incr();
    }

    void incNumPipelineDestroyFailed() {
        this.numPipelineDestroyFailed.incr();
    }

    void incNumPipelineReportProcessed() {
        this.numPipelineReportProcessed.incr();
    }

    void incNumPipelineReportProcessingFailed() {
        this.numPipelineReportProcessingFailed.incr();
    }

    void incNumPipelineContainSameDatanodes() {
        this.numPipelineContainSameDatanodes.incr();
    }

    public void updatePipelineCreationLatencyNs(long startNanos) {
        this.pipelineCreationLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }
}

