/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.ha.RatisUtil;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMSecurityProtocolServerSideTranslatorPB
implements SCMSecurityProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(SCMSecurityProtocolServerSideTranslatorPB.class);
    private final SCMSecurityProtocol impl;
    private final StorageContainerManager scm;
    private static final String ROLE_TYPE = "SCM";
    private OzoneProtocolMessageDispatcher<SCMSecurityProtocolProtos.SCMSecurityRequest, SCMSecurityProtocolProtos.SCMSecurityResponse, ProtocolMessageEnum> dispatcher;

    public SCMSecurityProtocolServerSideTranslatorPB(SCMSecurityProtocol impl, StorageContainerManager storageContainerManager, ProtocolMessageMetrics messageMetrics) {
        this.impl = impl;
        this.scm = storageContainerManager;
        this.dispatcher = new OzoneProtocolMessageDispatcher("ScmSecurityProtocol", messageMetrics, LOG);
    }

    public SCMSecurityProtocolProtos.SCMSecurityResponse submitRequest(RpcController controller, SCMSecurityProtocolProtos.SCMSecurityRequest request) throws ServiceException {
        if (!this.scm.checkLeader()) {
            RatisUtil.checkRatisException((IOException)((Object)this.scm.getScmHAManager().getRatisServer().triggerNotLeaderException()), this.scm.getSecurityProtocolRpcPort(), this.scm.getScmId(), this.scm.getHostname(), ROLE_TYPE);
        }
        return (SCMSecurityProtocolProtos.SCMSecurityResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
    }

    public SCMSecurityProtocolProtos.SCMSecurityResponse processRequest(SCMSecurityProtocolProtos.SCMSecurityRequest request) throws ServiceException {
        SCMSecurityProtocolProtos.SCMSecurityResponse.Builder scmSecurityResponse = SCMSecurityProtocolProtos.SCMSecurityResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecurityProtocolProtos.Status.OK);
        try {
            switch (request.getCmdType()) {
                case GetCertificate: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getCertificate(request.getGetCertificateRequest())).build();
                }
                case GetCACertificate: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getCACertificate(request.getGetCACertificateRequest())).build();
                }
                case GetOMCertificate: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getOMCertificate(request.getGetOMCertRequest())).build();
                }
                case GetDataNodeCertificate: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getDataNodeCertificate(request.getGetDataNodeCertRequest())).build();
                }
                case ListCertificate: {
                    return scmSecurityResponse.setListCertificateResponseProto(this.listCertificate(request.getListCertificateRequest())).build();
                }
                case GetSCMCertificate: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getSCMCertificate(request.getGetSCMCertificateRequest())).build();
                }
                case GetRootCACertificate: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getRootCACertificate()).build();
                }
                case ListCACertificate: {
                    return scmSecurityResponse.setListCertificateResponseProto(this.listCACertificate()).build();
                }
                case GetCrls: 
                case GetLatestCrlId: 
                case RevokeCertificates: {
                    return scmSecurityResponse.setStatus(SCMSecurityProtocolProtos.Status.INTERNAL_ERROR).setMessage("Unsupported operation.").setSuccess(false).build();
                }
                case GetCert: {
                    return scmSecurityResponse.setGetCertResponseProto(this.getCertificate(request.getGetCertRequest())).build();
                }
                case GetAllRootCaCertificates: {
                    return scmSecurityResponse.setAllRootCaCertificatesResponseProto(this.getAllRootCa()).build();
                }
                case RemoveExpiredCertificates: {
                    return scmSecurityResponse.setRemoveExpiredCertificatesResponseProto(this.removeExpiredCertificates()).build();
                }
            }
            throw new IllegalArgumentException("Unknown request type: " + request.getCmdType());
        }
        catch (IOException e) {
            RatisUtil.checkRatisException(e, this.scm.getSecurityProtocolRpcPort(), this.scm.getScmId(), this.scm.getHostname(), ROLE_TYPE);
            scmSecurityResponse.setSuccess(false);
            scmSecurityResponse.setStatus(this.exceptionToResponseStatus(e));
            if (e.getMessage() != null) {
                scmSecurityResponse.setMessage(e.getMessage());
            } else if (e.getCause() != null && e.getCause().getMessage() != null) {
                scmSecurityResponse.setMessage(e.getCause().getMessage());
            }
            return scmSecurityResponse.build();
        }
    }

    private SCMSecurityProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof SCMSecurityException) {
            return SCMSecurityProtocolProtos.Status.values()[((SCMSecurityException)ex).getErrorCode().ordinal()];
        }
        return SCMSecurityProtocolProtos.Status.INTERNAL_ERROR;
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificate(SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto request) throws IOException {
        String certificate = this.impl.getDataNodeCertificate(request.getDatanodeDetails(), request.getCSR());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(this.impl.getCACertificate());
        this.setRootCAIfNeeded(builder);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCertificate(SCMSecurityProtocolProtos.SCMGetCertRequestProto request) throws IOException {
        String certificate = this.impl.getCertificate(request.getNodeDetails(), request.getCSR());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(this.impl.getCACertificate());
        this.setRootCAIfNeeded(builder);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getSCMCertificate(SCMSecurityProtocolProtos.SCMGetSCMCertRequestProto request) throws IOException {
        if (!this.scm.getScmStorageConfig().isSCMHAEnabled()) {
            throw this.createNotHAException();
        }
        String certificate = this.impl.getSCMCertificate(request.getScmDetails(), request.getCSR(), request.hasRenew() && request.getRenew());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(this.impl.getRootCACertificate()).setX509RootCACertificate(this.impl.getRootCACertificate());
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertificate(SCMSecurityProtocolProtos.SCMGetOMCertRequestProto request) throws IOException {
        String certificate = this.impl.getOMCertificate(request.getOmDetails(), request.getCSR());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(this.impl.getCACertificate());
        this.setRootCAIfNeeded(builder);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCertificate(SCMSecurityProtocolProtos.SCMGetCertificateRequestProto request) throws IOException {
        String certificate = this.impl.getCertificate(request.getCertSerialId());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCACertificate(SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto request) throws IOException {
        String certificate = this.impl.getCACertificate();
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(certificate);
        this.setRootCAIfNeeded(builder);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMListCertificateResponseProto listCertificate(SCMSecurityProtocolProtos.SCMListCertificateRequestProto request) throws IOException {
        List certs = this.impl.listCertificate(request.getRole(), request.getStartCertId(), request.getCount());
        SCMSecurityProtocolProtos.SCMListCertificateResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMListCertificateResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMListCertificateResponseProto.ResponseCode.success).addAllCertificates((Iterable)certs);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getRootCACertificate() throws IOException {
        if (this.scm.getScmStorageConfig().checkPrimarySCMIdInitialized()) {
            throw this.createNotHAException();
        }
        String rootCACertificate = this.impl.getRootCACertificate();
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(rootCACertificate).setX509RootCACertificate(rootCACertificate);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMListCertificateResponseProto listCACertificate() throws IOException {
        List certs = this.impl.listCACertificate();
        SCMSecurityProtocolProtos.SCMListCertificateResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMListCertificateResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMListCertificateResponseProto.ResponseCode.success).addAllCertificates((Iterable)certs);
        return builder.build();
    }

    private SCMSecurityException createNotHAException() {
        return new SCMSecurityException("SCM is not Ratis enabled. Enable ozone.scm.ratis.enable config");
    }

    public SCMSecurityProtocolProtos.SCMGetAllRootCaCertificatesResponseProto getAllRootCa() throws IOException {
        return SCMSecurityProtocolProtos.SCMGetAllRootCaCertificatesResponseProto.newBuilder().addAllAllX509RootCaCertificates((Iterable)this.impl.getAllRootCaCertificates()).build();
    }

    private void setRootCAIfNeeded(SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder) throws IOException {
        if (this.scm.getScmStorageConfig().checkPrimarySCMIdInitialized()) {
            builder.setX509RootCACertificate(this.impl.getRootCACertificate());
        }
    }

    public SCMSecurityProtocolProtos.SCMRemoveExpiredCertificatesResponseProto removeExpiredCertificates() throws IOException {
        return SCMSecurityProtocolProtos.SCMRemoveExpiredCertificatesResponseProto.newBuilder().addAllRemovedExpiredCertificates((Iterable)this.impl.removeExpiredCertificates()).build();
    }
}

