/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.Closeable;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.AbstractRDBStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaOneDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaThreeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaTwoDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDatanodeStore
extends AbstractRDBStore<AbstractDatanodeDBDefinition>
implements DatanodeStore {
    private Table<String, Long> metadataTable;
    private Table<String, BlockData> blockDataTable;
    private Table<String, BlockData> lastChunkInfoTable;
    private Table<String, BlockData> blockDataTableWithIterator;
    private Table<String, Long> finalizeBlocksTable;
    private Table<String, Long> finalizeBlocksTableWithIterator;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDatanodeStore.class);

    protected AbstractDatanodeStore(ConfigurationSource config, AbstractDatanodeDBDefinition dbDef, boolean openReadOnly) throws RocksDatabaseException, CodecException {
        super(dbDef, config, openReadOnly);
    }

    @Override
    protected DBStore initDBStore(DBStoreBuilder dbStoreBuilder, ManagedDBOptions options, ConfigurationSource config) throws RocksDatabaseException, CodecException {
        AbstractDatanodeDBDefinition dbDefinition = (AbstractDatanodeDBDefinition)this.getDbDef();
        if (dbDefinition instanceof DatanodeSchemaOneDBDefinition || dbDefinition instanceof DatanodeSchemaTwoDBDefinition) {
            long maxWalSize = DBProfile.toLong((double)StorageUnit.MB.toBytes(2.0));
            options.setMaxTotalWalSize(maxWalSize);
        }
        DatanodeConfiguration dc = (DatanodeConfiguration)((Object)config.getObject(DatanodeConfiguration.class));
        if (dbDefinition instanceof DatanodeSchemaThreeDBDefinition) {
            options.setDeleteObsoleteFilesPeriodMicros(dc.getRocksdbDeleteObsoleteFilesPeriod());
            dbStoreBuilder.setDBJmxBeanNameName(dbDefinition.getDBLocation(config).getName() + "-" + dbDefinition.getName());
        }
        RDBStore dbStore = dbStoreBuilder.setDBOptions(options).build();
        this.metadataTable = new DatanodeTable<String, Long>((Table<String, Long>)dbDefinition.getMetadataColumnFamily().getTable((DBStore)dbStore));
        AbstractDatanodeStore.checkTableStatus(this.metadataTable, this.metadataTable.getName());
        this.blockDataTableWithIterator = dbDefinition.getBlockDataColumnFamily().getTable((DBStore)dbStore);
        this.blockDataTable = new DatanodeTable<String, BlockData>(this.blockDataTableWithIterator);
        AbstractDatanodeStore.checkTableStatus(this.blockDataTable, this.blockDataTable.getName());
        if (dbDefinition.getFinalizeBlocksColumnFamily() != null) {
            this.finalizeBlocksTableWithIterator = dbDefinition.getFinalizeBlocksColumnFamily().getTable((DBStore)dbStore);
            this.finalizeBlocksTable = new DatanodeTable<String, Long>(this.finalizeBlocksTableWithIterator);
            AbstractDatanodeStore.checkTableStatus(this.finalizeBlocksTable, this.finalizeBlocksTable.getName());
        }
        if (dbDefinition.getLastChunkInfoColumnFamily() != null) {
            this.lastChunkInfoTable = new DatanodeTable<String, BlockData>((Table<String, BlockData>)dbDefinition.getLastChunkInfoColumnFamily().getTable((DBStore)dbStore));
            AbstractDatanodeStore.checkTableStatus(this.lastChunkInfoTable, this.lastChunkInfoTable.getName());
        }
        return dbStore;
    }

    @Override
    public Table<String, Long> getMetadataTable() {
        return this.metadataTable;
    }

    @Override
    public Table<String, BlockData> getBlockDataTable() {
        return this.blockDataTable;
    }

    @Override
    public Table<String, BlockData> getLastChunkInfoTable() {
        return this.lastChunkInfoTable;
    }

    @Override
    public Table<String, ChunkInfoList> getDeletedBlocksTable() {
        throw new UnsupportedOperationException("DeletedBlocksTable is only supported in Container Schema One");
    }

    @Override
    public Table<String, Long> getFinalizeBlocksTable() {
        return this.finalizeBlocksTable;
    }

    @Override
    public BlockIterator<BlockData> getBlockIterator(long containerID) throws IOException {
        return new KeyValueBlockIterator(containerID, (Table.KeyValueIterator<String, BlockData>)this.blockDataTableWithIterator.iterator());
    }

    @Override
    public BlockIterator<BlockData> getBlockIterator(long containerID, MetadataKeyFilters.KeyPrefixFilter filter) throws IOException {
        return new KeyValueBlockIterator(containerID, (Table.KeyValueIterator<String, BlockData>)this.blockDataTableWithIterator.iterator(), filter);
    }

    @Override
    public BlockIterator<Long> getFinalizeBlockIterator(long containerID, MetadataKeyFilters.KeyPrefixFilter filter) throws IOException {
        return new KeyValueBlockLocalIdIterator(containerID, (Table.KeyValueIterator<String, Long>)this.finalizeBlocksTableWithIterator.iterator(), filter);
    }

    protected Table<String, BlockData> getBlockDataTableWithIterator() {
        return this.blockDataTableWithIterator;
    }

    protected Table<String, Long> getFinalizeBlocksTableWithIterator() {
        return this.finalizeBlocksTableWithIterator;
    }

    static void checkTableStatus(Table<?, ?> table, String name) throws RocksDatabaseException {
        if (table == null) {
            RocksDatabaseException e = new RocksDatabaseException("Failed to get table " + name + ": Please check the logs for more info.");
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    @InterfaceAudience.Public
    public static class KeyValueBlockIterator
    implements BlockIterator<BlockData>,
    Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(KeyValueBlockIterator.class);
        private final Table.KeyValueIterator<String, BlockData> blockIterator;
        private static final MetadataKeyFilters.KeyPrefixFilter DEFAULT_BLOCK_FILTER = MetadataKeyFilters.getUnprefixedKeyFilter();
        private final MetadataKeyFilters.KeyPrefixFilter blockFilter;
        private BlockData nextBlock;
        private final long containerID;

        KeyValueBlockIterator(long containerID, Table.KeyValueIterator<String, BlockData> iterator) {
            this.containerID = containerID;
            this.blockIterator = iterator;
            this.blockFilter = DEFAULT_BLOCK_FILTER;
        }

        KeyValueBlockIterator(long containerID, Table.KeyValueIterator<String, BlockData> iterator, MetadataKeyFilters.KeyPrefixFilter filter) {
            this.containerID = containerID;
            this.blockIterator = iterator;
            this.blockFilter = filter;
        }

        @Override
        public BlockData nextBlock() throws IOException, NoSuchElementException {
            if (this.nextBlock != null) {
                BlockData currentBlock = this.nextBlock;
                this.nextBlock = null;
                return currentBlock;
            }
            if (this.hasNext()) {
                return this.nextBlock();
            }
            throw new NoSuchElementException("Block Iterator reached end for ContainerID " + this.containerID);
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.nextBlock != null) {
                return true;
            }
            while (this.blockIterator.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)this.blockIterator.next();
                byte[] keyBytes = StringUtils.string2Bytes((String)((String)keyValue.getKey()));
                if (!this.blockFilter.filterKey(keyBytes)) continue;
                this.nextBlock = (BlockData)keyValue.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Block matching with filter found: blockID is : {} for containerID {}", (Object)this.nextBlock.getLocalID(), (Object)this.containerID);
                }
                return true;
            }
            return false;
        }

        @Override
        public void seekToFirst() {
            this.nextBlock = null;
            this.blockIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.nextBlock = null;
            this.blockIterator.seekToLast();
        }

        @Override
        public void close() throws IOException {
            this.blockIterator.close();
        }
    }

    @InterfaceAudience.Public
    public static class KeyValueBlockLocalIdIterator
    implements BlockIterator<Long>,
    Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(KeyValueBlockLocalIdIterator.class);
        private final Table.KeyValueIterator<String, Long> blockLocalIdIterator;
        private final MetadataKeyFilters.KeyPrefixFilter localIdFilter;
        private Long nextLocalId;
        private final long containerID;

        KeyValueBlockLocalIdIterator(long containerID, Table.KeyValueIterator<String, Long> iterator, MetadataKeyFilters.KeyPrefixFilter filter) {
            this.containerID = containerID;
            this.blockLocalIdIterator = iterator;
            this.localIdFilter = filter;
        }

        @Override
        public Long nextBlock() throws IOException, NoSuchElementException {
            if (this.nextLocalId != null) {
                Long currentLocalId = this.nextLocalId;
                this.nextLocalId = null;
                return currentLocalId;
            }
            if (this.hasNext()) {
                return this.nextBlock();
            }
            throw new NoSuchElementException("Block Local ID Iterator reached end for ContainerID " + this.containerID);
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.nextLocalId != null) {
                return true;
            }
            while (this.blockLocalIdIterator.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)this.blockLocalIdIterator.next();
                byte[] keyBytes = StringUtils.string2Bytes((String)((String)keyValue.getKey()));
                if (!this.localIdFilter.filterKey(keyBytes)) continue;
                this.nextLocalId = (Long)keyValue.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Block matching with filter found: LocalID is : {} for containerID {}", (Object)this.nextLocalId, (Object)this.containerID);
                }
                return true;
            }
            return false;
        }

        @Override
        public void seekToFirst() {
            this.nextLocalId = null;
            this.blockLocalIdIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.nextLocalId = null;
            this.blockLocalIdIterator.seekToLast();
        }

        @Override
        public void close() throws IOException {
            this.blockLocalIdIterator.close();
        }
    }
}

