/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.OzoneAcl;

public final class AclMetadata {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="aclList")
    private List<String> aclList;

    private AclMetadata(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.scope = builder.scope;
        this.aclList = builder.aclList;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public List<String> getAclList() {
        return this.aclList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static List<AclMetadata> fromOzoneAcls(List<OzoneAcl> ozoneAcls) {
        return ozoneAcls.stream().map(AclMetadata::fromOzoneAcl).collect(Collectors.toList());
    }

    public static AclMetadata fromOzoneAcl(OzoneAcl ozoneAcl) {
        if (ozoneAcl == null) {
            return null;
        }
        Builder builder = AclMetadata.newBuilder();
        return builder.setType(ozoneAcl.getType().toString().toUpperCase()).setName(ozoneAcl.getName()).setScope(ozoneAcl.getAclScope().toString().toUpperCase()).setAclList(ozoneAcl.getAclStringList()).build();
    }

    public static final class Builder {
        private String type;
        private String name;
        private String scope;
        private List<String> aclList;

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder setAclList(List<String> aclList) {
            this.aclList = aclList;
            return this;
        }

        public AclMetadata build() {
            Preconditions.checkNotNull((Object)this.type);
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.scope);
            return new AclMetadata(this);
        }
    }
}

