/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.recon.api.types.AclMetadata;

public class ObjectDBInfo {
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="quotaInBytes")
    private long quotaInBytes;
    @JsonProperty(value="quotaInNamespace")
    private long quotaInNamespace;
    @JsonProperty(value="usedNamespace")
    private long usedNamespace;
    @JsonProperty(value="creationTime")
    private long creationTime;
    @JsonProperty(value="modificationTime")
    private long modificationTime;
    @JsonProperty(value="acls")
    private List<AclMetadata> acls;

    public ObjectDBInfo() {
    }

    public ObjectDBInfo(OmDirectoryInfo omDirectoryInfo) {
        this.setName(omDirectoryInfo.getName());
        this.setCreationTime(omDirectoryInfo.getCreationTime());
        this.setModificationTime(omDirectoryInfo.getModificationTime());
        this.setAcls(AclMetadata.fromOzoneAcls(omDirectoryInfo.getAcls()));
        this.setMetadata(omDirectoryInfo.getMetadata());
    }

    public ObjectDBInfo(OmPrefixInfo omPrefixInfo) {
        this.setName(omPrefixInfo.getName());
        this.setAcls(AclMetadata.fromOzoneAcls(omPrefixInfo.getAcls()));
        this.setMetadata(omPrefixInfo.getMetadata());
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public void setQuotaInBytes(long quotaInBytes) {
        this.quotaInBytes = quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public void setQuotaInNamespace(long quotaInNamespace) {
        this.quotaInNamespace = quotaInNamespace;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public void setUsedNamespace(long usedNamespace) {
        this.usedNamespace = usedNamespace;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public List<AclMetadata> getAcls() {
        return this.acls;
    }

    public void setAcls(List<AclMetadata> acls) {
        this.acls = acls;
    }
}

