/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.recon.api.types.AclMetadata;
import org.apache.hadoop.ozone.recon.api.types.ObjectDBInfo;

public class VolumeObjectDBInfo
extends ObjectDBInfo {
    @JsonProperty(value="admin")
    private String admin;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="volume")
    private String volume;

    public VolumeObjectDBInfo() {
    }

    public VolumeObjectDBInfo(OmVolumeArgs omVolumeArgs) {
        super.setMetadata(omVolumeArgs.getMetadata());
        super.setName(omVolumeArgs.getVolume());
        super.setQuotaInBytes(omVolumeArgs.getQuotaInBytes());
        super.setQuotaInNamespace(omVolumeArgs.getQuotaInNamespace());
        super.setUsedNamespace(omVolumeArgs.getUsedNamespace());
        super.setCreationTime(omVolumeArgs.getCreationTime());
        super.setModificationTime(omVolumeArgs.getModificationTime());
        super.setAcls(AclMetadata.fromOzoneAcls(omVolumeArgs.getAcls()));
        this.setAdmin(omVolumeArgs.getAdminName());
        this.setOwner(omVolumeArgs.getOwnerName());
        this.setVolume(omVolumeArgs.getVolume());
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }
}

