/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.datanode.container;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.hadoop.ozone.debug.datanode.container.ContainerCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export one container to a tarball"})
public class ExportSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ExportSubcommand.class);
    @CommandLine.ParentCommand
    private ContainerCommands parent;
    @CommandLine.Option(names={"--container"}, required=true, description={"Container Id"})
    private long containerId;
    @CommandLine.Option(names={"--dest"}, defaultValue="/tmp", description={"Destination directory to hold exported container files"})
    private String destination;
    @CommandLine.Option(names={"--count"}, description={"Count of containers to export"})
    private long containerCount = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        this.parent.loadContainersFromVolumes();
        OnDemandContainerReplicationSource replicationSource = new OnDemandContainerReplicationSource(this.parent.getController());
        int i = 0;
        while ((long)i < this.containerCount) {
            block9: {
                File destinationFile;
                block10: {
                    replicationSource.prepare(this.containerId);
                    destinationFile = new File(this.destination, "container-" + this.containerId + ".tar");
                    try (OutputStream fos = Files.newOutputStream(destinationFile.toPath(), new OpenOption[0]);){
                        block8: {
                            try {
                                replicationSource.copyData(this.containerId, fos, CopyContainerCompression.NO_COMPRESSION);
                            }
                            catch (StorageContainerException e) {
                                if (e.getResult() != ContainerProtos.Result.CONTAINER_NOT_FOUND) break block8;
                                if (fos != null) {
                                    fos.close();
                                }
                                break block9;
                            }
                        }
                        if (fos == null) break block10;
                    }
                }
                LOG.info("Container {} is exported to {}", (Object)this.containerId, (Object)destinationFile);
                ++this.containerId;
            }
            ++i;
        }
        return null;
    }
}

