/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.logs.container;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.ozone.debug.logs.container.ContainerLogController;
import org.apache.hadoop.ozone.debug.logs.container.utils.ContainerDatanodeDatabase;
import org.apache.hadoop.ozone.debug.logs.container.utils.ContainerLogFileParser;
import picocli.CommandLine;

@CommandLine.Command(name="parse", description={"Parse container logs and extract key details such as datanode ID, container ID, state, BCSID, timestamp, log level, index value, and messages (if any)."})
public class ContainerLogParser
extends AbstractSubcommand
implements Callable<Void> {
    private static final int DEFAULT_THREAD_COUNT = 10;
    @CommandLine.Option(names={"--path"}, description={"Path to the folder which contains container log files to be parsed."}, required=true)
    private String path;
    @CommandLine.Option(names={"--thread-count"}, description={"Thread count for concurrent log file processing."}, defaultValue="10")
    private int threadCount;
    @CommandLine.ParentCommand
    private ContainerLogController parent;

    @Override
    public Void call() throws Exception {
        Path providedDbPath;
        Path logPath;
        if (this.threadCount <= 0) {
            this.out().println("Invalid threadCount value provided (" + this.threadCount + "). Using default value: " + 10);
            this.threadCount = 10;
        }
        if (!Files.exists(logPath = Paths.get(this.path, new String[0]), new LinkOption[0]) || !Files.isDirectory(logPath, new LinkOption[0])) {
            this.err().println("Invalid path provided: " + this.path);
            return null;
        }
        if (this.parent.getDbPath() == null) {
            providedDbPath = Paths.get(System.getProperty("user.dir"), "container_datanode.db");
            this.out().println("No database path provided. Creating new database at: " + providedDbPath);
        } else {
            providedDbPath = Paths.get(this.parent.getDbPath(), new String[0]);
            Path parentDir = providedDbPath.getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                this.err().println("The parent directory of the provided database path does not exist: " + parentDir);
                return null;
            }
        }
        ContainerDatanodeDatabase cdd = new ContainerDatanodeDatabase(providedDbPath.toString());
        ContainerLogFileParser parser = new ContainerLogFileParser();
        cdd.createDatanodeContainerLogTable();
        parser.processLogEntries(this.path, cdd, this.threadCount);
        cdd.insertLatestContainerLogData();
        cdd.createIndexes();
        this.out().println("Successfully parsed the log files and updated the respective tables");
        return null;
    }
}

