/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactoryImpl;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.debug.replicas.BlockVerificationResult;
import org.apache.hadoop.ozone.debug.replicas.ReplicaVerifier;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;

public class ChecksumVerifier
implements ReplicaVerifier {
    private final OzoneConfiguration conf;
    private final ContainerOperationClient containerClient;
    private final XceiverClientManager xceiverClientManager;
    private static final String CHECK_TYPE = "checksum";

    @Override
    public String getType() {
        return CHECK_TYPE;
    }

    public ChecksumVerifier(OzoneConfiguration conf) throws IOException {
        this.conf = conf;
        this.containerClient = new ContainerOperationClient(conf);
        this.xceiverClientManager = this.containerClient.getXceiverClientManager();
    }

    @Override
    public BlockVerificationResult verifyBlock(DatanodeDetails datanode, OmKeyLocationInfo keyLocation) {
        BlockVerificationResult blockVerificationResult;
        block9: {
            Pipeline pipeline = keyLocation.getPipeline().copyForReadFromNode(datanode);
            BlockExtendedInputStream is = new BlockInputStreamFactoryImpl().create(keyLocation.getPipeline().getReplicationConfig(), (BlockLocationInfo)keyLocation, pipeline, keyLocation.getToken(), (XceiverClientFactory)this.xceiverClientManager, null, (OzoneClientConfig)this.conf.getObject(OzoneClientConfig.class));
            try {
                IOUtils.copyLarge((InputStream)is, (OutputStream)NullOutputStream.INSTANCE);
                blockVerificationResult = BlockVerificationResult.pass();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Throwable cause;
                    Throwable throwable3 = cause = e.getCause() != null ? e.getCause() : e;
                    if (cause instanceof OzoneChecksumException) {
                        return BlockVerificationResult.failCheck(cause.getMessage());
                    }
                    return BlockVerificationResult.failIncomplete(cause.getMessage());
                }
            }
            is.close();
        }
        return blockVerificationResult;
    }
}

