/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryAdmin;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryCLIUtils;
import org.apache.hadoop.ozone.shell.ListLimitOptions;
import org.apache.hadoop.ozone.shell.PrefixFilterOption;
import picocli.CommandLine;

@CommandLine.Command(name="du", description={"Get disk usage for a path request."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DiskUsageSubCommand
implements Callable {
    @CommandLine.ParentCommand
    private NSSummaryAdmin parent;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Non-empty path request without any protocol prefix."})
    private String path;
    @CommandLine.Option(names={"-f", "--file"}, description={"List direct files as a sub path."})
    private boolean listFiles;
    @CommandLine.Option(names={"-r", "--replica"}, description={"Show disk usage with replication."})
    private boolean withReplica;
    @CommandLine.Option(names={"-n", "--no-header"}, description={"Show DU without the header for current path."})
    private boolean noHeader;
    @CommandLine.Mixin
    private ListLimitOptions listOptions;
    @CommandLine.Mixin
    private PrefixFilterOption prefixFilter;
    private static final String ENDPOINT = "/api/v1/namespace/usage";
    private static final String SIZE_HEADER = "Size";
    private static final String DU_HEADER = "Disk Usage";
    private static final String PATH_HEADER = "Path Name";
    private static final int SIZE_INDENT = 2;
    private static final int DU_INDENT = 12;
    private static final int PATH_INDENT = 27;

    public Void call() throws Exception {
        block9: {
            JsonNode duResponse;
            block10: {
                block11: {
                    block8: {
                        if (this.path == null || this.path.isEmpty()) {
                            NSSummaryCLIUtils.printEmptyPathRequest();
                            return null;
                        }
                        StringBuilder url = new StringBuilder();
                        url.append(this.parent.getReconWebAddress()).append(ENDPOINT);
                        String response = NSSummaryCLIUtils.makeHttpCall(url, NSSummaryCLIUtils.parseInputPath(this.path), this.listFiles, this.withReplica, this.parent.isHTTPSEnabled(), this.parent.getOzoneConfig());
                        NSSummaryCLIUtils.printNewLines(1);
                        if (response == null) {
                            NSSummaryCLIUtils.printNewLines(1);
                            return null;
                        }
                        duResponse = JsonUtils.readTree((String)response);
                        if (!"PATH_NOT_FOUND".equals(duResponse.path("status").asText(""))) break block8;
                        NSSummaryCLIUtils.printPathNotFound();
                        break block9;
                    }
                    long totalSize = duResponse.path("size").asLong(-1L);
                    if (!this.noHeader) {
                        NSSummaryCLIUtils.printWithUnderline("Path", false);
                        NSSummaryCLIUtils.printKVSeparator();
                        System.out.println(duResponse.path("path").asText(""));
                        NSSummaryCLIUtils.printWithUnderline("Total Size", false);
                        NSSummaryCLIUtils.printKVSeparator();
                        System.out.println(FileUtils.byteCountToDisplaySize((long)totalSize));
                        if (this.withReplica) {
                            NSSummaryCLIUtils.printWithUnderline("Total Disk Usage", false);
                            NSSummaryCLIUtils.printKVSeparator();
                            long du = duResponse.path("sizeWithReplica").asLong(-1L);
                            System.out.println(FileUtils.byteCountToDisplaySize((long)du));
                        }
                        long sizeDirectKey = duResponse.path("sizeDirectKey").asLong(-1L);
                        if (!this.listFiles && sizeDirectKey != -1L) {
                            NSSummaryCLIUtils.printWithUnderline("Size of Direct Keys", false);
                            NSSummaryCLIUtils.printKVSeparator();
                            System.out.println(FileUtils.byteCountToDisplaySize((long)sizeDirectKey));
                        }
                        NSSummaryCLIUtils.printNewLines(1);
                    }
                    if (duResponse.path("subPathCount").asInt(-1) != 0) break block10;
                    if (totalSize != 0L) break block11;
                    System.out.println("The object is empty.\nPut more files into it to visualize DU");
                    break block9;
                }
                System.out.println("There's no immediate sub-path under this object.");
                if (this.listFiles) break block9;
                System.out.println("Add -f as an option to visualize files as sub-path, if any.");
                break block9;
            }
            NSSummaryCLIUtils.printWithUnderline("DU", true);
            this.printDUHeader();
            int limit = this.listOptions.getLimit();
            String seekStr = this.prefixFilter.getPrefix();
            if (seekStr == null) {
                seekStr = "";
            }
            ArrayNode subPaths = (ArrayNode)duResponse.path("subPaths");
            int cnt = 0;
            for (JsonNode subPathDU : subPaths) {
                if (cnt >= limit) break;
                String subPath = subPathDU.path("path").asText("");
                if (!subPathDU.path("isKey").asBoolean(false)) {
                    subPath = subPath + "/";
                }
                long size = subPathDU.path("size").asLong(-1L);
                long sizeWithReplica = subPathDU.path("sizeWithReplica").asLong(-1L);
                if (!subPath.startsWith(seekStr)) continue;
                this.printDURow(subPath, size, sizeWithReplica);
                ++cnt;
            }
        }
        NSSummaryCLIUtils.printNewLines(1);
        return null;
    }

    private void printDUHeader() {
        NSSummaryCLIUtils.printSpaces(2);
        System.out.print(SIZE_HEADER);
        NSSummaryCLIUtils.printSpaces(10 - SIZE_HEADER.length());
        if (this.withReplica) {
            System.out.print(DU_HEADER);
            NSSummaryCLIUtils.printSpaces(15 - DU_HEADER.length());
            System.out.println(PATH_HEADER);
        } else {
            System.out.println(PATH_HEADER);
        }
    }

    private void printDURow(String subPath, long size, long sizeWithReplica) {
        NSSummaryCLIUtils.printSpaces(2);
        String dataSize = FileUtils.byteCountToDisplaySize((long)size);
        System.out.print(dataSize);
        NSSummaryCLIUtils.printSpaces(10 - dataSize.length());
        if (sizeWithReplica != -1L) {
            String dataSizeWithReplica = FileUtils.byteCountToDisplaySize((long)sizeWithReplica);
            System.out.print(dataSizeWithReplica);
            NSSummaryCLIUtils.printSpaces(15 - dataSizeWithReplica.length());
        }
        System.out.println(subPath);
    }
}

