/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.CompositeCrcFileChecksum;
import org.apache.hadoop.ozone.client.checksum.CrcComposer;
import org.apache.hadoop.ozone.client.checksum.CrcUtil;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileChecksumHelper {
    static final Logger LOG = LoggerFactory.getLogger(BaseFileChecksumHelper.class);
    private OmKeyInfo keyInfo;
    private OzoneVolume volume;
    private OzoneBucket bucket;
    private String keyName;
    private final long length;
    private ClientProtocol rpcClient;
    private OzoneClientConfig.ChecksumCombineMode combineMode;
    private ContainerProtos.ChecksumType checksumType;
    private final DataOutputBuffer blockChecksumBuf = new DataOutputBuffer();
    private XceiverClientFactory xceiverClientFactory;
    private FileChecksum fileChecksum;
    private List<OmKeyLocationInfo> keyLocationInfos;
    private long remaining = 0L;
    private int bytesPerCRC = -1;
    private long crcPerBlock = 0L;

    BaseFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient) throws IOException {
        this.volume = volume;
        this.bucket = bucket;
        this.keyName = keyName;
        this.length = length;
        this.combineMode = checksumCombineMode;
        this.rpcClient = rpcClient;
        this.xceiverClientFactory = ((RpcClient)rpcClient).getXceiverClientManager();
        if (this.length > 0L) {
            this.fetchBlocks();
        }
    }

    public BaseFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient, OmKeyInfo keyInfo) throws IOException {
        this(volume, bucket, keyName, length, checksumCombineMode, rpcClient);
        this.keyInfo = keyInfo;
    }

    protected String getSrc() {
        return "Volume: " + this.volume.getName() + " Bucket: " + this.bucket.getName() + " " + this.keyName;
    }

    protected long getLength() {
        return this.length;
    }

    protected ClientProtocol getRpcClient() {
        return this.rpcClient;
    }

    protected OzoneClientConfig.ChecksumCombineMode getCombineMode() {
        return this.combineMode;
    }

    protected ContainerProtos.ChecksumType getChecksumType() {
        return this.checksumType;
    }

    protected XceiverClientFactory getXceiverClientFactory() {
        return this.xceiverClientFactory;
    }

    protected DataOutputBuffer getBlockChecksumBuf() {
        return this.blockChecksumBuf;
    }

    protected List<OmKeyLocationInfo> getKeyLocationInfoList() {
        return this.keyLocationInfos;
    }

    protected long getRemaining() {
        return this.remaining;
    }

    protected void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    protected OmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    int getBytesPerCRC() {
        return this.bytesPerCRC;
    }

    protected void setBytesPerCRC(int bytesPerCRC) {
        this.bytesPerCRC = bytesPerCRC;
    }

    protected void setChecksumType(ContainerProtos.ChecksumType type) {
        this.checksumType = type;
    }

    protected abstract AbstractBlockChecksumComputer getBlockChecksumComputer(List<ContainerProtos.ChunkInfo> var1, long var2);

    protected abstract List<ContainerProtos.ChunkInfo> getChunkInfos(OmKeyLocationInfo var1) throws IOException;

    protected ByteBuffer getBlockChecksumFromChunkChecksums(AbstractBlockChecksumComputer blockChecksumComputer) throws IOException {
        blockChecksumComputer.compute(this.getCombineMode());
        return blockChecksumComputer.getOutByteBuffer();
    }

    protected String populateBlockChecksumBuf(ByteBuffer blockChecksumByteBuffer) throws IOException {
        String blockChecksumForDebug = null;
        switch (this.getCombineMode()) {
            case MD5MD5CRC: {
                MD5Hash md5 = new MD5Hash(blockChecksumByteBuffer.array());
                md5.write((DataOutput)this.getBlockChecksumBuf());
                if (!LOG.isDebugEnabled()) break;
                blockChecksumForDebug = md5.toString();
                break;
            }
            case COMPOSITE_CRC: {
                byte[] crcBytes = blockChecksumByteBuffer.array();
                if (LOG.isDebugEnabled()) {
                    blockChecksumForDebug = CrcUtil.toMultiCrcString((byte[])crcBytes);
                }
                this.getBlockChecksumBuf().write(crcBytes);
                break;
            }
            default: {
                throw new IOException("Unknown combine mode: " + this.getCombineMode());
            }
        }
        return blockChecksumForDebug;
    }

    protected void checksumBlocks() throws IOException {
        long currentLength = 0L;
        for (int blockIdx = 0; blockIdx < this.getKeyLocationInfoList().size() && this.getRemaining() >= 0L; ++blockIdx) {
            OmKeyLocationInfo keyLocationInfo = this.getKeyLocationInfoList().get(blockIdx);
            if (currentLength > this.getLength()) {
                return;
            }
            if (!this.checksumBlock(keyLocationInfo)) {
                throw new PathIOException(this.getSrc(), "Fail to get block checksum for " + keyLocationInfo + ", checksum combine mode: " + this.getCombineMode());
            }
            currentLength += keyLocationInfo.getLength();
        }
    }

    protected boolean checksumBlock(OmKeyLocationInfo keyLocationInfo) throws IOException {
        List<ContainerProtos.ChunkInfo> chunkInfos = this.getChunkInfos(keyLocationInfo);
        if (chunkInfos.isEmpty()) {
            return false;
        }
        long blockNumBytes = keyLocationInfo.getLength();
        if (this.getRemaining() < blockNumBytes) {
            blockNumBytes = this.getRemaining();
        }
        this.setRemaining(this.getRemaining() - blockNumBytes);
        ContainerProtos.ChecksumData checksumData = chunkInfos.get(0).getChecksumData();
        this.setChecksumType(checksumData.getType());
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        this.setBytesPerCRC(bytesPerChecksum);
        AbstractBlockChecksumComputer blockChecksumComputer = this.getBlockChecksumComputer(chunkInfos, keyLocationInfo.getLength());
        ByteBuffer blockChecksumByteBuffer = this.getBlockChecksumFromChunkChecksums(blockChecksumComputer);
        String blockChecksumForDebug = this.populateBlockChecksumBuf(blockChecksumByteBuffer);
        LOG.debug("Got reply from {} {} for block {}: blockChecksum={}, blockChecksumType={}", new Object[]{this.keyInfo.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC ? "EC pipeline" : "pipeline", keyLocationInfo.getPipeline(), keyLocationInfo.getBlockID(), blockChecksumForDebug, checksumData.getType()});
        return true;
    }

    private void fetchBlocks() throws IOException {
        if (this.keyInfo == null) {
            OzoneManagerProtocol ozoneManagerClient = this.getRpcClient().getOzoneManagerClient();
            OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(this.volume.getName()).setBucketName(this.bucket.getName()).setKeyName(this.keyName).setSortDatanodesInPipeline(true).setLatestVersionLocation(true).build();
            this.keyInfo = ozoneManagerClient.lookupKey(keyArgs);
        }
        if (this.keyInfo.getFileChecksum() != null && this.isFullLength(this.keyInfo.getDataSize())) {
            this.fileChecksum = this.keyInfo.getFileChecksum();
        }
        this.keyLocationInfos = this.keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
    }

    private boolean isFullLength(long dataSize) {
        return this.length >= dataSize;
    }

    public void compute() throws IOException {
        if (this.fileChecksum != null) {
            LOG.debug("Checksum is available. Skip computing it.");
            return;
        }
        if (this.keyLocationInfos == null || this.keyLocationInfos.isEmpty()) {
            int lenOfZeroBytes = 32;
            byte[] emptyBlockMd5 = new byte[32];
            MD5Hash fileMD5 = MD5Hash.digest((byte[])emptyBlockMd5);
            this.fileChecksum = new MD5MD5CRC32GzipFileChecksum(0, 0L, fileMD5);
        } else {
            this.checksumBlocks();
            this.fileChecksum = this.makeFinalResult();
        }
    }

    private FileChecksum makeFinalResult() throws IOException {
        switch (this.getCombineMode()) {
            case MD5MD5CRC: {
                return this.makeMd5CrcResult();
            }
            case COMPOSITE_CRC: {
                return this.makeCompositeCrcResult();
            }
        }
        throw new IOException("Unknown ChecksumCombineMode: " + this.getCombineMode());
    }

    private FileChecksum makeMd5CrcResult() {
        MD5Hash fileMD5 = MD5Hash.digest((byte[])this.getBlockChecksumBuf().getData());
        switch (this.getChecksumType()) {
            case CRC32: {
                return new MD5MD5CRC32GzipFileChecksum(this.getBytesPerCRC(), this.crcPerBlock, fileMD5);
            }
            case CRC32C: {
                return new MD5MD5CRC32CastagnoliFileChecksum(this.getBytesPerCRC(), this.crcPerBlock, fileMD5);
            }
        }
        throw new IllegalArgumentException("unexpected checksum type " + this.getChecksumType());
    }

    DataChecksum.Type toHadoopChecksumType() {
        switch (this.checksumType) {
            case CRC32: {
                return DataChecksum.Type.CRC32;
            }
            case CRC32C: {
                return DataChecksum.Type.CRC32C;
            }
        }
        throw new IllegalArgumentException("unsupported checksum type");
    }

    FileChecksum makeCompositeCrcResult() throws IOException {
        long blockSizeHint = 0L;
        if (!this.keyLocationInfos.isEmpty()) {
            blockSizeHint = this.keyLocationInfos.get(0).getLength();
        }
        CrcComposer crcComposer = CrcComposer.newCrcComposer((DataChecksum.Type)this.toHadoopChecksumType(), (long)blockSizeHint);
        byte[] blockChecksumBytes = this.blockChecksumBuf.getData();
        for (int i = 0; i < this.keyLocationInfos.size(); ++i) {
            OmKeyLocationInfo block = this.keyLocationInfos.get(i);
            int blockCrc = CrcUtil.readInt((byte[])blockChecksumBytes, (int)(i * 4));
            crcComposer.update(blockCrc, block.getLength());
            LOG.debug("Added blockCrc 0x{} for block index {} of size {}", new Object[]{Integer.toString(blockCrc, 16), i, block.getLength()});
        }
        int compositeCrc = CrcUtil.readInt((byte[])crcComposer.digest(), (int)0);
        return new CompositeCrcFileChecksum(compositeCrc, this.toHadoopChecksumType(), this.bytesPerCRC);
    }

    public FileChecksum getFileChecksum() {
        return this.fileChecksum;
    }
}

