/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.OMSystemAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMOpenKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMOpenKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMOpenKeysDeleteRequest.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMSYSTEMLOGGER);
    private static final String AUDIT_PARAM_NUM_OPEN_KEYS = "numOpenKeysDeleted";
    private static final String AUDIT_PARAM_OPEN_KEYS = "openKeysDeleted";

    public OMOpenKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        HashMap<String, Pair<Long, OmKeyInfo>> deletedOpenKeys;
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        long numSubmittedOpenKeys;
        OzoneManagerProtocolProtos.DeleteOpenKeysRequest deleteOpenKeysRequest;
        OMMetrics omMetrics;
        block11: {
            long trxnLogIndex = context.getIndex();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumOpenKeyDeleteRequests();
            deleteOpenKeysRequest = this.getOmRequest().getDeleteOpenKeysRequest();
            List submittedOpenKeyBuckets = deleteOpenKeysRequest.getOpenKeysPerBucketList();
            numSubmittedOpenKeys = 0L;
            for (OzoneManagerProtocolProtos.OpenKeyBucket keyBucket : submittedOpenKeyBuckets) {
                numSubmittedOpenKeys += (long)keyBucket.getKeysCount();
            }
            LOG.debug("{} open keys submitted for deletion.", (Object)numSubmittedOpenKeys);
            omMetrics.incNumOpenKeysSubmittedForDeletion(numSubmittedOpenKeys);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            Exception exception = null;
            omClientResponse = null;
            result = null;
            deletedOpenKeys = new HashMap<String, Pair<Long, OmKeyInfo>>();
            LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
            try {
                try {
                    for (OzoneManagerProtocolProtos.OpenKeyBucket openKeyBucket : submittedOpenKeyBuckets) {
                        this.updateOpenKeyTableCache(ozoneManager, trxnLogIndex, openKeyBucket, deletedOpenKeys);
                    }
                    omClientResponse = new OMOpenKeysDeleteResponse(omResponse.build(), deletedOpenKeys, this.getBucketLayout());
                    result = OMClientRequest.Result.SUCCESS;
                    ArrayList<String> deletedOpenKeysLight = new ArrayList<String>(deletedOpenKeys.size());
                    for (Pair key : deletedOpenKeys.values()) {
                        OmKeyInfo keyInfo = (OmKeyInfo)key.getRight();
                        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(keyInfo.getKeyName()).build();
                        deletedOpenKeysLight.add(this.buildLightKeyArgsAuditMap(keyArgs).toString());
                    }
                    auditParams.put(AUDIT_PARAM_NUM_OPEN_KEYS, String.valueOf(deletedOpenKeys.size()));
                    auditParams.put(AUDIT_PARAM_OPEN_KEYS, ((Object)deletedOpenKeysLight).toString());
                    AUDIT.logWriteSuccess(ozoneManager.buildAuditMessageForSuccess(OMSystemAction.OPEN_KEY_CLEANUP, auditParams));
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.OPEN_KEY_CLEANUP, auditParams, ex));
                    exception = ex;
                    omClientResponse = new OMOpenKeysDeleteResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.processResults(omMetrics, numSubmittedOpenKeys, deletedOpenKeys.size(), deleteOpenKeysRequest, result);
        return omClientResponse;
    }

    private void processResults(OMMetrics omMetrics, long numSubmittedOpenKeys, long numDeletedOpenKeys, OzoneManagerProtocolProtos.DeleteOpenKeysRequest request, OMClientRequest.Result result) {
        switch (result) {
            case SUCCESS: {
                LOG.debug("Deleted {} open keys out of {} submitted keys.", (Object)numDeletedOpenKeys, (Object)numSubmittedOpenKeys);
                break;
            }
            case FAILURE: {
                omMetrics.incNumOpenKeyDeleteRequestFails();
                LOG.error("Failure occurred while trying to delete {} submitted open keys.", (Object)numSubmittedOpenKeys);
                break;
            }
            default: {
                LOG.error("Unrecognized result for OMOpenKeysDeleteRequest: {}", (Object)request);
            }
        }
    }

    protected void updateOpenKeyTableCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerProtocolProtos.OpenKeyBucket keysPerBucket, Map<String, Pair<Long, OmKeyInfo>> deletedOpenKeys) throws IOException {
        boolean acquiredLock = false;
        String volumeName = keysPerBucket.getVolumeName();
        String bucketName = keysPerBucket.getBucketName();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        try {
            this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            acquiredLock = this.getOmLockDetails().isLockAcquired();
            OmBucketInfo omBucketInfo = OMOpenKeysDeleteRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
            long bucketId = omBucketInfo == null ? 0L : omBucketInfo.getObjectID();
            for (OzoneManagerProtocolProtos.OpenKey key : keysPerBucket.getKeysList()) {
                String fullKeyName = key.getName();
                OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)fullKeyName);
                if (omKeyInfo != null) {
                    if (trxnLogIndex < omKeyInfo.getUpdateID()) {
                        LOG.warn("Transaction log index {} is smaller than the current updateID {} of key {}, skipping deletion.", new Object[]{trxnLogIndex, omKeyInfo.getUpdateID(), fullKeyName});
                        continue;
                    }
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    deletedOpenKeys.put(fullKeyName, (Pair<Long, OmKeyInfo>)Pair.of((Object)bucketId, (Object)omKeyInfo));
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)fullKeyName), CacheValue.get((long)trxnLogIndex));
                    ozoneManager.getMetrics().incNumOpenKeysDeleted();
                    LOG.debug("Open key {} deleted.", (Object)fullKeyName);
                    continue;
                }
                LOG.debug("Key {} was not deleted, as it was not found in the open key table.", (Object)fullKeyName);
            }
        }
        catch (Throwable throwable) {
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            throw throwable;
        }
        if (acquiredLock) {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
        }
    }
}

