/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocolPB.OMAdminProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerAdminProtocolProtos;

public class OMAdminProtocolServerSideImpl
implements OMAdminProtocolPB {
    private final OzoneManager ozoneManager;

    public OMAdminProtocolServerSideImpl(OzoneManager om) {
        this.ozoneManager = om;
    }

    public OzoneManagerAdminProtocolProtos.OMConfigurationResponse getOMConfiguration(RpcController controller, OzoneManagerAdminProtocolProtos.OMConfigurationRequest request) throws ServiceException {
        List<OMNodeDetails> oldOMNodesList = this.ozoneManager.getAllOMNodesInMemory();
        List<OMNodeDetails> newOMNodesList = this.ozoneManager.getAllOMNodesInNewConf();
        ArrayList<OzoneManagerAdminProtocolProtos.OMNodeInfo> omNodesInMemory = new ArrayList<OzoneManagerAdminProtocolProtos.OMNodeInfo>(oldOMNodesList.size());
        for (OMNodeDetails omNodeDetails : oldOMNodesList) {
            omNodesInMemory.add(omNodeDetails.getProtobuf());
        }
        ArrayList<OzoneManagerAdminProtocolProtos.OMNodeInfo> omNodesInNewConf = new ArrayList<OzoneManagerAdminProtocolProtos.OMNodeInfo>(newOMNodesList.size());
        for (OMNodeDetails omNodeDetails : newOMNodesList) {
            omNodesInNewConf.add(omNodeDetails.getProtobuf());
        }
        return OzoneManagerAdminProtocolProtos.OMConfigurationResponse.newBuilder().setSuccess(true).addAllNodesInMemory(omNodesInMemory).addAllNodesInNewConf(omNodesInNewConf).build();
    }

    public OzoneManagerAdminProtocolProtos.DecommissionOMResponse decommission(RpcController controller, OzoneManagerAdminProtocolProtos.DecommissionOMRequest request) throws ServiceException {
        if (request == null) {
            return null;
        }
        OzoneManagerRatisServer omRatisServer = this.ozoneManager.getOmRatisServer();
        OzoneManagerRatisUtils.checkLeaderStatus(this.ozoneManager);
        OMNodeDetails decommNode = this.ozoneManager.getPeerNode(request.getNodeId());
        if (decommNode == null) {
            return OzoneManagerAdminProtocolProtos.DecommissionOMResponse.newBuilder().setSuccess(false).setErrorMsg("OM node not present in the OM peer list.").build();
        }
        try {
            if (!this.ozoneManager.isAdmin(HddsServerUtil.getRemoteUser())) {
                throw new OMException("Only administrators are authorized to perform decommission.", OMException.ResultCodes.PERMISSION_DENIED);
            }
            omRatisServer.removeOMFromRatisRing(decommNode);
        }
        catch (IOException ex) {
            return OzoneManagerAdminProtocolProtos.DecommissionOMResponse.newBuilder().setSuccess(false).setErrorMsg(ex.getMessage()).build();
        }
        return OzoneManagerAdminProtocolProtos.DecommissionOMResponse.newBuilder().setSuccess(true).build();
    }

    public OzoneManagerAdminProtocolProtos.CompactResponse compactDB(RpcController controller, OzoneManagerAdminProtocolProtos.CompactRequest compactRequest) throws ServiceException {
        try {
            this.ozoneManager.getMetadataManager().getStore().getTable(compactRequest.getColumnFamily());
            this.ozoneManager.compactOMDB(compactRequest.getColumnFamily());
        }
        catch (Exception ex) {
            return OzoneManagerAdminProtocolProtos.CompactResponse.newBuilder().setSuccess(false).setErrorMsg(ex.getMessage()).build();
        }
        return OzoneManagerAdminProtocolProtos.CompactResponse.newBuilder().setSuccess(true).build();
    }
}

