/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.protocol.S3Auth;
import org.apache.hadoop.ozone.s3.RequestIdentifier;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.metrics.S3GatewayMetrics;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.util.AuditUtils;
import org.apache.hadoop.ozone.s3.util.S3Consts;
import org.apache.hadoop.util.Time;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EndpointBase
implements Auditor {
    protected static final String ETAG_CUSTOM = "etag-custom";
    @Inject
    private OzoneClient client;
    @Inject
    protected SignatureInfo signatureInfo;
    @Inject
    private RequestIdentifier requestIdentifier;
    private S3Auth s3Auth;
    @Context
    private ContainerRequestContext context;
    private Set<String> excludeMetadataFields = new HashSet<String>(Arrays.asList("gdprEnabled", "storage-config"));
    private static final Logger LOG = LoggerFactory.getLogger(EndpointBase.class);
    protected static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.S3GLOGGER);

    protected OzoneBucket getBucket(OzoneVolume volume, String bucketName) throws OS3Exception, IOException {
        OzoneBucket bucket;
        try {
            bucket = volume.getBucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_TOKEN) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, this.s3Auth.getAccessID(), (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.TIMEOUT || ex.getResult() == OMException.ResultCodes.INTERNAL_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, bucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
        return bucket;
    }

    @PostConstruct
    public void initialization() {
        this.s3Auth = new S3Auth(this.signatureInfo.getStringToSign(), this.signatureInfo.getSignature(), this.signatureInfo.getAwsAccessId(), this.signatureInfo.getAwsAccessId());
        LOG.debug("S3 access id: {}", (Object)this.s3Auth.getAccessID());
        ClientProtocol clientProtocol = this.getClient().getObjectStore().getClientProxy();
        clientProtocol.setThreadLocalS3Auth(this.s3Auth);
        clientProtocol.setIsS3Request(true);
        this.init();
    }

    public abstract void init();

    protected OzoneBucket getBucket(String bucketName) throws OS3Exception, IOException {
        OzoneBucket bucket;
        try {
            bucket = this.client.getObjectStore().getS3Bucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND || ex.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_TOKEN) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, this.s3Auth.getAccessID(), (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.TIMEOUT || ex.getResult() == OMException.ResultCodes.INTERNAL_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, bucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
        return bucket;
    }

    protected OzoneVolume getVolume() throws IOException {
        return this.client.getObjectStore().getS3Volume();
    }

    protected String createS3Bucket(String bucketName) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        try {
            this.client.getObjectStore().createS3Bucket(bucketName);
        }
        catch (OMException ex) {
            this.getMetrics().updateCreateBucketFailureStats(startNanos);
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_TOKEN) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, this.s3Auth.getAccessID(), (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.TIMEOUT || ex.getResult() == OMException.ResultCodes.INTERNAL_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_ALREADY_EXISTS) {
                throw S3ErrorTable.newError(S3ErrorTable.BUCKET_ALREADY_EXISTS, bucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
        return "/" + bucketName;
    }

    protected void deleteS3Bucket(String s3BucketName) throws IOException, OS3Exception {
        try {
            this.client.getObjectStore().deleteS3Bucket(s3BucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, s3BucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_TOKEN) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, this.s3Auth.getAccessID(), (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.TIMEOUT || ex.getResult() == OMException.ResultCodes.INTERNAL_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, s3BucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
    }

    protected Iterator<? extends OzoneBucket> listS3Buckets(String prefix, Consumer<OzoneVolume> volumeProcessor) throws IOException, OS3Exception {
        return this.iterateBuckets(volume -> volume.listBuckets(prefix), volumeProcessor);
    }

    protected Iterator<? extends OzoneBucket> listS3Buckets(String prefix, String previousBucket, Consumer<OzoneVolume> volumeProcessor) throws IOException, OS3Exception {
        return this.iterateBuckets(volume -> volume.listBuckets(prefix, previousBucket), volumeProcessor);
    }

    private Iterator<? extends OzoneBucket> iterateBuckets(Function<OzoneVolume, Iterator<? extends OzoneBucket>> query, Consumer<OzoneVolume> ownerSetter) throws IOException, OS3Exception {
        try {
            OzoneVolume volume = this.getVolume();
            ownerSetter.accept(volume);
            return query.apply(volume);
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                return Collections.emptyIterator();
            }
            if (e.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, "listBuckets", (Exception)((Object)e));
            }
            if (e.getResult() == OMException.ResultCodes.INVALID_TOKEN) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, this.s3Auth.getAccessID(), (Exception)((Object)e));
            }
            if (e.getResult() == OMException.ResultCodes.TIMEOUT || e.getResult() == OMException.ResultCodes.INTERNAL_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, "listBuckets", (Exception)((Object)e));
            }
            throw e;
        }
    }

    protected Map<String, String> getCustomMetadataFromHeaders(MultivaluedMap<String, String> requestHeaders) throws OS3Exception {
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        if (requestHeaders == null || requestHeaders.isEmpty()) {
            return customMetadata;
        }
        Set customMetadataKeys = requestHeaders.keySet().stream().filter(k -> k.toLowerCase().startsWith("x-amz-meta-") && !this.excludeMetadataFields.contains(k.substring("x-amz-meta-".length()))).collect(Collectors.toSet());
        long sizeInBytes = 0L;
        if (!customMetadataKeys.isEmpty()) {
            for (String key : customMetadataKeys) {
                String mapKey = key.substring("x-amz-meta-".length());
                List values = (List)requestHeaders.get((Object)key);
                String value = StringUtils.join((Iterable)values, (String)",");
                sizeInBytes += (long)mapKey.getBytes(StandardCharsets.UTF_8).length;
                if ((sizeInBytes += (long)value.getBytes(StandardCharsets.UTF_8).length) > 2048L) {
                    throw S3ErrorTable.newError(S3ErrorTable.METADATA_TOO_LARGE, key);
                }
                customMetadata.put(mapKey, value);
            }
        }
        if (customMetadata.containsKey("ETag") || customMetadata.containsKey("ETag".toLowerCase())) {
            String customETag = customMetadata.get("ETag") != null ? (String)customMetadata.get("ETag") : (String)customMetadata.get("ETag".toLowerCase());
            customMetadata.remove("ETag");
            customMetadata.remove("ETag".toLowerCase());
            customMetadata.put(ETAG_CUSTOM, customETag);
        }
        return customMetadata;
    }

    protected void addCustomMetadataHeaders(Response.ResponseBuilder responseBuilder, OzoneKey key) {
        Map metadata = key.getMetadata();
        for (Map.Entry entry : metadata.entrySet()) {
            if (((String)entry.getKey()).equals("ETag")) continue;
            String metadataKey = (String)entry.getKey();
            if (metadataKey.equals(ETAG_CUSTOM)) {
                metadataKey = "ETag".toLowerCase();
            }
            responseBuilder.header("x-amz-meta-" + metadataKey, entry.getValue());
        }
    }

    protected Map<String, String> getTaggingFromHeaders(HttpHeaders httpHeaders) throws OS3Exception {
        String tagString = httpHeaders.getHeaderString("x-amz-tagging");
        if (StringUtils.isEmpty((CharSequence)tagString)) {
            return Collections.emptyMap();
        }
        List tagPairs = URLEncodedUtils.parse((String)tagString, (Charset)StandardCharsets.UTF_8);
        return EndpointBase.validateAndGetTagging(tagPairs, NameValuePair::getName, NameValuePair::getValue);
    }

    protected static <KV> Map<String, String> validateAndGetTagging(List<KV> tagList, Function<KV, String> getTagKey, Function<KV, String> getTagValue) throws OS3Exception {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (KV tagPair : tagList) {
            OS3Exception ex;
            String tagKey = getTagKey.apply(tagPair);
            String tagValue = getTagValue.apply(tagPair);
            if (StringUtils.isEmpty((CharSequence)tagKey)) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, "x-amz-tagging");
                ex.setErrorMessage("Some tag keys are empty, please only specify non-empty tag keys");
                throw ex;
            }
            if (StringUtils.startsWith((CharSequence)tagKey, (CharSequence)"aws:")) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagKey);
                ex.setErrorMessage("Tag key cannot start with \"aws:\" prefix");
                throw ex;
            }
            if (tagValue == null) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagKey);
                ex.setErrorMessage("Some tag values are not specified, please specify the tag values");
                throw ex;
            }
            if (tagKey.length() > 128) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagKey);
                ex.setErrorMessage("The tag key exceeds the maximum length of 128");
                throw ex;
            }
            if (tagValue.length() > 256) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagValue);
                ex.setErrorMessage("The tag value exceeds the maximum length of 256");
                throw ex;
            }
            if (!S3Consts.TAG_REGEX_PATTERN.matcher(tagKey).matches()) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagKey);
                ex.setErrorMessage("The tag key does not have a valid pattern");
                throw ex;
            }
            if (!S3Consts.TAG_REGEX_PATTERN.matcher(tagValue).matches()) {
                ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagValue);
                ex.setErrorMessage("The tag value does not have a valid pattern");
                throw ex;
            }
            String previous = tags.put(tagKey, tagValue);
            if (previous == null) continue;
            OS3Exception ex2 = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, tagKey);
            ex2.setErrorMessage("There are tags with duplicate tag keys, tag keys should be unique");
            throw ex2;
        }
        if (tags.size() > 10) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_TAG, "x-amz-tagging");
            ex.setErrorMessage("The number of tags " + tags.size() + " exceeded the maximum number of tags of " + 10);
            throw ex;
        }
        return Collections.unmodifiableMap(tags);
    }

    private AuditMessage.Builder auditMessageBaseBuilder(AuditAction op, Map<String, String> auditMap) {
        auditMap.put("x-amz-request-id", this.requestIdentifier.getRequestId());
        auditMap.put("x-amz-id-2", this.requestIdentifier.getAmzId());
        AuditMessage.Builder builder = new AuditMessage.Builder().forOperation(op).withParams(auditMap);
        if (this.s3Auth != null && this.s3Auth.getAccessID() != null && !this.s3Auth.getAccessID().isEmpty()) {
            builder.setUser(this.s3Auth.getAccessID());
        }
        if (this.context != null) {
            builder.atIp(AuditUtils.getClientIpAddress(this.context));
        }
        return builder;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        AuditMessage.Builder builder = this.auditMessageBaseBuilder(op, auditMap).withResult(AuditEventStatus.SUCCESS);
        return builder.build();
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap, AuditLogger.PerformanceStringBuilder performance) {
        AuditMessage.Builder builder = this.auditMessageBaseBuilder(op, auditMap).withResult(AuditEventStatus.SUCCESS);
        builder.setPerformance(performance);
        return builder.build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        AuditMessage.Builder builder = this.auditMessageBaseBuilder(op, auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable);
        return builder.build();
    }

    @VisibleForTesting
    public void setClient(OzoneClient ozoneClient) {
        this.client = ozoneClient;
    }

    @VisibleForTesting
    public void setRequestIdentifier(RequestIdentifier requestIdentifier) {
        this.requestIdentifier = requestIdentifier;
    }

    @VisibleForTesting
    public void setSignatureInfo(SignatureInfo signatureInfo) {
        this.signatureInfo = signatureInfo;
    }

    public OzoneClient getClient() {
        return this.client;
    }

    protected ClientProtocol getClientProtocol() {
        return this.getClient().getProxy();
    }

    @VisibleForTesting
    public S3GatewayMetrics getMetrics() {
        return S3GatewayMetrics.getMetrics();
    }

    protected Map<String, String> getAuditParameters() {
        return AuditUtils.getAuditParameters(this.context);
    }

    protected void auditWriteFailure(AuditAction action, Throwable ex) {
        AUDIT.logWriteFailure(this.buildAuditMessageForFailure(action, this.getAuditParameters(), ex));
    }

    protected void auditReadFailure(AuditAction action, Exception ex) {
        AUDIT.logReadFailure(this.buildAuditMessageForFailure(action, this.getAuditParameters(), ex));
    }

    protected boolean isAccessDenied(OMException ex) {
        OMException.ResultCodes result = ex.getResult();
        return result == OMException.ResultCodes.PERMISSION_DENIED || result == OMException.ResultCodes.INVALID_TOKEN;
    }
}

