/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.security.x509.certificate.client.CACertificateProvider;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;

public class ServiceInfoEx
implements CACertificateProvider {
    private final List<ServiceInfo> infoList;
    private final String caCertificate;
    private final List<String> caCertPemList;

    public ServiceInfoEx(List<ServiceInfo> infoList, String caCertificate, List<String> caCertPemList) {
        this.infoList = infoList;
        this.caCertificate = caCertificate;
        this.caCertPemList = caCertPemList;
    }

    public List<ServiceInfo> getServiceInfoList() {
        return this.infoList;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public List<String> getCaCertPemList() {
        return this.caCertPemList;
    }

    public List<X509Certificate> provideCACerts() throws IOException {
        String caCertPem = this.getCaCertificate();
        List<String> caCertPems = this.getCaCertPemList();
        if (caCertPems == null || caCertPems.isEmpty()) {
            if (caCertPem == null) {
                throw new IOException(new CertificateException("No caCerts found; caCertPem can not be null when caCertPems is empty or null"));
            }
            if (!caCertPem.isEmpty()) {
                caCertPems = Collections.singletonList(caCertPem);
            }
        }
        return OzoneSecurityUtil.convertToX509(caCertPems);
    }
}

