/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.BlockPositionState;
import io.trino.operator.aggregation.state.BlockPositionStateSerializer;
import io.trino.operator.aggregation.state.GenericBooleanState;
import io.trino.operator.aggregation.state.GenericBooleanStateSerializer;
import io.trino.operator.aggregation.state.GenericDoubleState;
import io.trino.operator.aggregation.state.GenericDoubleStateSerializer;
import io.trino.operator.aggregation.state.GenericLongState;
import io.trino.operator.aggregation.state.GenericLongStateSerializer;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class ArbitraryAggregationFunction
extends SqlAggregationFunction {
    public static final ArbitraryAggregationFunction ARBITRARY_AGGREGATION = new ArbitraryAggregationFunction();
    private static final String NAME = "arbitrary";
    private static final MethodHandle LONG_INPUT_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "input", Type.class, GenericLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "input", Type.class, GenericDoubleState.class, Block.class, Integer.TYPE);
    private static final MethodHandle BOOLEAN_INPUT_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "input", Type.class, GenericBooleanState.class, Block.class, Integer.TYPE);
    private static final MethodHandle BLOCK_POSITION_INPUT_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "input", Type.class, BlockPositionState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_OUTPUT_FUNCTION = Reflection.methodHandle(GenericLongState.class, "write", Type.class, GenericLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_OUTPUT_FUNCTION = Reflection.methodHandle(GenericDoubleState.class, "write", Type.class, GenericDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_OUTPUT_FUNCTION = Reflection.methodHandle(GenericBooleanState.class, "write", Type.class, GenericBooleanState.class, BlockBuilder.class);
    private static final MethodHandle BLOCK_POSITION_OUTPUT_FUNCTION = Reflection.methodHandle(BlockPositionState.class, "write", Type.class, BlockPositionState.class, BlockBuilder.class);
    private static final MethodHandle LONG_COMBINE_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "combine", GenericLongState.class, GenericLongState.class);
    private static final MethodHandle DOUBLE_COMBINE_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "combine", GenericDoubleState.class, GenericDoubleState.class);
    private static final MethodHandle BOOLEAN_COMBINE_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "combine", GenericBooleanState.class, GenericBooleanState.class);
    private static final MethodHandle BLOCK_POSITION_COMBINE_FUNCTION = Reflection.methodHandle(ArbitraryAggregationFunction.class, "combine", BlockPositionState.class, BlockPositionState.class);

    protected ArbitraryAggregationFunction() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Return an arbitrary non-null input value", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, new TypeSignature("T", new TypeSignatureParameter[0])));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        MethodHandle outputFunction;
        MethodHandle combineFunction;
        MethodHandle inputFunction;
        AggregationMetadata.AccumulatorStateDescriptor<Object> accumulatorStateDescriptor;
        Type type = boundSignature.getReturnType();
        if (type.getJavaType() == Long.TYPE) {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<GenericLongState>(GenericLongState.class, new GenericLongStateSerializer(type), StateCompiler.generateStateFactory(GenericLongState.class));
            inputFunction = LONG_INPUT_FUNCTION;
            combineFunction = LONG_COMBINE_FUNCTION;
            outputFunction = LONG_OUTPUT_FUNCTION;
        } else if (type.getJavaType() == Double.TYPE) {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<GenericDoubleState>(GenericDoubleState.class, new GenericDoubleStateSerializer(type), StateCompiler.generateStateFactory(GenericDoubleState.class));
            inputFunction = DOUBLE_INPUT_FUNCTION;
            combineFunction = DOUBLE_COMBINE_FUNCTION;
            outputFunction = DOUBLE_OUTPUT_FUNCTION;
        } else if (type.getJavaType() == Boolean.TYPE) {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<GenericBooleanState>(GenericBooleanState.class, new GenericBooleanStateSerializer(type), StateCompiler.generateStateFactory(GenericBooleanState.class));
            inputFunction = BOOLEAN_INPUT_FUNCTION;
            combineFunction = BOOLEAN_COMBINE_FUNCTION;
            outputFunction = BOOLEAN_OUTPUT_FUNCTION;
        } else {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<BlockPositionState>(BlockPositionState.class, new BlockPositionStateSerializer(type), StateCompiler.generateStateFactory(BlockPositionState.class));
            inputFunction = BLOCK_POSITION_INPUT_FUNCTION;
            combineFunction = BLOCK_POSITION_COMBINE_FUNCTION;
            outputFunction = BLOCK_POSITION_OUTPUT_FUNCTION;
        }
        inputFunction = inputFunction.bindTo(type);
        return new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(combineFunction), outputFunction.bindTo(type), (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(accumulatorStateDescriptor));
    }

    public static void input(Type type, GenericDoubleState state, Block block, int position) {
        if (!state.isNull()) {
            return;
        }
        state.setNull(false);
        state.setValue(type.getDouble(block, position));
    }

    public static void input(Type type, GenericLongState state, Block block, int position) {
        if (!state.isNull()) {
            return;
        }
        state.setNull(false);
        state.setValue(type.getLong(block, position));
    }

    public static void input(Type type, GenericBooleanState state, Block block, int position) {
        if (!state.isNull()) {
            return;
        }
        state.setNull(false);
        state.setValue(type.getBoolean(block, position));
    }

    public static void input(Type type, BlockPositionState state, Block block, int position) {
        if (state.getBlock() != null) {
            return;
        }
        state.setBlock(block);
        state.setPosition(position);
    }

    public static void combine(GenericLongState state, GenericLongState otherState) {
        if (!state.isNull()) {
            return;
        }
        state.set(otherState);
    }

    public static void combine(GenericDoubleState state, GenericDoubleState otherState) {
        if (!state.isNull()) {
            return;
        }
        state.set(otherState);
    }

    public static void combine(GenericBooleanState state, GenericBooleanState otherState) {
        if (!state.isNull()) {
            return;
        }
        state.set(otherState);
    }

    public static void combine(BlockPositionState state, BlockPositionState otherState) {
        if (state.getBlock() != null) {
            return;
        }
        state.set(otherState);
    }
}

