/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlOperator;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;

public class ArraySubscriptOperator
extends SqlOperator {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArraySubscriptOperator.class, "booleanSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArraySubscriptOperator.class, "longSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArraySubscriptOperator.class, "doubleSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArraySubscriptOperator.class, "sliceSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArraySubscriptOperator.class, "objectSubscript", Type.class, Block.class, Long.TYPE);

    protected ArraySubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("E", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (Object)BigintType.BIGINT.getTypeSignature()), true);
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        Type elementType = boundSignature.getReturnType();
        MethodHandle methodHandle = elementType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (elementType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (elementType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (elementType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT.asType(METHOD_HANDLE_OBJECT.type().changeReturnType(elementType.getJavaType())))));
        methodHandle = methodHandle.bindTo(elementType);
        Objects.requireNonNull(methodHandle, "methodHandle is null");
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Long longSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    @UsedByGeneratedCode
    public static Boolean booleanSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    @UsedByGeneratedCode
    public static Double doubleSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    @UsedByGeneratedCode
    public static Slice sliceSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    @UsedByGeneratedCode
    public static Object objectSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getObject(array, position);
    }

    public static void checkArrayIndex(long index) {
        if (index == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (index < 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative: " + index);
        }
    }

    public static void checkIndex(Block array, long index) {
        ArraySubscriptOperator.checkArrayIndex(index);
        if (index > (long)array.getPositionCount()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Array subscript must be less than or equal to array length: %s > %s", index, array.getPositionCount()));
        }
    }
}

