/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;

public class PushOffsetThroughProject
implements Rule<OffsetNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset().with(Patterns.source().matching(Patterns.project().matching(projectNode -> !projectNode.isIdentity()).capturedAs(CHILD)));

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(Util.transpose(parent, (PlanNode)captures.get(CHILD)));
    }
}

