/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SetProperties
extends Statement {
    private final Type type;
    private final QualifiedName name;
    private final List<Property> properties;

    public SetProperties(Type type, QualifiedName name, List<Property> properties) {
        this(Optional.empty(), type, name, properties);
    }

    public SetProperties(NodeLocation location, Type type, QualifiedName name, List<Property> properties) {
        this(Optional.of(location), type, name, properties);
    }

    private SetProperties(Optional<NodeLocation> location, Type type, QualifiedName name, List<Property> properties) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
    }

    public Type getType() {
        return this.type;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetProperties(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.properties});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetProperties o = (SetProperties)obj;
        return this.type == o.type && Objects.equals(this.name, o.name) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).add("properties", this.properties).toString();
    }

    public static enum Type {
        TABLE;

    }
}

