/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.EntryLogScanner;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.bookkeeper.bookie.storage.ldb.LedgerMetadataIndex;
import org.apache.bookkeeper.bookie.storage.ldb.LongPairWrapper;
import org.apache.bookkeeper.bookie.storage.ldb.LongWrapper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsIndexRebuildOp {
    private final ServerConfiguration conf;
    private static final int BATCH_COMMIT_SIZE = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(LocationsIndexRebuildOp.class);

    public LocationsIndexRebuildOp(ServerConfiguration conf) {
        this.conf = conf;
    }

    public void initiate() throws IOException {
        LOG.info("Starting locations index rebuilding");
        File[] indexDirs = this.conf.getIndexDirs();
        if (indexDirs == null) {
            indexDirs = this.conf.getLedgerDirs();
        }
        if (indexDirs.length != this.conf.getLedgerDirs().length) {
            throw new IOException("ledger and index dirs size not matched");
        }
        long startTime = System.nanoTime();
        for (int i = 0; i < this.conf.getLedgerDirs().length; ++i) {
            File ledgerDir = this.conf.getLedgerDirs()[i];
            File indexDir = indexDirs[i];
            String iBasePath = BookieImpl.getCurrentDirectory(indexDir).toString();
            Path indexCurrentPath = FileSystems.getDefault().getPath(iBasePath, "locations");
            String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
            Path backupPath = FileSystems.getDefault().getPath(iBasePath, "locations.BACKUP-" + timestamp);
            Files.move(indexCurrentPath, backupPath, new CopyOption[0]);
            LOG.info("Created locations index backup at {}", (Object)backupPath);
            File[] lDirs = new File[]{ledgerDir};
            DefaultEntryLogger entryLogger = new DefaultEntryLogger(this.conf, new LedgerDirsManager(this.conf, lDirs, new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold())));
            Set<Long> entryLogs = entryLogger.getEntryLogsSet();
            final Set<Long> activeLedgers = this.getActiveLedgers(this.conf, KeyValueStorageRocksDB.factory, iBasePath);
            LOG.info("Found {} active ledgers in ledger manager", (Object)activeLedgers.size());
            final KeyValueStorage newIndex = KeyValueStorageRocksDB.factory.newKeyValueStorage(iBasePath, "locations", KeyValueStorageFactory.DbConfigType.Default, this.conf);
            int totalEntryLogs = entryLogs.size();
            int completedEntryLogs = 0;
            LOG.info("Scanning {} entry logs", (Object)totalEntryLogs);
            final AtomicReference<KeyValueStorage.Batch> batch = new AtomicReference<KeyValueStorage.Batch>(newIndex.newBatch());
            final AtomicInteger count = new AtomicInteger();
            for (final long entryLogId : entryLogs) {
                entryLogger.scanEntryLog(entryLogId, new EntryLogScanner(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process(long ledgerId, long offset, ByteBuf entry) throws IOException {
                        long entryId = entry.getLong(8);
                        long location = entryLogId << 32 | offset + 4L;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Rebuilding {}:{} at location {} / {}", new Object[]{ledgerId, entryId, location >> 32, location & 0x7FFFFFFEL});
                        }
                        LongPairWrapper key = LongPairWrapper.get(ledgerId, entryId);
                        LongWrapper value = LongWrapper.get(location);
                        try {
                            ((KeyValueStorage.Batch)batch.get()).put(key.array, value.array);
                        }
                        finally {
                            key.recycle();
                            value.recycle();
                        }
                        if (count.incrementAndGet() > 10000) {
                            ((KeyValueStorage.Batch)batch.get()).flush();
                            ((KeyValueStorage.Batch)batch.get()).close();
                            batch.set(newIndex.newBatch());
                            count.set(0);
                        }
                    }

                    @Override
                    public boolean accept(long ledgerId) {
                        return activeLedgers.contains(ledgerId);
                    }
                });
                LOG.info("Completed scanning of log {}.log -- {} / {}", new Object[]{Long.toHexString(entryLogId), ++completedEntryLogs, totalEntryLogs});
            }
            batch.get().flush();
            batch.get().close();
            newIndex.sync();
            newIndex.close();
        }
        LOG.info("Rebuilding index is done. Total time: {}", (Object)DurationFormatUtils.formatDurationHMS((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)));
    }

    private Set<Long> getActiveLedgers(ServerConfiguration conf, KeyValueStorageFactory storageFactory, String basePath) throws IOException {
        LedgerMetadataIndex ledgers = new LedgerMetadataIndex(conf, storageFactory, basePath, (StatsLogger)NullStatsLogger.INSTANCE);
        HashSet activeLedgers = Sets.newHashSet();
        for (Long ledger : ledgers.getActiveLedgersInRange(0L, Long.MAX_VALUE)) {
            activeLedgers.add(ledger);
        }
        ledgers.close();
        return activeLedgers;
    }
}

