/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.cache.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.common.stats.CacheMetricsCollector;
import org.apache.pulsar.common.util.Backoff;
import org.apache.pulsar.metadata.api.CacheGetResult;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataCacheConfig;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.cache.impl.JSONMetadataSerdeSimpleType;
import org.apache.pulsar.metadata.cache.impl.JSONMetadataSerdeTypeRef;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCacheImpl<T>
implements MetadataCache<T>,
Consumer<Notification> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataCacheImpl.class);
    private final MetadataStore store;
    private final MetadataStoreExtended storeExtended;
    private final MetadataSerde<T> serde;
    private final OrderedExecutor executor;
    private final ScheduledExecutorService schedulerExecutor;
    private final MetadataCacheConfig<T> cacheConfig;
    private final AsyncLoadingCache<String, Optional<CacheGetResult<T>>> objCache;

    public MetadataCacheImpl(String cacheName, MetadataStore store, TypeReference<T> typeRef, MetadataCacheConfig<T> cacheConfig, OrderedExecutor executor, ScheduledExecutorService schedulerExecutor) {
        this(cacheName, store, new JSONMetadataSerdeTypeRef<T>(typeRef), cacheConfig, executor, schedulerExecutor);
    }

    public MetadataCacheImpl(String cacheName, MetadataStore store, JavaType type, MetadataCacheConfig<T> cacheConfig, OrderedExecutor executor, ScheduledExecutorService schedulerExecutor) {
        this(cacheName, store, new JSONMetadataSerdeSimpleType(type), cacheConfig, executor, schedulerExecutor);
    }

    public MetadataCacheImpl(final String cacheName, final MetadataStore store, MetadataSerde<T> serde, final MetadataCacheConfig<T> cacheConfig, OrderedExecutor executor, ScheduledExecutorService schedulerExecutor) {
        this.store = store;
        this.storeExtended = store instanceof MetadataStoreExtended ? (MetadataStoreExtended)store : null;
        this.serde = serde;
        this.cacheConfig = cacheConfig;
        this.executor = executor;
        this.schedulerExecutor = schedulerExecutor;
        Caffeine cacheBuilder = Caffeine.newBuilder();
        if (cacheConfig.getRefreshAfterWriteMillis() > 0L) {
            cacheBuilder.refreshAfterWrite(cacheConfig.getRefreshAfterWriteMillis(), TimeUnit.MILLISECONDS);
        }
        if (cacheConfig.getExpireAfterWriteMillis() > 0L) {
            cacheBuilder.expireAfterWrite(cacheConfig.getExpireAfterWriteMillis(), TimeUnit.MILLISECONDS);
        }
        this.objCache = cacheBuilder.recordStats().buildAsync(new AsyncCacheLoader<String, Optional<CacheGetResult<T>>>(){

            public CompletableFuture<Optional<CacheGetResult<T>>> asyncLoad(String key, Executor executor) {
                if (log.isDebugEnabled()) {
                    log.debug("Loading key {} into metadata cache {}", (Object)key, (Object)cacheName);
                }
                return MetadataCacheImpl.this.readValueFromStore(key);
            }

            public CompletableFuture<Optional<CacheGetResult<T>>> asyncReload(String key, Optional<CacheGetResult<T>> oldValue, Executor executor) {
                if (store instanceof AbstractMetadataStore && ((AbstractMetadataStore)store).isConnected()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Reloading key {} into metadata cache {}", (Object)key, (Object)cacheName);
                    }
                    CompletableFuture future = MetadataCacheImpl.this.readValueFromStore(key);
                    future.thenAccept(val -> {
                        if (cacheConfig.getAsyncReloadConsumer() != null) {
                            cacheConfig.getAsyncReloadConsumer().accept(key, (Optional<CacheGetResult<String>>)val);
                        }
                    });
                    return future;
                }
                return CompletableFuture.completedFuture(oldValue);
            }
        });
        CacheMetricsCollector.CAFFEINE.addCache(cacheName, this.objCache);
    }

    private CompletableFuture<Optional<CacheGetResult<T>>> readValueFromStore(String path) {
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)this.store.get(path).thenComposeAsync(optRes -> {
            if (!optRes.isPresent()) {
                if (log.isDebugEnabled()) {
                    log.debug("Key {} not found in metadata store", (Object)path);
                }
                return FutureUtils.value(Optional.empty());
            }
            GetResult res = (GetResult)optRes.get();
            try {
                T obj = this.serde.deserialize(path, res.getValue(), res.getStat());
                if (log.isDebugEnabled()) {
                    log.debug("Deserialized value for key {} (version: {}): {}", new Object[]{path, res.getStat().getVersion(), obj});
                }
                return FutureUtils.value(Optional.of(new CacheGetResult<T>(obj, res.getStat())));
            }
            catch (Throwable t) {
                return FutureUtils.exception((Throwable)new MetadataStoreException.ContentDeserializationException("Failed to deserialize payload for key '" + path + "'", t));
            }
        }, (Executor)this.executor.chooseThread((Object)path))).whenComplete((result, e) -> {
            if (e != null) {
                future.completeExceptionally(e.getCause());
            } else {
                future.complete((Optional)result);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<T>> get(String path) {
        return this.objCache.get((Object)path).thenApply(optRes -> optRes.map(CacheGetResult::getValue));
    }

    @Override
    public CompletableFuture<Optional<CacheGetResult<T>>> getWithStats(String path) {
        return this.objCache.get((Object)path);
    }

    @Override
    public Optional<T> getIfCached(String path) {
        CompletableFuture future = this.objCache.getIfPresent((Object)path);
        if (future != null && future.isDone() && !future.isCompletedExceptionally()) {
            return ((Optional)future.join()).map(CacheGetResult::getValue);
        }
        return Optional.empty();
    }

    @Override
    public CompletableFuture<T> readModifyUpdateOrCreate(String path, Function<Optional<T>, T> modifyFunction) {
        ExecutorService executor = this.executor.chooseThread((Object)path);
        return this.executeWithRetry(() -> this.objCache.get((Object)path).thenComposeAsync(optEntry -> {
            byte[] newValue;
            Object newValueObj;
            long expectedVersion;
            Optional currentValue;
            if (optEntry.isPresent()) {
                T clone;
                CacheGetResult entry = (CacheGetResult)optEntry.get();
                try {
                    clone = this.serde.deserialize(path, this.serde.serialize(path, entry.getValue()), entry.getStat());
                }
                catch (IOException e) {
                    return FutureUtils.exception((Throwable)e);
                }
                currentValue = Optional.of(clone);
                expectedVersion = entry.getStat().getVersion();
            } else {
                currentValue = Optional.empty();
                expectedVersion = -1L;
            }
            try {
                newValueObj = modifyFunction.apply(currentValue);
                newValue = this.serde.serialize(path, newValueObj);
            }
            catch (Throwable t) {
                return FutureUtils.exception((Throwable)t);
            }
            return ((CompletableFuture)this.store.put(path, newValue, Optional.of(expectedVersion)).thenAccept(__ -> this.refresh(path))).thenApply(__ -> newValueObj);
        }, (Executor)executor), path);
    }

    @Override
    public CompletableFuture<T> readModifyUpdate(String path, Function<T, T> modifyFunction) {
        ExecutorService executor = this.executor.chooseThread((Object)path);
        return this.executeWithRetry(() -> this.objCache.get((Object)path).thenComposeAsync(optEntry -> {
            byte[] newValue;
            Object newValueObj;
            if (!optEntry.isPresent()) {
                return FutureUtils.exception((Throwable)new MetadataStoreException.NotFoundException(""));
            }
            CacheGetResult entry = (CacheGetResult)optEntry.get();
            Object currentValue = entry.getValue();
            long expectedVersion = entry.getStat().getVersion();
            try {
                currentValue = this.serde.deserialize(path, this.serde.serialize(path, currentValue), entry.getStat());
                newValueObj = modifyFunction.apply(currentValue);
                newValue = this.serde.serialize(path, newValueObj);
            }
            catch (Throwable t) {
                return FutureUtils.exception((Throwable)t);
            }
            return ((CompletableFuture)this.store.put(path, newValue, Optional.of(expectedVersion)).thenAccept(__ -> this.refresh(path))).thenApply(__ -> newValueObj);
        }, (Executor)executor), path);
    }

    private CompletableFuture<byte[]> serialize(String path, T value) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.executor.executeOrdered((Object)path, () -> {
            try {
                future.complete(this.serde.serialize(path, value));
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> create(String path, T value) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)((CompletableFuture)this.serialize(path, value).thenCompose(content -> this.store.put(path, (byte[])content, Optional.of(-1L)))).thenCompose(__ -> this.objCache.get((Object)path))).whenComplete((__, ex) -> {
            if (ex == null) {
                future.complete(null);
            } else if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                future.completeExceptionally(new MetadataStoreException.AlreadyExistsException(ex.getCause()));
            } else {
                future.completeExceptionally(ex.getCause());
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> put(String path, T value, EnumSet<CreateOption> options) {
        return ((CompletableFuture)this.serialize(path, value).thenCompose(bytes -> {
            if (this.storeExtended != null) {
                return this.storeExtended.put(path, (byte[])bytes, Optional.empty(), options);
            }
            return this.store.put(path, (byte[])bytes, Optional.empty());
        })).thenAccept(__ -> {
            if (log.isDebugEnabled()) {
                log.debug("Refreshing path {} after put operation", (Object)path);
            }
            this.refresh(path);
        });
    }

    @Override
    public CompletableFuture<Void> delete(String path) {
        return this.store.delete(path, Optional.empty());
    }

    @Override
    public CompletableFuture<Boolean> exists(String path) {
        return this.store.exists(path);
    }

    @Override
    public CompletableFuture<List<String>> getChildren(String path) {
        return this.store.getChildren(path);
    }

    @Override
    public void invalidate(String path) {
        this.objCache.synchronous().invalidate((Object)path);
    }

    @Override
    public void refresh(String path) {
        this.objCache.asMap().computeIfPresent(path, (oldKey, oldValue) -> this.readValueFromStore(path));
    }

    @Override
    @VisibleForTesting
    public void invalidateAll() {
        this.objCache.synchronous().invalidateAll();
    }

    @Override
    public void accept(Notification t) {
        String path = t.getPath();
        switch (t.getType()) {
            case Created: 
            case Modified: {
                if (log.isDebugEnabled()) {
                    log.debug("Refreshing path {} for {} notification", (Object)path, (Object)t.getType());
                }
                this.refresh(path);
                break;
            }
            case Deleted: {
                this.objCache.synchronous().invalidate((Object)path);
                break;
            }
        }
    }

    private void execute(Supplier<CompletableFuture<T>> op, String key, CompletableFuture<T> result, Backoff backoff) {
        ((CompletableFuture)op.get().thenAccept(result::complete)).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                this.objCache.synchronous().invalidate((Object)key);
                long elapsed = System.currentTimeMillis() - backoff.getFirstBackoffTimeInMillis();
                if (backoff.isMandatoryStopMade()) {
                    if (backoff.getFirstBackoffTimeInMillis() == 0L) {
                        result.completeExceptionally(ex.getCause());
                    } else {
                        result.completeExceptionally(new TimeoutException(String.format("Timeout to update key %s. Elapsed time: %d ms", key, elapsed)));
                    }
                    return null;
                }
                long next = backoff.next();
                log.info("Update key {} conflicts. Retrying in {} ms. Mandatory stop: {}. Elapsed time: {} ms", new Object[]{key, next, backoff.isMandatoryStopMade(), elapsed});
                this.schedulerExecutor.schedule(() -> this.lambda$execute$18((Supplier)op, key, result, backoff), next, TimeUnit.MILLISECONDS);
                return null;
            }
            result.completeExceptionally(ex.getCause());
            return null;
        });
    }

    private CompletableFuture<T> executeWithRetry(Supplier<CompletableFuture<T>> op, String key) {
        Backoff backoff = this.cacheConfig.getRetryBackoff().create();
        CompletableFuture result = new CompletableFuture();
        this.execute(op, key, result, backoff);
        return result;
    }

    @Generated
    public MetadataStore getStore() {
        return this.store;
    }

    private /* synthetic */ void lambda$execute$18(Supplier op, String key, CompletableFuture result, Backoff backoff) {
        this.execute(op, key, result, backoff);
    }
}

