/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing;

import java.util.List;
import org.apache.pulsar.functions.windowing.Window;

public class WindowImpl<T>
implements Window<T> {
    private final List<T> tuples;
    private final List<T> newTuples;
    private final List<T> expiredTuples;
    private final Long startTimestamp;
    private final Long endTimestamp;

    public WindowImpl(List<T> tuples, List<T> newTuples, List<T> expiredTuples, Long startTimestamp, Long endTimestamp) {
        this.tuples = tuples;
        this.newTuples = newTuples;
        this.expiredTuples = expiredTuples;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    @Override
    public List<T> get() {
        return this.tuples;
    }

    @Override
    public List<T> getNew() {
        return this.newTuples;
    }

    @Override
    public List<T> getExpired() {
        return this.expiredTuples;
    }

    @Override
    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public String toString() {
        return "TupleWindowImpl{tuples=" + String.valueOf(this.tuples) + ", newTuples=" + String.valueOf(this.newTuples) + ", expiredTuples=" + String.valueOf(this.expiredTuples) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowImpl that = (WindowImpl)o;
        if (this.tuples != null ? !this.tuples.equals(that.tuples) : that.tuples != null) {
            return false;
        }
        if (this.newTuples != null ? !this.newTuples.equals(that.newTuples) : that.newTuples != null) {
            return false;
        }
        return this.expiredTuples != null ? this.expiredTuples.equals(that.expiredTuples) : that.expiredTuples == null;
    }

    public int hashCode() {
        int result = this.tuples != null ? this.tuples.hashCode() : 0;
        result = 31 * result + (this.newTuples != null ? this.newTuples.hashCode() : 0);
        result = 31 * result + (this.expiredTuples != null ? this.expiredTuples.hashCode() : 0);
        return result;
    }
}

