/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.bk;

import com.google.common.base.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumConfig {
    private static final Logger logger = LoggerFactory.getLogger(QuorumConfig.class);
    private final int ensembleSize;
    private final int writeQuorumSize;
    private final int ackQuorumSize;

    public QuorumConfig(int ensembleSize, int writeQuorumSize, int ackQuorumSize) {
        this.ensembleSize = ensembleSize;
        if (this.ensembleSize < writeQuorumSize) {
            this.writeQuorumSize = this.ensembleSize;
            logger.warn("Setting write quorum size {} greater than ensemble size {}", (Object)writeQuorumSize, (Object)this.ensembleSize);
        } else {
            this.writeQuorumSize = writeQuorumSize;
        }
        if (this.writeQuorumSize < ackQuorumSize) {
            this.ackQuorumSize = this.writeQuorumSize;
            logger.warn("Setting write ack quorum size {} greater than write quorum size {}", (Object)ackQuorumSize, (Object)this.writeQuorumSize);
        } else {
            this.ackQuorumSize = ackQuorumSize;
        }
    }

    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ensembleSize, this.writeQuorumSize, this.ackQuorumSize});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QuorumConfig)) {
            return false;
        }
        QuorumConfig other = (QuorumConfig)obj;
        return this.ensembleSize == other.ensembleSize && this.writeQuorumSize == other.writeQuorumSize && this.ackQuorumSize == other.ackQuorumSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuorumConfig[ensemble=").append(this.ensembleSize).append(", write quorum=").append(this.writeQuorumSize).append(", ack quorum=").append(this.ackQuorumSize).append("]");
        return sb.toString();
    }
}

