/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import java.util.Objects;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ImmutablePositionImpl;

public final class PositionFactory {
    public static final Position EARLIEST = PositionFactory.create(-1L, -1L);
    public static final Position LATEST = PositionFactory.create(Long.MAX_VALUE, Long.MAX_VALUE);

    private PositionFactory() {
    }

    public static Position create(long ledgerId, long entryId) {
        return new ImmutablePositionImpl(ledgerId, entryId);
    }

    public static Position create(Position other) {
        Objects.requireNonNull(other, "Position cannot be null");
        if (other instanceof ImmutablePositionImpl) {
            return other;
        }
        return new ImmutablePositionImpl(other);
    }
}

