/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Binary {
    private final byte[] _data;
    private final int _hashCode;

    public Binary(byte[] data) {
        this._data = data;
        int hc = 0;
        for (int i = 0; i < this._data.length; ++i) {
            hc = 31 * hc + (0xFF & data[i]);
        }
        this._hashCode = hc;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this._data);
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object o) {
        if (o instanceof Binary) {
            Binary buf = (Binary)o;
            return Arrays.equals(this._data, buf._data);
        }
        return false;
    }

    public byte[] getArray() {
        return this._data;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this._data.length; ++i) {
            byte c = this._data[i];
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        return str.toString();
    }
}

