/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.transport.Method;

public class MessageAcceptCompletionListener
implements Method.CompletionListener {
    private final ConsumerTarget_0_10 _sub;
    private final MessageInstance _entry;
    private final ServerSession _session;
    private final MessageInstanceConsumer _consumer;
    private final boolean _restoreCredit;
    private long _messageSize;

    public MessageAcceptCompletionListener(ConsumerTarget_0_10 sub, MessageInstanceConsumer consumer, ServerSession session, MessageInstance entry, boolean restoreCredit) {
        this._sub = sub;
        this._entry = entry;
        this._session = session;
        this._restoreCredit = restoreCredit;
        this._consumer = consumer;
        if (restoreCredit) {
            this._messageSize = entry.getMessage().getSize();
        }
    }

    @Override
    public void onComplete(Method method) {
        if (this._restoreCredit) {
            this._sub.restoreCredit(1, this._messageSize);
        }
        this._session.acknowledge(this._consumer, this._sub, this._entry);
        this._session.removeDispositionListener(method);
    }
}

