/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EpollSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EpollSupport.class);
    public static final String NAME = "EPOLL";

    public static boolean isAvailable(TransportOptions transportOptions) {
        return transportOptions.allowNativeIO() && EpollSupport.isAvailable();
    }

    public static boolean isAvailable() {
        try {
            return Epoll.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for Epoll support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        EpollSupport.ensureAvailability();
        return new EpollEventLoopGroup(nThreads, ioThreadFactory);
    }

    public static Class<? extends Channel> getChannelClass() {
        EpollSupport.ensureAvailability();
        return EpollSocketChannel.class;
    }

    public static void ensureAvailability() {
        if (!EpollSupport.isAvailable()) {
            throw new UnsupportedOperationException("Netty Epoll support is not enabled because the Netty library indicates it is not present or disabled");
        }
    }
}

