/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.QueryMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class MQAdminImpl {
    private static final Logger log = LoggerFactory.getLogger(MQAdminImpl.class);
    private final MQClientInstance mQClientFactory;
    private long timeoutMillis = 6000L;

    public MQAdminImpl(MQClientInstance mQClientFactory) {
        this.mQClientFactory = mQClientFactory;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0, null);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag, Map<String, String> attributes) throws MQClientException {
        block8: {
            try {
                Validators.checkTopic(newTopic);
                Validators.isSystemTopic(newTopic);
                TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(key, this.timeoutMillis);
                List brokerDataList = topicRouteData.getBrokerDatas();
                if (brokerDataList != null && !brokerDataList.isEmpty()) {
                    Collections.sort(brokerDataList);
                    boolean createOKAtLeastOnce = false;
                    MQClientException exception = null;
                    StringBuilder orderTopicString = new StringBuilder();
                    for (BrokerData brokerData : brokerDataList) {
                        String addr = (String)brokerData.getBrokerAddrs().get(0L);
                        if (addr == null) continue;
                        TopicConfig topicConfig = new TopicConfig(newTopic);
                        topicConfig.setReadQueueNums(queueNum);
                        topicConfig.setWriteQueueNums(queueNum);
                        topicConfig.setTopicSysFlag(topicSysFlag);
                        topicConfig.setAttributes(attributes);
                        boolean createOK = false;
                        for (int i = 0; i < 5; ++i) {
                            try {
                                this.mQClientFactory.getMQClientAPIImpl().createTopic(addr, key, topicConfig, this.timeoutMillis);
                                createOK = true;
                                createOKAtLeastOnce = true;
                                break;
                            }
                            catch (Exception e) {
                                if (4 != i) continue;
                                exception = new MQClientException("create topic to broker exception", e);
                                continue;
                            }
                        }
                        if (!createOK) continue;
                        orderTopicString.append(brokerData.getBrokerName());
                        orderTopicString.append(":");
                        orderTopicString.append(queueNum);
                        orderTopicString.append(";");
                    }
                    if (exception != null && !createOKAtLeastOnce) {
                        throw exception;
                    }
                    break block8;
                }
                throw new MQClientException("Not found broker, maybe key is wrong", null);
            }
            catch (Exception e) {
                throw new MQClientException("create new topic failed", e);
            }
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        try {
            TopicPublishInfo topicPublishInfo;
            TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, this.timeoutMillis);
            if (topicRouteData != null && (topicPublishInfo = MQClientInstance.topicRouteData2TopicPublishInfo(topic, topicRouteData)) != null && topicPublishInfo.ok()) {
                return this.parsePublishMessageQueues(topicPublishInfo.getMessageQueueList());
            }
        }
        catch (Exception e) {
            throw new MQClientException("Can not find Message Queue for this topic, " + topic, e);
        }
        throw new MQClientException("Unknow why, Can not find Message Queue for this topic, " + topic, null);
    }

    public List<MessageQueue> parsePublishMessageQueues(List<MessageQueue> messageQueueList) {
        ArrayList<MessageQueue> resultQueues = new ArrayList<MessageQueue>();
        for (MessageQueue queue : messageQueueList) {
            String userTopic = NamespaceUtil.withoutNamespace((String)queue.getTopic(), (String)this.mQClientFactory.getClientConfig().getNamespace());
            resultQueues.add(new MessageQueue(userTopic, queue.getBrokerName(), queue.getQueueId()));
        }
        return resultQueues;
    }

    public Set<MessageQueue> fetchSubscribeMessageQueues(String topic) throws MQClientException {
        try {
            TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, this.timeoutMillis);
            if (topicRouteData != null) {
                Set<MessageQueue> mqList = MQClientInstance.topicRouteData2TopicSubscribeInfo(topic, topicRouteData);
                if (!mqList.isEmpty()) {
                    return mqList;
                }
                throw new MQClientException("Can not find Message Queue for this topic, " + topic + " Namesrv return empty", null);
            }
        }
        catch (Exception e) {
            throw new MQClientException("Can not find Message Queue for this topic, " + topic + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), e);
        }
        throw new MQClientException("Unknown why, Can not find Message Queue for this topic, " + topic, null);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.searchOffset(mq, timestamp, BoundaryType.LOWER);
    }

    public long searchOffset(MessageQueue mq, long timestamp, BoundaryType boundaryType) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().searchOffset(brokerAddr, mq, timestamp, boundaryType, this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getMaxOffset(brokerAddr, mq, this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getMinOffset(brokerAddr, mq, this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(this.mQClientFactory.getBrokerNameFromMessageQueue(mq));
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getEarliestMsgStoretime(brokerAddr, mq, this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public MessageExt viewMessage(String topic, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        MessageId messageId;
        try {
            messageId = MessageDecoder.decodeMessageId((String)msgId);
        }
        catch (Exception e) {
            throw new MQClientException(208, "query message by id finished, but no message.");
        }
        return this.mQClientFactory.getMQClientAPIImpl().viewMessage(NetworkUtil.socketAddress2String((SocketAddress)messageId.getAddress()), topic, messageId.getOffset(), this.timeoutMillis);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.queryMessage(null, topic, key, maxNum, begin, end, false);
    }

    public QueryResult queryMessageByUniqKey(String topic, String uniqKey, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.queryMessage(null, topic, uniqKey, maxNum, begin, end, true);
    }

    public QueryResult queryMessageByUniqKey(String clusterName, String topic, String uniqKey, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.queryMessage(clusterName, topic, uniqKey, maxNum, begin, end, true);
    }

    public MessageExt queryMessageByUniqKey(String topic, String uniqKey) throws InterruptedException, MQClientException {
        return this.queryMessageByUniqKey(topic, uniqKey, System.currentTimeMillis() - 259200000L, Long.MAX_VALUE);
    }

    public MessageExt queryMessageByUniqKey(String clusterName, String topic, String uniqKey) throws InterruptedException, MQClientException {
        return this.queryMessageByUniqKey(clusterName, topic, uniqKey, System.currentTimeMillis() - 259200000L, Long.MAX_VALUE);
    }

    public MessageExt queryMessageByUniqKey(String topic, String uniqKey, long begin, long end) throws InterruptedException, MQClientException {
        return this.queryMessageByUniqKey(null, topic, uniqKey, begin, end);
    }

    public MessageExt queryMessageByUniqKey(String clusterName, String topic, String uniqKey, long begin, long end) throws InterruptedException, MQClientException {
        QueryResult qr = this.queryMessage(clusterName, topic, uniqKey, 32, begin, end, true);
        if (qr != null && qr.getMessageList() != null && qr.getMessageList().size() > 0) {
            return qr.getMessageList().get(0);
        }
        return null;
    }

    public QueryResult queryMessage(String clusterName, String topic, String key, int maxNum, long begin, long end, boolean isUniqKey) throws MQClientException, InterruptedException {
        TopicRouteData topicRouteData;
        boolean isLmq = MixAll.isLmq((String)topic);
        String routeTopic = topic;
        if (!StringUtils.isEmpty((CharSequence)topic) && (isLmq || topic.equals("rmq_sys_wheel_timer")) && !StringUtils.isEmpty((CharSequence)clusterName)) {
            routeTopic = clusterName;
        }
        if (null == (topicRouteData = this.mQClientFactory.getAnExistTopicRouteData(routeTopic))) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(routeTopic);
            topicRouteData = this.mQClientFactory.getAnExistTopicRouteData(routeTopic);
        }
        if (topicRouteData != null) {
            LinkedList<String> brokerAddrs = new LinkedList<String>();
            for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                String addr;
                if (!isLmq && clusterName != null && !clusterName.isEmpty() && !clusterName.equals(brokerData.getCluster()) || (addr = brokerData.selectBrokerAddr()) == null) continue;
                brokerAddrs.add(addr);
            }
            if (!brokerAddrs.isEmpty()) {
                final CountDownLatch countDownLatch = new CountDownLatch(brokerAddrs.size());
                final LinkedList queryResultList = new LinkedList();
                final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
                for (String addr : brokerAddrs) {
                    try {
                        final QueryMessageRequestHeader requestHeader = new QueryMessageRequestHeader();
                        if (isLmq) {
                            requestHeader.setTopic(clusterName);
                        } else {
                            requestHeader.setTopic(topic);
                        }
                        requestHeader.setKey(key);
                        requestHeader.setMaxNum(Integer.valueOf(maxNum));
                        requestHeader.setBeginTimestamp(Long.valueOf(begin));
                        requestHeader.setEndTimestamp(Long.valueOf(end));
                        this.mQClientFactory.getMQClientAPIImpl().queryMessage(addr, requestHeader, this.timeoutMillis * 3L, new InvokeCallback(){

                            public void operationComplete(ResponseFuture responseFuture) {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationSucceed(RemotingCommand response) {
                                try {
                                    switch (response.getCode()) {
                                        case 0: {
                                            QueryMessageResponseHeader responseHeader = null;
                                            try {
                                                responseHeader = (QueryMessageResponseHeader)response.decodeCommandCustomHeader(QueryMessageResponseHeader.class);
                                            }
                                            catch (RemotingCommandException e) {
                                                log.error("decodeCommandCustomHeader exception", (Throwable)e);
                                                countDownLatch.countDown();
                                                return;
                                            }
                                            List wrappers = MessageDecoder.decodes((ByteBuffer)ByteBuffer.wrap(response.getBody()), (boolean)true);
                                            QueryResult qr = new QueryResult(responseHeader.getIndexLastUpdateTimestamp(), wrappers);
                                            try {
                                                lock.writeLock().lock();
                                                queryResultList.add(qr);
                                                break;
                                            }
                                            finally {
                                                lock.writeLock().unlock();
                                            }
                                        }
                                        default: {
                                            log.warn("getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                                            break;
                                        }
                                    }
                                }
                                finally {
                                    countDownLatch.countDown();
                                }
                            }

                            public void operationFail(Throwable throwable) {
                                log.error("queryMessage error, requestHeader={}", (Object)requestHeader);
                                countDownLatch.countDown();
                            }
                        }, isUniqKey);
                    }
                    catch (Exception e) {
                        log.warn("queryMessage exception", (Throwable)e);
                    }
                }
                boolean ok = countDownLatch.await(this.timeoutMillis * 4L, TimeUnit.MILLISECONDS);
                if (!ok) {
                    log.warn("queryMessage, maybe some broker failed");
                }
                long indexLastUpdateTimestamp = 0L;
                LinkedList<MessageExt> messageList = new LinkedList<MessageExt>();
                for (QueryResult qr : queryResultList) {
                    if (qr.getIndexLastUpdateTimestamp() > indexLastUpdateTimestamp) {
                        indexLastUpdateTimestamp = qr.getIndexLastUpdateTimestamp();
                    }
                    for (MessageExt msgExt : qr.getMessageList()) {
                        String[] keyArray;
                        if (isUniqKey) {
                            if (msgExt.getMsgId().equals(key)) {
                                messageList.add(msgExt);
                                continue;
                            }
                            log.warn("queryMessage by uniqKey, find message key not matched, maybe hash duplicate {}", (Object)msgExt.toString());
                            continue;
                        }
                        String keys = msgExt.getKeys();
                        String msgTopic = msgExt.getTopic();
                        if (keys == null) continue;
                        boolean matched = false;
                        for (String k : keyArray = keys.split(" ")) {
                            if (!Objects.equals(key, k) || !isLmq && !Objects.equals(topic, msgTopic)) continue;
                            matched = true;
                            break;
                        }
                        if (matched) {
                            messageList.add(msgExt);
                            continue;
                        }
                        log.warn("queryMessage, find message key not matched, maybe hash duplicate {}", (Object)msgExt.toString());
                    }
                }
                if (null != this.mQClientFactory.getClientConfig().getNamespace()) {
                    for (MessageExt messageExt : messageList) {
                        messageExt.setTopic(NamespaceUtil.withoutNamespace((String)messageExt.getTopic(), (String)this.mQClientFactory.getClientConfig().getNamespace()));
                    }
                }
                if (!messageList.isEmpty()) {
                    return new QueryResult(indexLastUpdateTimestamp, messageList);
                }
                throw new MQClientException(208, "query message by key finished, but no message.");
            }
        }
        throw new MQClientException(17, "The topic[" + topic + "] not matched route info");
    }
}

