/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.util.Formatter;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;
import ucar.unidata.util.Parameter;

public class LambertConformalConicEllipse
extends ProjectionImpl {
    private static final double TOL = 1.0E-10;
    private double lat0deg;
    private double lon0deg;
    private double lat0rad;
    private double lon0rad;
    private double par1deg;
    private double par2deg;
    private double par1rad;
    private double par2rad;
    private double falseEasting;
    private double falseNorthing;
    private Earth earth;
    private double e;
    private double es;
    private double totalScale;
    private double n;
    private double c;
    private double rho0;
    private boolean isSpherical;

    @Override
    public ProjectionImpl constructCopy() {
        LambertConformalConicEllipse result = new LambertConformalConicEllipse(this.getOriginLat(), this.getOriginLon(), this.getParallelOne(), this.getParallelTwo(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarth());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public LambertConformalConicEllipse() {
        this(23.0, -96.0, 29.5, 45.5, 0.0, 0.0, new Earth(6378137.0, 0.0, 298.257222101));
    }

    public LambertConformalConicEllipse(double lat0, double lon0, double par1, double par2, double falseEasting, double falseNorthing, Earth earth) {
        super("LambertConformalConicEllipse", false);
        this.lat0deg = lat0;
        this.lon0deg = lon0;
        this.lat0rad = Math.toRadians(lat0);
        this.lon0rad = Math.toRadians(lat0);
        this.par1deg = par1;
        this.par2deg = par2;
        this.par1rad = Math.toRadians(par1);
        this.par2rad = Math.toRadians(par2);
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.earth = earth;
        this.e = earth.getEccentricity();
        this.es = earth.getEccentricitySquared();
        this.isSpherical = this.e == 0.0;
        this.totalScale = earth.getMajor() * 0.001;
        this.initialize();
        this.addParameter("grid_mapping_name", "lambert_conformal_conic");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (par2 == par1) {
            this.addParameter("standard_parallel", par1);
        } else {
            double[] data = new double[]{par1, par2};
            this.addParameter(new Parameter("standard_parallel", data));
        }
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", earth.getMajor());
        this.addParameter("inverse_flattening", 1.0 / earth.getFlattening());
    }

    private void initialize() {
        if (this.par1rad == 0.0) {
            this.par1rad = this.par2rad = this.lat0rad;
        }
        if (Math.abs(this.par1rad + this.par2rad) < 1.0E-10) {
            throw new IllegalArgumentException("par1rad + par2rad < TOL");
        }
        double sinphi = Math.sin(this.par1rad);
        double cosphi = Math.cos(this.par1rad);
        boolean isSecant = Math.abs(this.par1rad - this.par2rad) >= 1.0E-10;
        this.n = sinphi;
        if (!this.isSpherical) {
            double m1 = MapMath.msfn(sinphi, cosphi, this.es);
            double ml1 = MapMath.tsfn(this.par1rad, sinphi, this.e);
            if (isSecant) {
                sinphi = Math.sin(this.par2rad);
                this.n = Math.log(m1 / MapMath.msfn(sinphi, Math.cos(this.par2rad), this.es));
                this.n /= Math.log(ml1 / MapMath.tsfn(this.par2rad, sinphi, this.e));
            }
            this.c = this.rho0 = m1 * Math.pow(ml1, -this.n) / this.n;
            this.rho0 *= Math.abs(Math.abs(this.lat0rad) - 1.5707963267948966) < 1.0E-10 ? 0.0 : Math.pow(MapMath.tsfn(this.lat0rad, Math.sin(this.lat0rad), this.e), this.n);
        } else {
            if (isSecant) {
                this.n = Math.log(cosphi / Math.cos(this.par2rad)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * this.par2rad) / Math.tan(0.7853981633974483 + 0.5 * this.par1rad));
            }
            this.c = cosphi * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.par1rad), this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.lat0rad) - 1.5707963267948966) < 1.0E-10 ? 0.0 : this.c * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.lat0rad), -this.n);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambertConformalConicEllipse that = (LambertConformalConicEllipse)o;
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.lat0rad, this.lat0rad) != 0) {
            return false;
        }
        if (Double.compare(that.lon0rad, this.lon0rad) != 0) {
            return false;
        }
        if (Double.compare(that.par1rad, this.par1rad) != 0) {
            return false;
        }
        if (Double.compare(that.par2rad, this.par2rad) != 0) {
            return false;
        }
        return this.earth.equals(that.earth);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat0rad);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon0rad);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.par1rad);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.par2rad);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.falseEasting);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.falseNorthing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.earth.hashCode();
        return result;
    }

    public Earth getEarth() {
        return this.earth;
    }

    public double getParallelTwo() {
        return this.par2deg;
    }

    public double getParallelOne() {
        return this.par1deg;
    }

    public double getOriginLon() {
        return this.lon0deg;
    }

    public double getOriginLat() {
        return this.lat0deg;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Lambert Conformal Conic Ellipsoidal Earth";
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat,lon=%f,%f parellels=%f,%f earth=%s", this.lat0deg, this.lon0deg, this.par1deg, this.par2deg, this.earth);
        return f.toString();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2);
    }

    private double computeTheta(double lon) {
        double dlon = LatLonPoints.lonNormal(lon - this.lon0deg);
        return this.n * Math.toRadians(dlon);
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = Math.toRadians(latLon.getLatitude());
        double theta = this.computeTheta(latLon.getLongitude());
        double rho = 0.0;
        if (Math.abs(Math.abs(fromLat) - 1.5707963267948966) >= 1.0E-10) {
            double term = this.isSpherical ? Math.pow(Math.tan(0.7853981633974483 + 0.5 * fromLat), -this.n) : Math.pow(MapMath.tsfn(fromLat, Math.sin(fromLat), this.e), this.n);
            rho = this.c * term;
        }
        double toX = rho * Math.sin(theta);
        double toY = this.rho0 - rho * Math.cos(theta);
        result.setLocation(this.totalScale * toX + this.falseEasting, this.totalScale * toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLon;
        double toLat;
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        double rho = MapMath.distance(fromX, fromY = this.rho0 - fromY);
        if (rho != 0.0) {
            if (this.n < 0.0) {
                rho = -rho;
                fromX = -fromX;
                fromY = -fromY;
            }
            toLat = this.isSpherical ? 2.0 * Math.atan(Math.pow(this.c / rho, 1.0 / this.n)) - 1.5707963267948966 : MapMath.phi2(Math.pow(rho / this.c, 1.0 / this.n), this.e);
            toLon = Math.atan2(fromX, fromY) / this.n;
        } else {
            toLon = 0.0;
            toLat = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        result.setLatitude(Math.toDegrees(toLat));
        result.setLongitude(Math.toDegrees(toLon) + this.lon0deg);
        return result;
    }
}

