/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorAbstract;

public abstract class PointIteratorFromStructureData
extends PointIteratorAbstract {
    private PointFeatureIterator.Filter filter;
    private StructureDataIterator structIter;
    private PointFeature feature;
    private boolean finished;

    protected abstract PointFeature makeFeature(int var1, StructureData var2) throws IOException;

    public PointIteratorFromStructureData(StructureDataIterator structIter, PointFeatureIterator.Filter filter) {
        this.structIter = structIter;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        try {
            StructureData sdata;
            while ((sdata = this.nextStructureData()) != null) {
                this.feature = this.makeFeature(this.structIter.getCurrentRecno(), sdata);
                if (this.feature == null || this.feature.getLocation().isMissing() || this.filter != null && !this.filter.filter(this.feature)) continue;
                return true;
            }
            this.feature = null;
            this.close();
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public PointFeature next() {
        if (this.feature == null) {
            return null;
        }
        this.calcBounds(this.feature);
        return this.feature;
    }

    @Override
    public void close() {
        if (this.finished) {
            return;
        }
        this.finishCalcBounds();
        this.finished = true;
        this.structIter.close();
    }

    private StructureData nextStructureData() throws IOException {
        return this.structIter.hasNext() ? this.structIter.next() : null;
    }
}

