/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.enums.JoinBuildSide;
import org.apache.sedona.core.enums.JoinSpartitionDominantSide;
import org.apache.sedona.core.enums.SpatialJoinOptimizationMode;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils;
import org.locationtech.jts.geom.Envelope;

public class SedonaConf
implements Serializable {
    private boolean useIndex;
    private IndexType indexType;
    private JoinSpartitionDominantSide joinSpartitionDominantSide;
    private JoinBuildSide joinBuildSide;
    private long joinApproximateTotalCount;
    private Envelope datasetBoundary;
    private int fallbackPartitionNum;
    private GridType joinGridType;
    private long autoBroadcastJoinThreshold;
    private SpatialJoinOptimizationMode spatialJoinOptimizationMode;
    private boolean includeTieBreakersInKNNJoins = false;

    public static SedonaConf fromActiveSession() {
        return new SedonaConf(SparkSession.active().conf());
    }

    public SedonaConf(RuntimeConfig runtimeConfig) {
        this.useIndex = Boolean.parseBoolean(this.getConfigValue(runtimeConfig, "global.index", "true"));
        this.indexType = IndexType.getIndexType(this.getConfigValue(runtimeConfig, "global.indextype", "rtree"));
        this.joinApproximateTotalCount = Long.parseLong(this.getConfigValue(runtimeConfig, "join.approxcount", "-1"));
        String[] boundaryString = this.getConfigValue(runtimeConfig, "join.boundary", "0,0,0,0").split(",");
        this.datasetBoundary = new Envelope(Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[1]), Double.parseDouble(boundaryString[2]), Double.parseDouble(boundaryString[3]));
        this.joinGridType = GridType.getGridType(this.getConfigValue(runtimeConfig, "join.gridtype", "kdbtree"));
        this.joinBuildSide = JoinBuildSide.getBuildSide(this.getConfigValue(runtimeConfig, "join.indexbuildside", "left"));
        this.joinSpartitionDominantSide = JoinSpartitionDominantSide.getJoinSpartitionDominantSide(this.getConfigValue(runtimeConfig, "join.spatitionside", "left"));
        this.fallbackPartitionNum = Integer.parseInt(this.getConfigValue(runtimeConfig, "join.numpartition", "-1"));
        this.autoBroadcastJoinThreshold = SedonaConf.bytesFromString(this.getConfigValue(runtimeConfig, "join.autoBroadcastJoinThreshold", runtimeConfig.get("spark.sql.autoBroadcastJoinThreshold")));
        this.spatialJoinOptimizationMode = SpatialJoinOptimizationMode.getSpatialJoinOptimizationMode(this.getConfigValue(runtimeConfig, "join.optimizationmode", "nonequi"));
        this.includeTieBreakersInKNNJoins = Boolean.parseBoolean(this.getConfigValue(runtimeConfig, "join.knn.includeTieBreakers", "false"));
    }

    private String getConfigValue(RuntimeConfig runtimeConfig, String keySuffix, String defaultValue) {
        String sedonaKey = "sedona." + keySuffix;
        String sparkSedonaKey = "spark.sedona." + keySuffix;
        if (runtimeConfig.contains(sedonaKey)) {
            return runtimeConfig.get(sedonaKey, defaultValue);
        }
        return runtimeConfig.get(sparkSedonaKey, defaultValue);
    }

    public boolean getUseIndex() {
        return this.useIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public long getJoinApproximateTotalCount() {
        return this.joinApproximateTotalCount;
    }

    public Envelope getDatasetBoundary() {
        return this.datasetBoundary;
    }

    public JoinBuildSide getJoinBuildSide() {
        return this.joinBuildSide;
    }

    public GridType getJoinGridType() {
        return this.joinGridType;
    }

    public JoinSpartitionDominantSide getJoinSpartitionDominantSide() {
        return this.joinSpartitionDominantSide;
    }

    public int getFallbackPartitionNum() {
        return this.fallbackPartitionNum;
    }

    public long getAutoBroadcastJoinThreshold() {
        return this.autoBroadcastJoinThreshold;
    }

    public boolean isIncludeTieBreakersInKNNJoins() {
        return this.includeTieBreakersInKNNJoins;
    }

    public String toString() {
        try {
            Field[] fields;
            String sb = "";
            Class<?> objClass = this.getClass();
            sb = sb + "Sedona Configuration:\n";
            for (Field field : fields = objClass.getDeclaredFields()) {
                String name = field.getName();
                Object value = field.get(this);
                sb = sb + name + ": " + value.toString() + "\n";
            }
            return sb;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static long bytesFromString(String str) {
        if (str.startsWith("-")) {
            return -1L * Utils.byteStringAsBytes((String)str.substring(1));
        }
        return Utils.byteStringAsBytes((String)str);
    }

    public SpatialJoinOptimizationMode getSpatialJoinOptimizationMode() {
        return this.spatialJoinOptimizationMode;
    }
}

