/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.stats.outlierDetection;

import java.io.Serializable;
import org.apache.sedona.stats.Util$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sedona_sql.expressions.st_functions$;
import scala.Function2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LocalOutlierFactor$ {
    public static final LocalOutlierFactor$ MODULE$ = new LocalOutlierFactor$();
    private static final String ID_COLUMN_NAME = "__id";
    private static final String CONTENTS_COLUMN_NAME = "__contents";

    private String ID_COLUMN_NAME() {
        return ID_COLUMN_NAME;
    }

    private String CONTENTS_COLUMN_NAME() {
        return CONTENTS_COLUMN_NAME;
    }

    public Dataset<Row> localOutlierFactor(Dataset<Row> dataframe, int k, String geometry, boolean handleTies, boolean useSpheroid) {
        Dataset ret;
        block3: {
            String string;
            if (k < 1) {
                throw new IllegalArgumentException("k must be a positive integer");
            }
            if (handleTies) {
                String prior = ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().get("spark.sedona.join.knn.includeTieBreakers", "false");
                ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().set("spark.sedona.join.knn.includeTieBreakers", true);
                string = prior;
            } else {
                string = "false";
            }
            String prior = string;
            Function2 & Serializable distanceFunction = useSpheroid ? (Function2 & Serializable)(a, b) -> st_functions$.MODULE$.ST_DistanceSpheroid((Column)a, (Column)b) : (Function2 & Serializable)(a, b) -> st_functions$.MODULE$.ST_Distance((Column)a, (Column)b);
            String useSpheroidString = useSpheroid ? "True" : "False";
            String geometryColumn = geometry == null ? Util$.MODULE$.getGeometryColumnName(dataframe) : geometry;
            String KNNFunction = "ST_KNN";
            Dataset formattedDataframe = dataframe.withColumn(this.CONTENTS_COLUMN_NAME(), functions$.MODULE$.struct("*", (Seq)Nil$.MODULE$)).withColumn(this.ID_COLUMN_NAME(), functions$.MODULE$.sha2(functions$.MODULE$.to_json(functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME())), 256)).withColumnRenamed(geometryColumn, "geometry");
            Dataset kDistanceDf = formattedDataframe.alias("l").join(formattedDataframe.alias("r"), functions$.MODULE$.expr(new StringBuilder(32).append(KNNFunction).append("(l.geometry, r.geometry, ").append(k).append(" + 1, ").append(useSpheroidString).append(")").toString()).$amp$amp((Object)functions$.MODULE$.col(new StringBuilder(2).append("l.").append(this.ID_COLUMN_NAME()).toString()).$eq$bang$eq((Object)functions$.MODULE$.col(new StringBuilder(2).append("r.").append(this.ID_COLUMN_NAME()).toString())))).groupBy(new StringBuilder(2).append("l.").append(this.ID_COLUMN_NAME()).toString(), (Seq)Nil$.MODULE$).agg(functions$.MODULE$.first("l.geometry").alias("geometry"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.first(new StringBuilder(2).append("l.").append(this.CONTENTS_COLUMN_NAME()).toString()).alias(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.max((Column)distanceFunction.apply((Object)functions$.MODULE$.col("l.geometry"), (Object)functions$.MODULE$.col("r.geometry"))).alias("k_distance"), functions$.MODULE$.collect_list(new StringBuilder(2).append("r.").append(this.ID_COLUMN_NAME()).toString()).alias("neighbors")})).checkpoint();
            Dataset lrdDf = kDistanceDf.alias("A").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.ID_COLUMN_NAME()).alias("a_id"), functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.col("geometry").alias("a_geometry"), functions$.MODULE$.explode(functions$.MODULE$.col("neighbors")).alias("n_id")})).join(kDistanceDf.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.ID_COLUMN_NAME()).alias("b_id"), functions$.MODULE$.col("geometry").alias("b_geometry"), functions$.MODULE$.col("k_distance").alias("b_k_distance")})), functions$.MODULE$.expr("n_id = b_id")).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a_id"), functions$.MODULE$.col("b_id"), functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.array_max(functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b_k_distance"), (Column)distanceFunction.apply((Object)functions$.MODULE$.col("a_geometry"), (Object)functions$.MODULE$.col("b_geometry"))}))).alias("rd")})).groupBy("a_id", (Seq)Nil$.MODULE$).agg(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)).$div((Object)functions$.MODULE$.mean("rd").$plus((Object)BoxesRunTime.boxToDouble((double)1.0E-10))).alias("lrd"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.collect_list(functions$.MODULE$.col("b_id")).alias("neighbors"), functions$.MODULE$.first(this.CONTENTS_COLUMN_NAME()).alias(this.CONTENTS_COLUMN_NAME())}));
            ret = lrdDf.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a_id"), functions$.MODULE$.col("lrd").alias("a_lrd"), functions$.MODULE$.col(this.CONTENTS_COLUMN_NAME()), functions$.MODULE$.explode(functions$.MODULE$.col("neighbors")).alias("n_id")})).join(lrdDf.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a_id").alias("b_id"), functions$.MODULE$.col("lrd").alias("b_lrd")})), functions$.MODULE$.expr("n_id = b_id")).groupBy("a_id", (Seq)Nil$.MODULE$).agg(functions$.MODULE$.first(this.CONTENTS_COLUMN_NAME()).alias(this.CONTENTS_COLUMN_NAME()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("b_lrd").$div((Object)functions$.MODULE$.count("b_lrd").$times((Object)functions$.MODULE$.first("a_lrd"))).alias("lof")})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(this.CONTENTS_COLUMN_NAME()).append(".*").toString()), functions$.MODULE$.col("lof")}));
            if (!handleTies) break block3;
            ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().set("spark.sedona.join.knn.includeTieBreakers", prior);
        }
        return ret;
    }

    public int localOutlierFactor$default$2() {
        return 20;
    }

    public String localOutlierFactor$default$3() {
        return null;
    }

    public boolean localOutlierFactor$default$4() {
        return false;
    }

    public boolean localOutlierFactor$default$5() {
        return false;
    }

    private LocalOutlierFactor$() {
    }
}

