/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.operation.relateng.NodeSection;

class PolygonNodeConverter {
    PolygonNodeConverter() {
    }

    public static List<NodeSection> convert(List<NodeSection> polySections) {
        polySections.sort(new NodeSection.EdgeAngleComparator());
        List<NodeSection> sections = PolygonNodeConverter.extractUnique(polySections);
        if (sections.size() == 1) {
            return sections;
        }
        int shellIndex = PolygonNodeConverter.findShell(sections);
        if (shellIndex < 0) {
            return PolygonNodeConverter.convertHoles(sections);
        }
        ArrayList<NodeSection> convertedSections = new ArrayList<NodeSection>();
        int nextShellIndex = shellIndex;
        while ((nextShellIndex = PolygonNodeConverter.convertShellAndHoles(sections, nextShellIndex, convertedSections)) != shellIndex) {
        }
        return convertedSections;
    }

    private static int convertShellAndHoles(List<NodeSection> sections, int shellIndex, List<NodeSection> convertedSections) {
        NodeSection ns;
        Coordinate outVertex;
        NodeSection shellSection = sections.get(shellIndex);
        Coordinate inVertex = shellSection.getVertex(0);
        int i = PolygonNodeConverter.next(sections, shellIndex);
        NodeSection holeSection = null;
        while (!sections.get(i).isShell()) {
            holeSection = sections.get(i);
            outVertex = holeSection.getVertex(1);
            ns = PolygonNodeConverter.createSection(shellSection, inVertex, outVertex);
            convertedSections.add(ns);
            inVertex = holeSection.getVertex(0);
            i = PolygonNodeConverter.next(sections, i);
        }
        outVertex = shellSection.getVertex(1);
        ns = PolygonNodeConverter.createSection(shellSection, inVertex, outVertex);
        convertedSections.add(ns);
        return i;
    }

    private static List<NodeSection> convertHoles(List<NodeSection> sections) {
        ArrayList<NodeSection> convertedSections = new ArrayList<NodeSection>();
        NodeSection copySection = sections.get(0);
        for (int i = 0; i < sections.size(); ++i) {
            int inext = PolygonNodeConverter.next(sections, i);
            Coordinate inVertex = sections.get(i).getVertex(0);
            Coordinate outVertex = sections.get(inext).getVertex(1);
            NodeSection ns = PolygonNodeConverter.createSection(copySection, inVertex, outVertex);
            convertedSections.add(ns);
        }
        return convertedSections;
    }

    private static NodeSection createSection(NodeSection ns, Coordinate v0, Coordinate v1) {
        return new NodeSection(ns.isA(), 2, ns.id(), 0, ns.getPolygonal(), ns.isNodeAtVertex(), v0, ns.nodePt(), v1);
    }

    private static List<NodeSection> extractUnique(List<NodeSection> sections) {
        ArrayList<NodeSection> uniqueSections = new ArrayList<NodeSection>();
        NodeSection lastUnique = sections.get(0);
        uniqueSections.add(lastUnique);
        for (NodeSection ns : sections) {
            if (0 == lastUnique.compareTo(ns)) continue;
            uniqueSections.add(ns);
            lastUnique = ns;
        }
        return uniqueSections;
    }

    private static int next(List<NodeSection> ns, int i) {
        int next = i + 1;
        if (next >= ns.size()) {
            next = 0;
        }
        return next;
    }

    private static int findShell(List<NodeSection> polySections) {
        for (int i = 0; i < polySections.size(); ++i) {
            if (!polySections.get(i).isShell()) continue;
            return i;
        }
        return -1;
    }
}

